/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.SpaceOwnerKind;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractSpacePredicate;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import java.util.List;

public abstract class AbstractTechIdPredicate
extends AbstractSpacePredicate<TechId> {
    protected final SpaceOwnerKind entityKind;

    public AbstractTechIdPredicate(SpaceOwnerKind entityKind) {
        this.entityKind = entityKind;
    }

    public static AbstractTechIdPredicate create(SpaceOwnerKind entityKind) {
        switch (entityKind) {
            case DATASET: {
                return new DataSetTechIdPredicate();
            }
            case EXPERIMENT: {
                return new ExperimentTechIdPredicate();
            }
            case PROJECT: {
                return new ProjectTechIdPredicate();
            }
            case SPACE: {
                return new SpaceTechIdPredicate();
            }
        }
        return null;
    }

    @Override
    public final String getCandidateDescription() {
        return "technical id";
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, TechId techId) {
        assert (this.initialized) : "Predicate has not been initialized";
        SpacePE spaceOrNull = this.authorizationDataProvider.tryGetSpace(this.entityKind, techId);
        return this.evaluateSpace(person, allowedRoles, spaceOrNull);
    }

    public static class DataSetTechIdPredicate
    extends AbstractTechIdPredicate {
        public DataSetTechIdPredicate() {
            super(SpaceOwnerKind.DATASET);
        }
    }

    public static class ExperimentTechIdPredicate
    extends AbstractTechIdPredicate {
        public ExperimentTechIdPredicate() {
            super(SpaceOwnerKind.EXPERIMENT);
        }
    }

    public static class ProjectTechIdPredicate
    extends AbstractTechIdPredicate {
        public ProjectTechIdPredicate() {
            super(SpaceOwnerKind.PROJECT);
        }
    }

    public static class SpaceTechIdPredicate
    extends AbstractTechIdPredicate {
        public SpaceTechIdPredicate() {
            super(SpaceOwnerKind.SPACE);
        }
    }
}

