/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.common.conversation.context.ServiceConversationsThreadContext;
import ch.systemsx.cisd.openbis.common.conversation.progress.IServiceConversationProgressListener;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.DataSetUpdatesCollectionPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ExistingSpaceIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ExperimentUpdatesPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.NewExperimentPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.NewProjectPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.NewSamplePredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ProjectUpdatesPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleOwnerIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleUpdatesCollectionPredicate;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewExperiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewProject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.dto.AtomicEntityOperationDetails;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewExternalData;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import java.util.List;

public class AtomicOperationsPredicate
extends AbstractPredicate<AtomicEntityOperationDetails> {
    private final NewExperimentPredicate newExperimentPredicate = new NewExperimentPredicate();
    private final ExperimentUpdatesPredicate experimentUpdatesPredicate = new ExperimentUpdatesPredicate();
    private final NewSamplePredicate newSamplePredicate = new NewSamplePredicate();
    private final SampleUpdatesCollectionPredicate sampleUpdatesPredicate = new SampleUpdatesCollectionPredicate();
    private final SampleOwnerIdentifierPredicate sampleOwnerIdentifierPredicate = new SampleOwnerIdentifierPredicate(true, true);
    private final ExistingSpaceIdentifierPredicate experimentOwnerIdentifierPredicate = new ExistingSpaceIdentifierPredicate();
    private final DataSetUpdatesCollectionPredicate dataSetUpdatesCollectionPredicate = new DataSetUpdatesCollectionPredicate();
    private final NewProjectPredicate newProjectPredicate = new NewProjectPredicate();
    private final ProjectUpdatesPredicate projectUpdatePredicate = new ProjectUpdatesPredicate();

    @Override
    public void init(IAuthorizationDataProvider provider) {
        this.newExperimentPredicate.init(provider);
        this.experimentUpdatesPredicate.init(provider);
        this.newSamplePredicate.init(provider);
        this.sampleUpdatesPredicate.init(provider);
        this.sampleOwnerIdentifierPredicate.init(provider);
        this.experimentOwnerIdentifierPredicate.init(provider);
        this.dataSetUpdatesCollectionPredicate.init(provider);
        this.newProjectPredicate.init(provider);
        this.projectUpdatePredicate.init(provider);
    }

    @Override
    public String getCandidateDescription() {
        return "atomic entity operations";
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, AtomicEntityOperationDetails value) {
        AtomicOperationsPredicateEvaluator evaluator = new AtomicOperationsPredicateEvaluator(this, person, allowedRoles, value);
        return evaluator.evaluate();
    }

    private static class AtomicOperationsPredicateEvaluator {
        private final AtomicOperationsPredicate predicate;
        private final PersonPE person;
        private final List<RoleWithIdentifier> allowedRoles;
        private final AtomicEntityOperationDetails value;
        private final Status instanceWriteStatus;
        private final IServiceConversationProgressListener progressListener;
        private Status result = Status.OK;

        public AtomicOperationsPredicateEvaluator(AtomicOperationsPredicate predicate, PersonPE person, List<RoleWithIdentifier> allowedRoles, AtomicEntityOperationDetails value) {
            this.predicate = predicate;
            this.person = person;
            this.allowedRoles = allowedRoles;
            this.value = value;
            this.instanceWriteStatus = AtomicOperationsPredicate.hasInstanceWritePermissions(person, allowedRoles);
            this.progressListener = ServiceConversationsThreadContext.getProgressListener();
        }

        public Status evaluate() {
            if (this.instanceWriteStatus.isOK()) {
                return this.instanceWriteStatus;
            }
            if (this.result.equals(Status.OK)) {
                this.result = this.evaluateExperimentUpdatePredicate();
            }
            if (this.result.equals(Status.OK)) {
                this.result = this.evaluateNewExperimentPredicate();
            }
            if (this.result.equals(Status.OK)) {
                this.result = this.evaluateSampleUpdatePredicate();
            }
            if (this.result.equals(Status.OK)) {
                this.result = this.evaluateNewSamplePredicate();
            }
            if (this.result.equals(Status.OK)) {
                this.result = this.evaluateDataSetRegistrationsPredicate();
            }
            if (this.result.equals(Status.OK)) {
                this.result = this.evaluateDataSetUpdatesPredicate();
            }
            if (this.result.equals(Status.OK)) {
                this.result = this.evaluateSpaceRegistrations();
            }
            if (this.result.equals(Status.OK)) {
                this.result = this.evaluateProjectRegistrations();
            }
            if (this.result.equals(Status.OK)) {
                this.result = this.evaluateProjectUpdates();
            }
            if (this.result.equals(Status.OK)) {
                this.result = this.evaluateMaterialRegistrations();
            }
            if (this.result.equals(Status.OK)) {
                this.result = this.evaluateMaterialUpdates();
            }
            return this.result;
        }

        private Status evaluateSpaceRegistrations() {
            if (this.value.getSpaceRegistrations() != null && this.value.getSpaceRegistrations().size() > 0) {
                return this.instanceWriteStatus;
            }
            return Status.OK;
        }

        private Status evaluateProjectRegistrations() {
            if (this.value.getProjectRegistrations() != null && this.value.getProjectRegistrations().size() > 0) {
                int index = 0;
                for (NewProject newProject : this.value.getProjectRegistrations()) {
                    Status status = this.predicate.newProjectPredicate.doEvaluation(this.person, this.allowedRoles, newProject);
                    if (!status.equals(Status.OK)) {
                        return status;
                    }
                    this.progressListener.update("authorizeProjectRegistrations", this.value.getExperimentUpdates().size(), ++index);
                }
                return Status.OK;
            }
            return Status.OK;
        }

        private Status evaluateProjectUpdates() {
            if (this.value.getProjectUpdates() != null && this.value.getProjectUpdates().size() > 0) {
                int index = 0;
                for (ProjectUpdatesDTO projectToUpdate : this.value.getProjectUpdates()) {
                    Status status = this.predicate.projectUpdatePredicate.doEvaluation(this.person, this.allowedRoles, projectToUpdate);
                    if (!status.equals(Status.OK)) {
                        return status;
                    }
                    this.progressListener.update("authorizeProjectUpdates", this.value.getExperimentUpdates().size(), ++index);
                }
                return Status.OK;
            }
            return Status.OK;
        }

        private Status evaluateMaterialRegistrations() {
            if (this.value.getMaterialRegistrations() != null && this.value.getMaterialRegistrations().size() > 0) {
                return this.instanceWriteStatus;
            }
            return Status.OK;
        }

        private Status evaluateMaterialUpdates() {
            if (this.value.getMaterialUpdates() != null && this.value.getMaterialUpdates().size() > 0) {
                return this.instanceWriteStatus;
            }
            return Status.OK;
        }

        private Status evaluateExperimentUpdatePredicate() {
            int index = 0;
            for (ExperimentUpdatesDTO experimentUpdates : this.value.getExperimentUpdates()) {
                Status status = this.predicate.experimentUpdatesPredicate.doEvaluation(this.person, this.allowedRoles, experimentUpdates);
                if (!status.equals(Status.OK)) {
                    return status;
                }
                this.progressListener.update("authorizeExperimentUpdates", this.value.getExperimentUpdates().size(), ++index);
            }
            return Status.OK;
        }

        private Status evaluateNewExperimentPredicate() {
            int index = 0;
            for (NewExperiment newExperiment : this.value.getExperimentRegistrations()) {
                Status status = this.predicate.newExperimentPredicate.doEvaluation(this.person, this.allowedRoles, newExperiment);
                if (!status.equals(Status.OK)) {
                    return status;
                }
                this.progressListener.update("authorizeExperimentRegistration", this.value.getExperimentUpdates().size(), ++index);
            }
            return Status.OK;
        }

        private Status evaluateSampleUpdatePredicate() {
            return this.predicate.sampleUpdatesPredicate.doEvaluation(this.person, this.allowedRoles, this.value.getSampleUpdates());
        }

        private Status evaluateNewSamplePredicate() {
            int index = 0;
            for (NewSample newSample : this.value.getSampleRegistrations()) {
                Status status = this.predicate.newSamplePredicate.doEvaluation(this.person, this.allowedRoles, newSample);
                if (!status.equals(Status.OK)) {
                    return status;
                }
                this.progressListener.update("authorizeSampleRegistration", this.value.getExperimentUpdates().size(), ++index);
            }
            return Status.OK;
        }

        private Status evaluateDataSetRegistrationsPredicate() {
            int index = 0;
            for (NewExternalData newExternalData : this.value.getDataSetRegistrations()) {
                Status status = this.evaluateDataSetPredicate(newExternalData.getSampleIdentifierOrNull(), newExternalData.getExperimentIdentifierOrNull());
                if (!status.equals(Status.OK)) {
                    return status;
                }
                this.progressListener.update("authorizeDatasetRegistration", this.value.getExperimentUpdates().size(), ++index);
            }
            return Status.OK;
        }

        private Status evaluateDataSetUpdatesPredicate() {
            return this.predicate.dataSetUpdatesCollectionPredicate.doEvaluation(this.person, this.allowedRoles, this.value.getDataSetUpdates());
        }

        private Status evaluateDataSetPredicate(SampleIdentifier sampleIdentifier, ExperimentIdentifier experimentIdentifier) {
            Status status = sampleIdentifier != null ? this.predicate.sampleOwnerIdentifierPredicate.doEvaluation(this.person, this.allowedRoles, sampleIdentifier) : this.predicate.experimentOwnerIdentifierPredicate.doEvaluation(this.person, this.allowedRoles, experimentIdentifier);
            return status;
        }
    }
}

