/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.DatabaseInstanceIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SpaceIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleOwnerIdentifier;
import java.util.List;

public class SampleOwnerIdentifierPredicate
extends AbstractPredicate<SampleOwnerIdentifier> {
    private final SpaceIdentifierPredicate spacePredicate;
    private final DatabaseInstanceIdentifierPredicate databaseInstanceIdentifierPredicate;
    boolean initialized;

    public SampleOwnerIdentifierPredicate() {
        this(true, false);
    }

    public SampleOwnerIdentifierPredicate(boolean isReadAccess) {
        this(isReadAccess, false);
    }

    public SampleOwnerIdentifierPredicate(boolean isReadAccess, boolean okForNonExistentSpaces) {
        this.spacePredicate = new SpaceIdentifierPredicate(okForNonExistentSpaces);
        this.databaseInstanceIdentifierPredicate = new DatabaseInstanceIdentifierPredicate(isReadAccess);
    }

    @Override
    public final void init(IAuthorizationDataProvider provider) {
        assert (!this.initialized);
        this.spacePredicate.init(provider);
        this.databaseInstanceIdentifierPredicate.init(provider);
        this.initialized = true;
    }

    @Override
    public final String getCandidateDescription() {
        return "sample identifier";
    }

    @Override
    protected final Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, SampleOwnerIdentifier value) {
        return this.performEvaluation(person, allowedRoles, value);
    }

    @Deprecated
    public Status performEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, SampleOwnerIdentifier value) {
        if (SampleOwnerIdentifierPredicate.hasInstanceWritePermissions(person, allowedRoles).isOK()) {
            return Status.OK;
        }
        if (value.isDatabaseInstanceLevel()) {
            return this.databaseInstanceIdentifierPredicate.doEvaluation(person, allowedRoles, value.getDatabaseInstanceLevel());
        }
        return this.spacePredicate.doEvaluation(person, allowedRoles, value.getSpaceLevel());
    }
}

