/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.validator;

import ch.systemsx.cisd.openbis.generic.server.authorization.validator.AbstractValidator;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.RoleAssignmentPE;

public class StorageConfirmedForAdminValidator
extends AbstractValidator<AbstractExternalData> {
    private static boolean isPersonAllowedForNotConfirmed(PersonPE person) {
        for (RoleAssignmentPE role : person.getAllPersonRoles()) {
            if (role.getRole() != RoleWithHierarchy.RoleCode.ADMIN && role.getRole() != RoleWithHierarchy.RoleCode.ETL_SERVER) continue;
            return true;
        }
        return false;
    }

    public static boolean isValid(PersonPE person, boolean isStorageConfirmed) {
        return isStorageConfirmed || StorageConfirmedForAdminValidator.isPersonAllowedForNotConfirmed(person);
    }

    @Override
    public boolean doValidation(PersonPE person, AbstractExternalData value) {
        return StorageConfirmedForAdminValidator.isValid(person, value.isStorageConfirmation());
    }
}

