/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.coreplugin;

import ch.systemsx.cisd.base.unix.Unix;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.PropertyParametersUtil;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.generic.server.coreplugin.CorePluginsInjectingPropertyPlaceholderConfigurer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CorePlugin;
import ch.systemsx.cisd.openbis.generic.shared.coreplugin.CorePluginScanner;
import ch.systemsx.cisd.openbis.generic.shared.coreplugin.CorePluginsUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class JettyWebAppPluginInjector {
    private static final String WEBAPP_FOLDER = "webapp";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, JettyWebAppPluginInjector.class);
    private final List<String> webapps;
    private final Map<String, Properties> webappProperties;
    public static final String WEB_APP_FOLDER_PROPERTY = "webapp-folder";
    private Map<String, File> webappToFoldersMap;

    private static Map<String, Properties> extractWebappProperties(Properties props, List<String> webapps) {
        HashMap<String, Properties> map = new HashMap<String, Properties>();
        for (String webapp : webapps) {
            Properties webappProperties = PropertyParametersUtil.extractSingleSectionProperties(props, webapp, false).getProperties();
            map.put(webapp, webappProperties);
        }
        return map;
    }

    public JettyWebAppPluginInjector(Properties props) {
        List<String> appList = PropertyUtils.tryGetListInOriginalCase(props, "webapps");
        this.webapps = appList == null ? Collections.emptyList() : appList;
        this.webappProperties = JettyWebAppPluginInjector.extractWebappProperties(props, this.webapps);
        this.webappToFoldersMap = new HashMap<String, File>();
        String corePluginsFolder = CorePluginsUtils.getCorePluginsFolder(props, CorePluginScanner.ScannerType.AS);
        CorePluginScanner scanner = new CorePluginScanner(corePluginsFolder, CorePluginScanner.ScannerType.AS);
        List<CorePlugin> plugins = scanner.scanForPlugins();
        block0: for (CorePlugin plugin : plugins) {
            File[] pluginFolders;
            File webappsFolder = new File(corePluginsFolder, CorePluginScanner.constructPath(plugin, CorePluginScanner.ScannerType.AS, CorePluginsInjectingPropertyPlaceholderConfigurer.PLUGIN_TYPE_WEBAPPS));
            if (!webappsFolder.isDirectory()) continue;
            File[] fileArray = pluginFolders = webappsFolder.listFiles();
            int n = pluginFolders.length;
            int n2 = 0;
            while (n2 < n) {
                File folder = fileArray[n2];
                String webappName = folder.getName();
                if (!webappName.startsWith(".")) {
                    Properties webappProps = this.webappProperties.get(webappName);
                    if (webappProps == null) continue block0;
                    String f = webappProps.getProperty(WEB_APP_FOLDER_PROPERTY);
                    this.webappToFoldersMap.put(webappName, new File(f));
                }
                ++n2;
            }
        }
    }

    public void injectWebApps() {
        operationLog.info((Object)("Inject the following web apps: " + this.webapps));
        if (this.webapps.isEmpty()) {
            return;
        }
        List<File> targets = this.findInjectionTargets();
        for (String webapp : this.webapps) {
            File folder = this.webappToFoldersMap.get(webapp);
            if (folder == null) continue;
            String path = folder.getAbsolutePath();
            for (File target : targets) {
                File link = new File(target, webapp);
                if (link.exists()) continue;
                String linkPath = link.getAbsolutePath();
                Unix.createSymbolicLink((String)path, (String)linkPath);
                operationLog.info((Object)("WebApp '" + webapp + "': Symbolic link " + linkPath + " -> " + path));
            }
        }
    }

    private List<File> findInjectionTargets() {
        ArrayList<File> list = new ArrayList<File>();
        String jettyHome = System.getProperty("jetty.home");
        if (jettyHome != null) {
            File webappFolder = new File(String.valueOf(jettyHome) + "/webapps/openbis/" + WEBAPP_FOLDER);
            webappFolder.mkdirs();
            list.add(webappFolder);
        } else {
            File[] files;
            File[] fileArray = files = new File("targets/www").listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (!file.getName().equals("WEB-INF")) {
                    File webappFolder = new File(file, WEBAPP_FOLDER);
                    webappFolder.mkdirs();
                    list.add(webappFolder);
                }
                ++n2;
            }
        }
        return list;
    }
}

