/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.StringTokenizer;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.search.annotations.IndexedEmbedded;

public class IndexingQueryOptimizer {
    private static int DEFAULT_MAX_DEPTH = 4;

    private IndexingQueryOptimizer() {
    }

    public static Criteria minimizeAmountOfSubqueries(Class<?> clazz, Criteria criteria, int maxDepth) {
        IndexingQueryOptimizer.minimizeAmountOfSubqueries(clazz, criteria, maxDepth, "");
        return criteria;
    }

    public static Criteria minimizeAmountOfSubqueries(Class<?> clazz, Criteria criteria) {
        IndexingQueryOptimizer.minimizeAmountOfSubqueries(clazz, criteria, DEFAULT_MAX_DEPTH, "");
        return criteria;
    }

    private static void minimizeAmountOfSubqueries(Class<?> clazz, Criteria criteria, int maxDepth, String path) {
        Class<?> iterClass = clazz;
        while (iterClass != null) {
            Method[] methodArray = iterClass.getDeclaredMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (!method.getReturnType().equals(iterClass)) {
                    IndexingQueryOptimizer.addFetchMode(method, criteria, maxDepth, path);
                }
                ++n2;
            }
            iterClass = iterClass.getSuperclass();
        }
    }

    private static void addFetchMode(Method method, Criteria criteria, int maxDepth, String path) {
        if (IndexingQueryOptimizer.propertyNeedsJoinedFetch(method)) {
            String newPath = IndexingQueryOptimizer.calculatePath(path, method);
            if (IndexingQueryOptimizer.depthOf(newPath) > maxDepth) {
                return;
            }
            System.out.println("fetch: " + newPath);
            criteria.setFetchMode(newPath, FetchMode.JOIN);
            Class clazz = method.getReturnType();
            if (IndexingQueryOptimizer.isCollection(clazz)) {
                ParameterizedType t = (ParameterizedType)method.getGenericReturnType();
                clazz = (Class)t.getActualTypeArguments()[0];
            }
            IndexingQueryOptimizer.minimizeAmountOfSubqueries(clazz, criteria, maxDepth, newPath);
        }
    }

    private static boolean isCollection(Class<?> clazz) {
        Class<?>[] classArray = clazz.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            if (c.equals(Collection.class)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static int depthOf(String path) {
        StringTokenizer tokenizer = new StringTokenizer(path, ".");
        return tokenizer.countTokens();
    }

    private static boolean propertyNeedsJoinedFetch(Method method) {
        if (IndexingQueryOptimizer.isAnnotatedToBeEagerlyFetched(method)) {
            return true;
        }
        return IndexingQueryOptimizer.isAnnotatedToBeIndexedEmbedded(method);
    }

    private static boolean isAnnotatedToBeIndexedEmbedded(Method method) {
        return method.getAnnotation(IndexedEmbedded.class) != null;
    }

    private static boolean isAnnotatedToBeEagerlyFetched(Method method) {
        FetchType ft = FetchType.LAZY;
        ManyToOne mto = method.getAnnotation(ManyToOne.class);
        ManyToMany mtm = method.getAnnotation(ManyToMany.class);
        OneToOne oto = method.getAnnotation(OneToOne.class);
        OneToMany otm = method.getAnnotation(OneToMany.class);
        if (mto != null) {
            ft = mto.fetch();
        } else if (mtm != null) {
            ft = mtm.fetch();
        } else if (oto != null) {
            ft = oto.fetch();
        } else if (otm != null) {
            ft = otm.fetch();
        }
        return FetchType.EAGER.equals((Object)ft);
    }

    private static String calculatePath(String path, Method method) {
        String name = method.getName();
        if (name.startsWith("get")) {
            if (path.length() == 0) {
                return IndexingQueryOptimizer.getPropertyNameFromGetter(method);
            }
            return String.valueOf(path) + "." + IndexingQueryOptimizer.getPropertyNameFromGetter(method);
        }
        throw new IllegalArgumentException("Not a getter: " + name);
    }

    private static String getPropertyNameFromGetter(Method method) {
        String name = method.getName().substring(3);
        String first = name.substring(0, 1).toLowerCase();
        return String.valueOf(first) + name.substring(1);
    }
}

