/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.jython.api.v1.impl;

import ch.systemsx.cisd.openbis.generic.server.jython.api.v1.IScriptImmutable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseInstance;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PluginType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Script;

public class ScriptImmutable
implements IScriptImmutable {
    protected final Script script;

    ScriptImmutable(Script script) {
        this.script = script;
    }

    ScriptImmutable() {
        this(new Script());
        this.script.setPluginType(PluginType.JYTHON);
    }

    @Override
    public String getEntity() {
        Enum kind = this.script.getEntityKind() == null || this.script.getEntityKind().length != 1 ? null : this.script.getEntityKind()[0];
        return kind == null ? null : kind.toString();
    }

    @Override
    public String getDescription() {
        return this.script.getDescription();
    }

    @Override
    public String getName() {
        return this.script.getName();
    }

    @Override
    public String getScript() {
        return this.script.getScript();
    }

    public DatabaseInstance getDatabaseInstance() {
        return this.script.getDatabaseInstance();
    }

    public Long getId() {
        return this.script.getId();
    }

    @Override
    public String getScriptType() {
        return this.script.getScriptType().name();
    }

    public String toString() {
        return this.script.toString();
    }

    public int compareTo(Script o) {
        if (o == null) {
            return -1;
        }
        return this.toString().compareTo(o.toString());
    }

    @Override
    public String getCode() {
        return this.script.getName();
    }
}

