/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import javax.persistence.Entity;
import javax.persistence.EntityResult;
import javax.persistence.Id;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.SqlResultSetMapping;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@Entity
@SqlResultSetMapping(name="sample_access_implicit", entities={@EntityResult(entityClass=SampleAccessPE.class)})
@NamedNativeQueries(value={@NamedNativeQuery(name="space_sample_access", query="SELECT DISTINCT g.code as ownerCode, 'SPACE' as ownerType FROM samples s, spaces g WHERE s.id in (:ids) and s.space_id = g.id", resultSetMapping="sample_access_implicit"), @NamedNativeQuery(name="shared_sample_access", query="SELECT DISTINCT dbi.code as ownerCode, 'DATABASE_INSTANCE' as ownerType FROM samples s, database_instances dbi WHERE s.id in (:ids) and s.dbin_id = dbi.id", resultSetMapping="sample_access_implicit"), @NamedNativeQuery(name="deleted_space_sample_access", query="SELECT DISTINCT g.code as ownerCode, 'SPACE' as ownerType FROM samples_deleted s, spaces g WHERE s.del_id in (:del_ids) and s.space_id = g.id", resultSetMapping="sample_access_implicit"), @NamedNativeQuery(name="deleted_shared_sample_access", query="SELECT DISTINCT dbi.code as ownerCode, 'DATABASE_INSTANCE' as ownerType FROM samples_deleted s, database_instances dbi WHERE s.del_id in (:del_ids) and s.dbin_id = dbi.id", resultSetMapping="sample_access_implicit")})
public class SampleAccessPE {
    public static final String SPACE_SAMPLE_ACCESS_QUERY_NAME = "space_sample_access";
    public static final String SHARED_SAMPLE_ACCESS_QUERY_NAME = "shared_sample_access";
    public static final String DELETED_SPACE_SAMPLE_ACCESS_QUERY_NAME = "deleted_space_sample_access";
    public static final String DELETED_SHARED_SAMPLE_ACCESS_QUERY_NAME = "deleted_shared_sample_access";
    public static final String SAMPLE_IDS_PARAMETER_NAME = "ids";
    public static final String DELETION_IDS_PARAMETER_NAME = "del_ids";
    private String ownerCode;
    private SampleOwnerType ownerType;

    public static SampleAccessPE createSpaceSampleAccessPEForTest(String dataSetId, String dataSetCode, String spaceCode) {
        SampleAccessPE newMe = new SampleAccessPE();
        newMe.setOwnerType(SampleOwnerType.SPACE);
        newMe.setOwnerCode(spaceCode);
        return newMe;
    }

    public static SampleAccessPE createSharedSampleAccessPEForTest(String dataSetId, String dataSetCode, String databaseInstanceCode) {
        SampleAccessPE newMe = new SampleAccessPE();
        newMe.setOwnerType(SampleOwnerType.DATABASE_INSTANCE);
        newMe.setOwnerCode(databaseInstanceCode);
        return newMe;
    }

    @Id
    public String getOwnerCode() {
        return this.ownerCode;
    }

    public void setOwnerCode(String ownerCode) {
        this.ownerCode = ownerCode;
    }

    public SampleOwnerType getOwnerType() {
        return this.ownerType;
    }

    public void setOwnerType(SampleOwnerType ownerType) {
        this.ownerType = ownerType;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SampleAccessPE)) {
            return false;
        }
        SampleAccessPE that = (SampleAccessPE)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.getOwnerType(), (Object)that.getOwnerType());
        builder.append((Object)this.getOwnerCode(), (Object)that.getOwnerCode());
        return builder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getOwnerType());
        builder.append((Object)this.getOwnerCode());
        return builder.toHashCode();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static enum SampleOwnerType {
        SPACE,
        DATABASE_INSTANCE;

    }
}

