/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.query.server;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.properties.PropertyParametersUtil;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.spring.ExposablePropertyPlaceholderConfigurer;
import ch.systemsx.cisd.dbmigration.SimpleDatabaseConfigurationContext;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.plugin.query.server.authorization.QueryAccessController;
import ch.systemsx.cisd.openbis.plugin.query.shared.DatabaseDefinition;
import ch.systemsx.cisd.openbis.plugin.query.shared.IQueryDatabaseDefinitionProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component(value="query-db-definition-provider")
public class QueryDatabaseDefinitionProvider
implements IQueryDatabaseDefinitionProvider {
    private static final String DATABASE_KEYS = "query-databases";
    private static final String LABEL_PROPERTY_KEY = "label";
    private static final String CREATOR_MINIMAL_ROLE_KEY = "creator-minimal-role";
    private static final String DATA_SPACE_KEY = "data-space";
    private static final String DEFAULT_CREATOR_MINIMAL_ROLE_SPACE = RoleWithHierarchy.SPACE_POWER_USER.name();
    private static final String DEFAULT_CREATOR_MINIMAL_ROLE_INSTANCE = RoleWithHierarchy.INSTANCE_OBSERVER.name();
    @Resource(name="propertyConfigurer")
    private ExposablePropertyPlaceholderConfigurer configurer;
    @Resource(name="dao-factory")
    private IDAOFactory daoFactory;
    private Map<String, DatabaseDefinition> definitions;

    @Override
    public void initDatabaseDefinitions() {
        if (this.definitions != null) {
            return;
        }
        this.definitions = new HashMap<String, DatabaseDefinition>();
        Properties resolvedProps = this.configurer.getResolvedProps();
        PropertyParametersUtil.SectionProperties[] sectionsProperties = PropertyParametersUtil.extractSectionProperties(resolvedProps, DATABASE_KEYS, false);
        HashSet<String> labels = new HashSet<String>();
        int i = 0;
        while (i < sectionsProperties.length) {
            String databaseKey = sectionsProperties[i].getKey();
            Properties databaseProperties = sectionsProperties[i].getProperties();
            SimpleDatabaseConfigurationContext configurationContext = new SimpleDatabaseConfigurationContext(databaseProperties);
            String label = PropertyUtils.getMandatoryProperty(databaseProperties, LABEL_PROPERTY_KEY);
            String dataSpaceOrNullString = PropertyUtils.getProperty(databaseProperties, DATA_SPACE_KEY);
            String creatorMinimalRoleString = PropertyUtils.getProperty(databaseProperties, CREATOR_MINIMAL_ROLE_KEY, QueryDatabaseDefinitionProvider.getDefaultRoleForDataSource(dataSpaceOrNullString));
            if (labels.contains(label)) {
                throw new UnsupportedOperationException("Query databases need to have unique labels but '" + label + "' label is used more than once.");
            }
            labels.add(label);
            SpacePE dataSpaceOrNull = null;
            if (dataSpaceOrNullString != null && (dataSpaceOrNull = this.daoFactory.getSpaceDAO().tryFindSpaceByCodeAndDatabaseInstance(dataSpaceOrNullString, this.daoFactory.getHomeDatabaseInstance())) == null) {
                throw new UnsupportedOperationException("Query database '" + databaseKey + "' is not defined properly. Space '" + dataSpaceOrNullString + "' doesn't exist.");
            }
            try {
                RoleWithHierarchy creatorMinimalRole = RoleWithHierarchy.valueOf(creatorMinimalRoleString);
                this.definitions.put(databaseKey, new DatabaseDefinition(configurationContext, databaseKey, label, creatorMinimalRole, dataSpaceOrNull));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new UnsupportedOperationException("Query database '" + databaseKey + "' is not defined properly. '" + creatorMinimalRoleString + "' is not a valid role.");
            }
            ++i;
        }
        QueryAccessController.initialize(this.definitions);
    }

    private static String getDefaultRoleForDataSource(String dataSpaceOrNull) {
        if (dataSpaceOrNull == null) {
            return DEFAULT_CREATOR_MINIMAL_ROLE_INSTANCE;
        }
        return DEFAULT_CREATOR_MINIMAL_ROLE_SPACE;
    }

    @Override
    public DatabaseDefinition getDefinition(String dbKey) {
        this.checkInitialization();
        return this.definitions.get(dbKey);
    }

    @Override
    public Collection<DatabaseDefinition> getAllDefinitions() throws ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException {
        this.checkInitialization();
        return this.definitions.values();
    }

    private void checkInitialization() {
        if (this.definitions == null) {
            throw UserFailureException.fromTemplate("Query databases were not initialized yet.", new Object[0]);
        }
    }
}

