/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.client.application.model;

import ch.systemsx.cisd.cifex.client.application.grid.AbstractFilterField;
import ch.systemsx.cisd.cifex.client.application.grid.ColumnFilterField;
import ch.systemsx.cisd.cifex.client.application.model.IModelDataWithID;
import com.extjs.gxt.ui.client.data.BaseModelData;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractDataGridModel
extends BaseModelData
implements IModelDataWithID {
    private static final long serialVersionUID = 1L;
    public static final String ID = "id";

    protected static final ColumnConfig createSortableColumnConfig(String code, String title, int width) {
        ColumnConfig columnConfig = AbstractDataGridModel.createColumnConfig(code, title, width);
        columnConfig.setSortable(true);
        return columnConfig;
    }

    protected static final ColumnConfig createIdColumnConfig() {
        ColumnConfig columnConfig = AbstractDataGridModel.createSortableColumnConfig(ID, "Id", 20);
        columnConfig.setHidden(true);
        columnConfig.setFixed(true);
        return columnConfig;
    }

    protected static final ColumnConfig createColumnConfig(String code, String title, int width) {
        ColumnConfig columnConfig = new ColumnConfig();
        columnConfig.setDataIndex(code);
        columnConfig.setId(code);
        columnConfig.setHeader(title);
        columnConfig.setWidth(width);
        columnConfig.setMenuDisabled(true);
        return columnConfig;
    }

    protected static <M extends ModelData> List<AbstractFilterField<M>> createFilterItems(List<ColumnConfig> columnConfigs, List<String> initialFilters) {
        ArrayList<AbstractFilterField<M>> filterFields = new ArrayList<AbstractFilterField<M>>();
        for (ColumnConfig cc : columnConfigs) {
            if (cc.isHidden() && cc.isFixed()) continue;
            ColumnFilterField field = new ColumnFilterField(cc.getId(), cc.getHeader(), (GridCellRenderer<ModelData>)cc.getRenderer());
            boolean initiallyVisible = initialFilters.contains(cc.getId());
            field.setVisible(initiallyVisible);
            field.setEnabled(initiallyVisible);
            filterFields.add(field);
        }
        return filterFields;
    }
}

