/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.client.application.page;

import ch.systemsx.cisd.cifex.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.cifex.client.application.IHistoryController;
import ch.systemsx.cisd.cifex.client.application.ViewContext;
import ch.systemsx.cisd.cifex.client.application.grid.GridWidget;
import ch.systemsx.cisd.cifex.client.application.model.UserGridModel;
import ch.systemsx.cisd.cifex.shared.basic.dto.UserInfoDTO;
import java.util.List;

public final class UserGridRefresherCallback
extends AbstractAsyncCallback<Void> {
    private final GridWidget<UserGridModel> userGrid;

    public UserGridRefresherCallback(ViewContext context, GridWidget<UserGridModel> userGrid) {
        super(context);
        this.userGrid = userGrid;
    }

    public final void onSuccess(Void object) {
        ViewContext viewContext = this.getViewContext();
        if (viewContext.getHistoryController().getCurrentPage() == IHistoryController.Page.ADMIN_PAGE) {
            viewContext.getCifexService().listUsers(new ListUsersCallback());
        } else {
            viewContext.getCifexService().listUsersOwnedBy(viewContext.getModel().getUser().getID(), new ListUsersCallback());
        }
    }

    private final class ListUsersCallback
    extends AbstractAsyncCallback<List<UserInfoDTO>> {
        ListUsersCallback() {
            super(UserGridRefresherCallback.this.getViewContext());
        }

        public final void onSuccess(List<UserInfoDTO> res) {
            UserGridRefresherCallback.this.userGrid.setDataAndRefresh(UserGridModel.convert(this.getViewContext(), res));
        }
    }
}

