/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.client.application.ui;

import ch.systemsx.cisd.cifex.client.application.utils.FileUtils;
import com.extjs.gxt.ui.client.data.BaseModelData;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.grid.ColumnData;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;

public final class FileSizeRenderer
implements GridCellRenderer<BaseModelData> {
    public static final FileSizeRenderer FILE_SIZE_RENDERER = new FileSizeRenderer(false);
    public static final FileSizeRenderer FILE_SIZE_NULL_AS_MISSING_RENDERER = new FileSizeRenderer(true);
    private final boolean treatZeroAsNull;

    private FileSizeRenderer(boolean treatZeroAsNull) {
        this.treatZeroAsNull = treatZeroAsNull;
    }

    public Object render(BaseModelData model, String property, ColumnData config, int rowIndex, int colIndex, ListStore<BaseModelData> store, Grid<BaseModelData> grid) {
        Number value = (Number)model.get(property);
        if (value == null) {
            return "-";
        }
        long longValue = value.longValue();
        if (this.treatZeroAsNull && longValue == 0L) {
            return "-";
        }
        if (longValue == Long.MAX_VALUE) {
            return "unlimited";
        }
        return FileUtils.byteCountToDisplaySize(longValue);
    }
}

