/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.client.application.utils;

import ch.systemsx.cisd.cifex.shared.basic.dto.FileInfoDTO;
import com.google.gwt.i18n.client.NumberFormat;

public final class FileUtils {
    public static final long ONE_KB = 1024L;
    public static final long ONE_MB = 0x100000L;
    public static final long ONE_GB = 0x40000000L;
    private static final NumberFormat FORMATTER = NumberFormat.getFormat((String)"0.00");

    private FileUtils() {
    }

    public static final Double tryToGetFileSize(FileInfoDTO fileOrNull) {
        return fileOrNull == null ? null : new Double(fileOrNull.getSize().doubleValue());
    }

    public static final String byteCountToDisplaySize(long size) {
        double sizeAsDouble = size;
        String displaySize = size >= 0x40000000L ? String.valueOf(FORMATTER.format(sizeAsDouble / 1.073741824E9)) + " GB" : (size >= 0x100000L ? String.valueOf(FORMATTER.format(sizeAsDouble / 1048576.0)) + " MB" : (size >= 1024L ? String.valueOf(FORMATTER.format(sizeAsDouble / 1024.0)) + " KB" : (size != 1L ? String.valueOf(size) + " bytes" : "1 byte")));
        return displaySize;
    }

    public static final String fastByteCountToDisplaySize(long size) {
        String displaySize = size / 0x40000000L > 0L ? String.valueOf(String.valueOf(size / 0x40000000L)) + " GB" : (size / 0x100000L > 0L ? String.valueOf(String.valueOf(size / 0x100000L)) + " MB" : (size / 1024L > 0L ? String.valueOf(String.valueOf(size / 1024L)) + " KB" : String.valueOf(String.valueOf(size)) + " bytes"));
        return displaySize;
    }
}

