/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.client.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.text.DateFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class DateTimeTableCellRenderer
implements TableCellRenderer {
    private final JLabel dateLabel = new JLabel();
    private final JLabel timeLabel = new JLabel();
    private final JPanel panel = new JPanel();
    DateFormat dateFormatter;
    DateFormat timeFormatter;

    public DateTimeTableCellRenderer() {
        this.timeLabel.setFont(this.dateLabel.getFont().deriveFont(0));
        this.panel.setLayout(new GridLayout(2, 0));
        this.panel.add(this.dateLabel);
        this.panel.add(this.timeLabel);
        this.panel.setOpaque(true);
        this.dateFormatter = DateFormat.getDateInstance(2);
        this.timeFormatter = DateFormat.getTimeInstance(2);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color backgroundColor = isSelected ? table.getSelectionBackground() : table.getBackground();
        this.panel.setBackground(backgroundColor);
        this.dateLabel.setText(this.dateFormatter.format(value));
        this.timeLabel.setText(this.timeFormatter.format(value));
        return this.panel;
    }
}

