/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.io;

import ch.systemsx.cisd.cifex.rpc.io.CRC32Utils;
import ch.systemsx.cisd.cifex.rpc.io.CloneableCRC32;
import ch.systemsx.cisd.cifex.rpc.io.ISimpleChecksummingProgressListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public final class ResumingAndChecksummingOutputStream
extends OutputStream {
    private final RandomAccessFile raFile;
    private final CloneableCRC32 crc32;
    private final ISimpleChecksummingProgressListener listenerOrNull;
    private final long progressChunkSize;
    private long bytesWritten;
    private long bytesWrittenSinceListenerCalled;

    public ResumingAndChecksummingOutputStream(File file) throws IOException {
        this(file, 0L, null);
    }

    public ResumingAndChecksummingOutputStream(File file, long progressChunkSize, ISimpleChecksummingProgressListener listenerOrNull) throws IOException {
        this.raFile = new RandomAccessFile(file, "rw");
        if (this.raFile.length() > 0L) {
            this.raFile.setLength(0L);
        }
        this.listenerOrNull = listenerOrNull;
        this.progressChunkSize = progressChunkSize;
        this.crc32 = new CloneableCRC32();
        this.bytesWritten = 0L;
        this.bytesWrittenSinceListenerCalled = 0L;
    }

    public ResumingAndChecksummingOutputStream(File file, long progressChunkSize, ISimpleChecksummingProgressListener listenerOrNull, long startPos, int startCRC32) throws IOException, IllegalArgumentException {
        this.raFile = new RandomAccessFile(file, "rw");
        if (startPos > this.raFile.length()) {
            throw new IllegalArgumentException(String.format("Start position %s larger than file size %s.", startPos, this.raFile.length()));
        }
        this.raFile.seek(startPos);
        if (this.raFile.length() > startPos) {
            this.raFile.setLength(startPos);
        }
        this.listenerOrNull = listenerOrNull;
        this.progressChunkSize = progressChunkSize;
        this.crc32 = new CloneableCRC32(startCRC32);
        this.bytesWritten = startPos;
        this.bytesWrittenSinceListenerCalled = 0L;
    }

    public ResumingAndChecksummingOutputStream(File file, long progressChunkSize, ISimpleChecksummingProgressListener listenerOrNull, long startPos) throws IOException, IllegalArgumentException {
        this.raFile = new RandomAccessFile(file, "rw");
        if (startPos > this.raFile.length()) {
            throw new IllegalArgumentException(String.format("Start position %s larger than file size %s.", startPos, this.raFile.length()));
        }
        if (this.raFile.length() > startPos) {
            this.raFile.setLength(startPos);
        }
        this.listenerOrNull = listenerOrNull;
        this.progressChunkSize = progressChunkSize;
        this.crc32 = CRC32Utils.computeCRC32(this.raFile, startPos);
        this.bytesWritten = startPos;
        this.bytesWrittenSinceListenerCalled = 0L;
    }

    @Override
    public void close() throws IOException {
        try {
            this.raFile.close();
            this.finishProgressReport();
        }
        catch (IOException ex) {
            this.reportException(ex);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.crc32.update(b, off, len);
            this.updateProgress(len);
            this.raFile.write(b, off, len);
        }
        catch (IOException ex) {
            this.reportException(ex);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        try {
            this.crc32.update(b);
            this.updateProgress(b.length);
            this.raFile.write(b);
        }
        catch (IOException ex) {
            this.reportException(ex);
        }
    }

    @Override
    public void write(int b) throws IOException {
        try {
            this.crc32.update(b);
            this.updateProgress(1L);
            this.raFile.write(b);
        }
        catch (IOException ex) {
            this.reportException(ex);
        }
    }

    public int getCrc32Value() {
        return this.crc32.getIntValue();
    }

    public long getByteCount() {
        return this.bytesWritten;
    }

    private void updateProgress(long chunkSize) {
        this.bytesWritten += chunkSize;
        this.bytesWrittenSinceListenerCalled += chunkSize;
        if (this.bytesWrittenSinceListenerCalled >= this.progressChunkSize) {
            if (this.listenerOrNull != null) {
                this.listenerOrNull.update(this.bytesWritten, this.crc32.getIntValue());
            }
            this.bytesWrittenSinceListenerCalled = 0L;
        }
    }

    private void finishProgressReport() {
        if (this.bytesWrittenSinceListenerCalled > 0L) {
            if (this.listenerOrNull != null) {
                this.listenerOrNull.update(this.bytesWritten, this.crc32.getIntValue());
            }
            this.bytesWrittenSinceListenerCalled = 0L;
        }
    }

    private void reportException(IOException e) {
        if (this.listenerOrNull != null) {
            this.listenerOrNull.exceptionThrown(e);
        }
    }
}

