/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.server;

import ch.systemsx.cisd.cifex.rpc.QuotaExceededException;
import ch.systemsx.cisd.cifex.server.AbstractFileUploadDownloadServlet;
import ch.systemsx.cisd.cifex.server.FileUploadProgressListener;
import ch.systemsx.cisd.cifex.server.business.IFileManager;
import ch.systemsx.cisd.cifex.server.business.dto.FileDTO;
import ch.systemsx.cisd.cifex.server.business.dto.UserDTO;
import ch.systemsx.cisd.cifex.server.util.FileUploadFeedbackProvider;
import ch.systemsx.cisd.cifex.server.util.FilenameUtilities;
import ch.systemsx.cisd.cifex.shared.basic.dto.Message;
import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.exceptions.InvalidSessionException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.string.StringUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public final class FileUploadServlet
extends AbstractFileUploadDownloadServlet {
    private static final long serialVersionUID = 1L;
    private static final String UPLOAD_FINISHED = "Upload finished.\n";

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, InvalidSessionException {
    }

    protected final void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, InvalidSessionException {
        UserDTO requestUser = this.getUserDTO(request);
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
        if (!isMultipart) {
            String msg = String.format("Protocol error : request '%s' is not a multipart content file upload.", request.getRequestURI());
            this.operationLog.error((Object)msg);
            throw new UserFailureException(msg);
        }
        FileUploadFeedbackProvider feedbackProvider = (FileUploadFeedbackProvider)request.getSession().getAttribute("upload-feedback-queue");
        try {
            String[] filenamesToUpload = (String[])request.getSession().getAttribute("files-to-upload");
            if (filenamesToUpload == null) {
                String msg = String.format("Protocol error: no filenames registered for request '%s'.", request.getRequestURI());
                this.operationLog.warn((Object)msg);
                throw new UserFailureException(msg);
            }
            int contentLength = request.getContentLength();
            if (this.operationLog.isDebugEnabled()) {
                this.operationLog.debug((Object)String.format("Request of user '%s' has a content length of %s.", requestUser.getEmail(), FileUtils.byteCountToDisplaySize((long)contentLength)));
            }
            this.checkQuota(requestUser, filenamesToUpload.length, contentLength);
            ArrayList<FileDTO> files = new ArrayList<FileDTO>();
            ArrayList<String> userIdentifiers = new ArrayList<String>();
            StringBuffer comment = new StringBuffer();
            new FormDataExtractor(request, requestUser, filenamesToUpload, files, userIdentifiers, comment).execute();
            String url = this.getURLForEmail(request);
            IFileManager fileManager = this.domainModel.getFileManager();
            List<String> invalidUserIdentifiers = fileManager.shareFilesWith(url, requestUser, userIdentifiers, files, comment.toString(), this.domainModel.getBusinessContext().getUserActionLogHttp());
            if (!invalidUserIdentifiers.isEmpty()) {
                String msg = "Some user identifiers are invalid:<br>" + CollectionUtils.abbreviate(invalidUserIdentifiers, 10);
                feedbackProvider.setMessage(new Message(Message.Type.WARNING, UPLOAD_FINISHED + msg));
            } else {
                feedbackProvider.setFileUploadFinished();
            }
        }
        catch (Exception ex) {
            this.operationLog.error((Object)"Could not process multipart content.", (Throwable)ex);
            String msg = this.getErrorMessage(ex);
            if (msg.contains("value too long")) {
                msg = "Cannot upload file(s): length constraint in database exceeded.";
            }
            feedbackProvider.setMessage(new Message(Message.Type.ERROR, msg));
        }
    }

    private void checkQuota(UserDTO requestUser, int count, long fileSize) {
        boolean sizeOK;
        this.domainModel.getUserManager().refreshQuotaInformation(requestUser);
        boolean countOK = requestUser.getMaxFileCountPerQuotaGroup() == null || requestUser.getCurrentFileCount() + count <= requestUser.getMaxFileCountPerQuotaGroup();
        boolean bl = sizeOK = requestUser.getMaxFileSizePerQuotaGroupInMB() == null || requestUser.getCurrentFileSize() + fileSize <= requestUser.getMaxFileSizePerQuotaGroupInMB() * 0x100000L;
        if (!countOK || !sizeOK) {
            double currentFileSizeInMB = (double)requestUser.getCurrentFileSize() / 1048576.0;
            QuotaExceededException exception = new QuotaExceededException(requestUser.getMaxFileCountPerQuotaGroup(), requestUser.getMaxFileSizePerQuotaGroupInMB(), requestUser.getCurrentFileCount(), currentFileSizeInMB);
            this.operationLog.error((Object)exception.getMessage());
            throw exception;
        }
    }

    @Override
    protected String getMainClassName() {
        return null;
    }

    @Override
    protected String getOperationName() {
        return null;
    }

    @Override
    protected String getTitle() {
        return null;
    }

    private final class FormDataExtractor {
        private final HttpServletRequest request;
        private final UserDTO requestUser;
        private final String[] pathnamesToUpload;
        private final List<FileDTO> files;
        private final List<String> userIdentifier;
        private final StringBuffer comment;
        private final ServletFileUpload upload;
        private final List<String> formIndexedPathnamesAndNulls;
        private final FileUploadProgressListener progressListener;

        public FormDataExtractor(HttpServletRequest request, UserDTO requestUser, String[] pathnamesToUpload, List<FileDTO> files, List<String> userIdentifier, StringBuffer comment) {
            this.request = request;
            this.requestUser = requestUser;
            this.pathnamesToUpload = pathnamesToUpload;
            this.files = files;
            this.userIdentifier = userIdentifier;
            this.comment = comment;
            this.upload = new ServletFileUpload();
            this.formIndexedPathnamesAndNulls = new ArrayList<String>();
            this.progressListener = new FileUploadProgressListener(request.getSession(false), this.formIndexedPathnamesAndNulls);
            this.upload.setProgressListener((ProgressListener)this.progressListener);
        }

        public void execute() throws FileUploadException, IOException {
            IFileManager fileManager = FileUploadServlet.this.domainModel.getFileManager();
            FileItemIterator iter = this.upload.getItemIterator(this.request);
            int fileIndex = 0;
            while (iter.hasNext()) {
                FileItemStream item = iter.next();
                InputStream stream = item.openStream();
                if (item.isFormField()) {
                    this.extractSimpleFieldData(item, stream);
                    continue;
                }
                this.extractFileFieldData(item, stream, fileManager, fileIndex);
                ++fileIndex;
            }
            for (FileDTO file : this.files) {
                file.setComment(this.comment.toString());
                fileManager.updateFile(file, this.requestUser);
            }
        }

        private void extractSimpleFieldData(FileItemStream item, InputStream stream) throws IOException {
            this.formIndexedPathnamesAndNulls.add(null);
            if (item.getFieldName().equals("email-addresses")) {
                this.userIdentifier.addAll(StringUtilities.tokenize(Streams.asString((InputStream)stream)));
            }
            if (item.getFieldName().equals("upload-comment")) {
                this.comment.append(Streams.asString((InputStream)stream));
            }
        }

        private void extractFileFieldData(FileItemStream item, InputStream stream, IFileManager fileManager, int fileIndex) throws IOException {
            String pathnameToUpload = fileIndex < this.pathnamesToUpload.length ? this.pathnamesToUpload[fileIndex] : null;
            String filenameToUpload = FilenameUtils.getName((String)pathnameToUpload);
            this.formIndexedPathnamesAndNulls.add(filenameToUpload);
            String filenameInStream = FilenameUtils.getName((String)item.getName());
            if (StringUtils.isBlank((String)filenameToUpload)) {
                if (StringUtils.isBlank((String)filenameInStream)) {
                    return;
                }
                throw UserFailureException.fromTemplate("Unexpected file '%s'.", filenameInStream);
            }
            if (!filenameToUpload.equals(filenameInStream) && stream.available() == 0) {
                fileManager.throwExceptionOnFileDoesNotExist(pathnameToUpload);
            }
            if (StringUtils.isNotBlank((String)filenameToUpload)) {
                if (FileUploadServlet.this.operationLog.isDebugEnabled()) {
                    FileUploadServlet.this.operationLog.debug((Object)String.format("Handle field '%s' with file '%s'.", item.getFieldName(), item.getName()));
                }
                String fileName = FilenameUtilities.ensureMaximumSize(filenameToUpload, 250);
                String contentType = FilenameUtilities.getMimeType(item.getName());
                FileUploadServlet.this.domainModel.getBusinessContext().getUserActionLogHttp().logUploadFileStart(fileName, null, 0L);
                boolean success = false;
                FileDTO file = null;
                try {
                    file = fileManager.saveFile(this.requestUser, fileName, this.comment.toString(), contentType, stream);
                    success = true;
                    this.files.add(file);
                }
                finally {
                    FileUploadServlet.this.domainModel.getBusinessContext().getUserActionLogHttp().logUploadFileFinished(fileName, file, success);
                }
            } else if (FileUploadServlet.this.operationLog.isDebugEnabled()) {
                FileUploadServlet.this.operationLog.debug((Object)String.format("No file specified in field '%s'.", item.getFieldName()));
            }
        }
    }
}

