/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.server.business.dto;

import ch.systemsx.cisd.cifex.server.business.dto.BasicFileDTO;
import ch.systemsx.cisd.cifex.server.business.dto.ID;
import ch.systemsx.cisd.cifex.server.business.dto.UserDTO;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public final class FileDTO
extends ID {
    private static final long serialVersionUID = 1L;
    private String path;
    private String comment;
    private UserDTO owner;
    private String registratorCode;
    private Date registrationDate;
    private Date expirationDate;
    private List<UserDTO> sharingUsers = Collections.emptyList();
    private final Long ownerId;
    private final BasicFileDTO basicFileDTO = new BasicFileDTO();

    public FileDTO() {
        this.ownerId = null;
    }

    public FileDTO(UserDTO owner) {
        this.owner = owner;
        this.ownerId = owner.getID();
    }

    public FileDTO(Long registererId) {
        this.ownerId = registererId;
    }

    public final String getName() {
        return this.basicFileDTO.getName();
    }

    public final void setName(String name) {
        this.basicFileDTO.setName(name);
    }

    public final String getPath() {
        return this.path;
    }

    public final void setPath(String path) {
        this.path = path;
    }

    public final UserDTO getOwner() {
        return this.owner;
    }

    public final void setOwner(UserDTO registerer) {
        FileDTO.getAndCheckID(registerer, this.ownerId);
        this.owner = registerer;
    }

    public final String getRegistratorCode() {
        return this.registratorCode;
    }

    public final void setRegistratorCode(String registratorCode) {
        this.registratorCode = registratorCode;
    }

    public final Date getRegistrationDate() {
        return this.registrationDate;
    }

    public final void setRegistrationDate(Date registrationDate) {
        this.registrationDate = registrationDate;
    }

    public final Date getExpirationDate() {
        return this.expirationDate;
    }

    public final void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public List<UserDTO> getSharingUsers() {
        return this.sharingUsers;
    }

    public void setSharingUsers(List<UserDTO> sharingUsers) {
        this.sharingUsers = sharingUsers;
    }

    public final Long getOwnerId() {
        return this.ownerId;
    }

    public final void setContentType(String contentType) {
        this.basicFileDTO.setContentType(contentType);
    }

    public final String getContentType() {
        return this.basicFileDTO.getContentType();
    }

    public final Long getSize() {
        return this.basicFileDTO.getSize();
    }

    public final void setSize(long size) {
        this.basicFileDTO.setSize(size);
    }

    public Integer getCrc32Value() {
        return this.basicFileDTO.getCrc32Value();
    }

    public String getCrc32Str() {
        return this.basicFileDTO.getCrc32Value() == null ? "-" : String.format("%x", this.basicFileDTO.getCrc32Value());
    }

    public void setCrc32Value(int crc32Value) {
        this.basicFileDTO.setCrc32Value(crc32Value);
    }

    public final long getCompleteSize() {
        return this.basicFileDTO.getCompleteSize();
    }

    public final void setCompleteSize(long size) {
        this.basicFileDTO.setCompleteSize(size);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }
}

