/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.io;

import ch.systemsx.cisd.common.utilities.ITimeProvider;

public class TransmissionSpeedCalculator {
    private static final int HISTORY_LENGTH = 3;
    private final ITimeProvider timeProvider;
    private final float[] bytesPerMSecHistory = new float[3];
    private int historyIndex = 0;
    private boolean initialized;
    private long lastTransmissionTime;

    public TransmissionSpeedCalculator(ITimeProvider timeProvider) {
        this.timeProvider = timeProvider;
        this.initialized = false;
    }

    public void noteTransmittedBytesSinceLastUpdate(long numberOfBytesTransmitted) {
        if (!this.initialized) {
            this.initializeHistory(numberOfBytesTransmitted);
        }
        long newTransmissionTime = this.timeProvider.getTimeInMilliseconds();
        float diff = newTransmissionTime - this.lastTransmissionTime;
        diff = Math.max(diff, 1.0f);
        this.bytesPerMSecHistory[this.historyIndex] = (float)numberOfBytesTransmitted / diff;
        this.historyIndex = (this.historyIndex + 1) % 3;
        this.lastTransmissionTime = newTransmissionTime;
    }

    public float getEstimatedBytesPerMillisecond() {
        float bytesPerMSecAvg = 0.0f;
        int i = 0;
        while (i < 3) {
            bytesPerMSecAvg += this.bytesPerMSecHistory[i];
            ++i;
        }
        return bytesPerMSecAvg /= 3.0f;
    }

    private void initializeHistory(long numberOfBytesTransmitted) {
        int i = 0;
        while (i < 3) {
            this.bytesPerMSecHistory[i] = 0.0f;
            ++i;
        }
        this.historyIndex = 0;
        this.lastTransmissionTime = this.timeProvider.getTimeInMilliseconds();
        this.initialized = true;
    }
}

