/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.cisd.hotdeploy;

import ch.ethz.cisd.hotdeploy.PluginInfo;
import java.io.File;

public final class PluginDescriptor {
    private final Class<?> pluginClass;
    private final File pluginArchive;
    private final long lastModified;

    PluginDescriptor(Class<?> pluginClass, File pluginArchive, long lastModified) {
        this.pluginClass = pluginClass;
        this.pluginArchive = pluginArchive;
        this.lastModified = lastModified;
    }

    public Class<?> getPluginClass() {
        return this.pluginClass;
    }

    public String getPluginClassname() {
        return this.pluginClass.getName();
    }

    public PluginInfo getPluginInfo() {
        return this.pluginClass.getAnnotation(PluginInfo.class);
    }

    public String getPluginName() {
        PluginInfo info = this.pluginClass.getAnnotation(PluginInfo.class);
        if (info != null) {
            return info.name();
        }
        return this.pluginClass.getName();
    }

    public Class<?> getPluginType() {
        PluginInfo info = this.pluginClass.getAnnotation(PluginInfo.class);
        if (info != null) {
            return info.pluginType();
        }
        return this.getPluginClass();
    }

    public boolean isImplementing(Class<?> workerInterface) {
        return workerInterface.isAssignableFrom(this.pluginClass);
    }

    public File getPluginArchive() {
        return this.pluginArchive;
    }

    public File getPluginDirectory() {
        return this.pluginArchive.getParentFile();
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public boolean hasPluginArchiveChanged() {
        return this.pluginArchive.lastModified() != this.lastModified;
    }

    public String toString() {
        PluginInfo info = this.getPluginInfo();
        if (info != null) {
            return "PluginDescriptor [pluginClass=" + this.pluginClass + ", pluginInfo=" + info + ", pluginArchive=" + this.pluginArchive + ", lastModified=" + this.lastModified + "]";
        }
        return "PluginDescriptor [pluginClass=" + this.pluginClass + ", pluginArchive=" + this.pluginArchive + ", lastModified=" + this.lastModified + "]";
    }
}

