/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.cisd.hotdeploy;

import ch.ethz.cisd.hotdeploy.PluginInfo;
import java.io.File;

public final class PluginEvent {
    private final PluginEventType eventType;
    private final Class<?> plugin;
    private final File pluginArchive;

    public PluginEvent(PluginEventType eventType, Class<?> plugin, File pluginArchive) {
        this.eventType = eventType;
        this.plugin = plugin;
        this.pluginArchive = pluginArchive;
    }

    public PluginEventType getEventType() {
        return this.eventType;
    }

    public Class<?> getPluginClass() {
        return this.plugin;
    }

    public String getPluginClassname() {
        return this.plugin == null ? null : this.plugin.getName();
    }

    public String getPluginName() {
        PluginInfo info = this.plugin.getAnnotation(PluginInfo.class);
        if (info != null) {
            return info.name();
        }
        return this.plugin == null ? null : this.plugin.getName();
    }

    public File getPluginArchive() {
        return this.pluginArchive;
    }

    public Class<?> getPluginType() {
        PluginInfo info = this.plugin.getAnnotation(PluginInfo.class);
        if (info != null) {
            return info.pluginType();
        }
        return this.plugin;
    }

    public boolean isPluginImplementingInterface(Class<?> workerInterface) {
        return workerInterface.isAssignableFrom(this.plugin);
    }

    public boolean isRegistrationOrUpdateEvent() {
        return this.eventType != PluginEventType.UNREGISTER_PLUGIN;
    }

    public boolean isUnregistrationEvent() {
        return this.eventType == PluginEventType.UNREGISTER_PLUGIN;
    }

    public boolean isShutdownEvent() {
        return this.plugin == null;
    }

    public static enum PluginEventType {
        REGISTER_NEW_PLUGIN,
        UPDATE_PLUGIN,
        UNREGISTER_PLUGIN;

    }
}

