/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.cisd.hotdeploy;

import ch.ethz.cisd.hotdeploy.PluginContainer;
import ch.ethz.cisd.hotdeploy.PluginEvent;
import ch.ethz.cisd.hotdeploy.PluginEventListener;
import ch.ethz.cisd.hotdeploy.PluginEventNotifier;
import ch.ethz.cisd.hotdeploy.PluginInfo;
import ch.ethz.cisd.hotdeploy.ReflectionUtils;
import java.io.File;

public class PluginInfoProvider {
    final PluginContainer container;
    final String pluginName;
    final boolean isClassName;
    private final PluginEventNotifier notifier;

    public PluginInfoProvider(PluginContainer container, String pluginName) {
        this(container, pluginName, false);
    }

    public PluginInfoProvider(PluginContainer container, final String pluginName, final boolean isClassName) {
        this.container = container;
        this.pluginName = pluginName;
        this.isClassName = isClassName;
        this.notifier = new PluginEventNotifier();
        container.addListener(new PluginEventListener(){

            @Override
            public void pluginChanged(PluginEvent event) {
                if (event.isShutdownEvent() || (isClassName ? pluginName.equals(event.getPluginClassname()) : pluginName.equals(event.getPluginName()))) {
                    PluginInfoProvider.this.processEvent(event);
                }
            }
        });
    }

    protected void processEvent(PluginEvent event) {
        this.notifier.notifyListeners(event);
    }

    public void addListener(PluginEventListener listener) {
        this.notifier.addListener(listener);
    }

    public void removeListener(PluginEventListener listener) {
        this.notifier.removeListener(listener);
    }

    public boolean hasConstructor(Class<?> ... constructorArgumentTypes) {
        return this.container.hasConstructorByClassname(this.pluginName, constructorArgumentTypes);
    }

    public boolean hasConstructor(Object ... constructorArgs) {
        return this.container.hasConstructorByClassname(this.pluginName, ReflectionUtils.getClasses(constructorArgs));
    }

    public Class<?> tryGetPluginClass() {
        return this.isClassName ? this.container.tryGetPluginClassByClassname(this.pluginName) : this.container.tryGetPluginClass(this.pluginName);
    }

    public String tryGetPluginClassname() {
        if (this.isClassName) {
            return this.pluginName;
        }
        Class<?> clazz = this.container.tryGetPluginClass(this.pluginName);
        return clazz == null ? null : clazz.getName();
    }

    public String getPluginName() {
        if (this.isClassName) {
            PluginInfo info = this.container.tryGetPluginInfoByClassname(this.pluginName);
            if (info != null) {
                return info.name();
            }
            return this.pluginName;
        }
        return this.pluginName;
    }

    public Class<?> getPluginType() {
        PluginInfo info;
        PluginInfo pluginInfo = info = this.isClassName ? this.container.tryGetPluginInfoByClassname(this.pluginName) : this.container.tryGetPluginInfo(this.pluginName);
        if (info != null) {
            return info.pluginType();
        }
        return this.tryGetPluginClass();
    }

    public int getMajorVersion() {
        PluginInfo info = this.container.tryGetPluginInfoByClassname(this.pluginName);
        if (info != null) {
            return info.majorVersion();
        }
        return -1;
    }

    public int getMinorVersion() {
        PluginInfo info = this.container.tryGetPluginInfoByClassname(this.pluginName);
        if (info != null) {
            return info.minorVersion();
        }
        return -1;
    }

    public File tryGetPluginArchive() {
        return this.container.tryGetPluginArchiveByClassname(this.pluginName);
    }
}

