/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.HashMap;
import loci.common.RandomAccessInputStream;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.in.LeicaSCNHandler;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffParser;
import ome.xml.model.enums.IlluminationType;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;
import ome.xml.model.primitives.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.helpers.DefaultHandler;

public class LeicaSCNReader
extends BaseTiffReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(LeicaSCNReader.class);
    LeicaSCNHandler handler;

    public LeicaSCNReader() {
        super("Leica SCN", new String[]{"scn"});
        this.domains = new String[]{"Histology"};
        this.suffixNecessary = false;
        this.suffixSufficient = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isThisType(String name, boolean open) {
        boolean isThisType = super.isThisType(name, open);
        if (!isThisType) return false;
        if (!open) return false;
        isThisType = false;
        RandomAccessInputStream stream = null;
        try {
            stream = new RandomAccessInputStream(name);
            TiffParser tiffParser = new TiffParser(stream);
            if (!tiffParser.isValidHeader()) {
                isThisType = false;
                return isThisType;
            } else {
                String imageDescription = tiffParser.getComment();
                if (imageDescription == null) return isThisType;
                try {
                    LeicaSCNHandler handler = new LeicaSCNHandler();
                    XMLTools.parseXML(imageDescription, (DefaultHandler)handler);
                    isThisType = true;
                    return isThisType;
                }
                catch (Exception se) {
                    isThisType = false;
                }
            }
            return isThisType;
        }
        catch (IOException e) {
            LOGGER.debug("I/O exception during isThisType() evaluation.", e);
            isThisType = false;
            return isThisType;
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                LOGGER.debug("I/O exception during stream closure.", e);
            }
        }
    }

    private int imageIFD(int no) {
        int s = this.getCoreIndex();
        LeicaSCNHandler.Image i = this.handler.imageMap.get(s);
        int[] dims = FormatTools.getZCTCoords(this.core[s].dimensionOrder, this.core[s].sizeZ, this.core[s].imageCount / (this.core[s].sizeZ * this.core[s].sizeT), this.core[s].sizeT, this.core[s].imageCount, no);
        int dz = dims[0];
        int dc = dims[1];
        int dr = this.getCoreIndex() - i.imageNumStart;
        int ifd = i.pixels.dimIFD[dz][dc][dr];
        return ifd;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        int ifd = this.imageIFD(no);
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.tiffParser.getSamples((IFD)this.ifds.get(ifd), buf, x, y, w, h);
        return buf;
    }

    public byte[] openThumbBytes(int no) throws FormatException, IOException {
        int s = this.getCoreIndex();
        LeicaSCNHandler.Image i = this.handler.imageMap.get(s);
        int thumbseries = i.imageNumStart + i.imageThumbnail;
        int thisSeries = this.getCoreIndex();
        this.setSeries(thumbseries);
        byte[] thumb = FormatTools.openThumbBytes(this, no);
        this.setSeries(thisSeries);
        return thumb;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        this.handler = null;
        if (!fileOnly) {
            // empty if block
        }
    }

    public int getOptimalTileWidth() {
        FormatTools.assertId(this.currentId, true, 1);
        try {
            return (int)((IFD)this.ifds.get(this.imageIFD(0))).getTileWidth();
        }
        catch (FormatException e) {
            LOGGER.debug("", e);
            return super.getOptimalTileWidth();
        }
    }

    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        try {
            return (int)((IFD)this.ifds.get(this.imageIFD(0))).getTileLength();
        }
        catch (FormatException e) {
            LOGGER.debug("", e);
            return super.getOptimalTileHeight();
        }
    }

    protected void initCoreMetadata(int s) throws FormatException, IOException {
        LeicaSCNHandler.ImageCollection c = this.handler.collectionMap.get(s);
        LeicaSCNHandler.Image i = this.handler.imageMap.get(s);
        if (c == null || i == null || i.imageNumStart > s || i.imageNumEnd < s) {
            throw new FormatException("Error setting core metadata for image number " + s);
        }
        IFD ifd = (IFD)this.ifds.get(this.handler.IFDMap.get(s));
        PhotoInterp pi = ifd.getPhotometricInterpretation();
        int samples = ifd.getSamplesPerPixel();
        int r = s - i.imageNumStart;
        if (s == i.imageNumStart && !this.hasFlattenedResolutions()) {
            this.core[s].resolutionCount = i.pixels.sizeR;
        }
        this.core[s].rgb = samples > 1 || pi == PhotoInterp.RGB;
        this.core[s].sizeX = (int)i.pixels.dimSizeX[0][0][r];
        this.core[s].sizeY = (int)i.pixels.dimSizeY[0][0][r];
        this.core[s].sizeZ = i.pixels.sizeZ;
        this.core[s].sizeT = 1;
        int n = this.core[s].sizeC = this.core[s].rgb ? samples : i.pixels.sizeC;
        if (ifd.getImageWidth() != (long)this.core[s].sizeX || ifd.getImageLength() != (long)this.core[s].sizeY) {
            throw new FormatException("IFD dimensions do not match XML dimensions for image number " + s + ": x=" + ifd.getImageWidth() + ", " + this.core[s].sizeX + ", y=" + ifd.getImageLength() + ", " + this.core[s].sizeY);
        }
        this.core[s].orderCertain = true;
        this.core[s].littleEndian = ifd.isLittleEndian();
        this.core[s].indexed = pi == PhotoInterp.RGB_PALETTE && (this.get8BitLookupTable() != null || this.get16BitLookupTable() != null);
        this.core[s].imageCount = i.pixels.sizeZ * i.pixels.sizeC;
        this.core[s].pixelType = ifd.getPixelType();
        this.core[s].metadataComplete = true;
        this.core[s].interleaved = false;
        this.core[s].falseColor = false;
        this.core[s].dimensionOrder = i.pixels.dataOrder;
        this.core[s].thumbnail = i.imageThumbnail == r;
    }

    protected void initStandardMetadata() throws FormatException, IOException {
        super.initStandardMetadata();
        this.tiffParser.setDoCaching(true);
        String imageDescription = this.tiffParser.getComment();
        this.handler = new LeicaSCNHandler();
        if (imageDescription != null) {
            try {
                XMLTools.parseXML(imageDescription, (DefaultHandler)this.handler);
            }
            catch (Exception se) {
                throw new FormatException("Failed to parse XML", se);
            }
        }
        int count = this.handler.count();
        this.core = new CoreMetadata[count];
        this.ifds = this.tiffParser.getIFDs();
        for (int i = 0; i < this.core.length; ++i) {
            this.core[i] = new CoreMetadata();
            this.tiffParser.fillInIFD((IFD)this.ifds.get(this.handler.IFDMap.get(i)));
            this.initCoreMetadata(i);
        }
        this.setSeries(0);
    }

    protected void initMetadataStore() throws FormatException {
        super.initMetadataStore();
        MetadataStore store = this.makeFilterMetadata();
        HashMap<String, String> instruments = new HashMap<String, String>();
        HashMap<String, Integer> instrumentIDs = new HashMap<String, Integer>();
        int instrumentidno = 0;
        HashMap<String, String> objectives = new HashMap<String, String>();
        HashMap<String, Integer> objectiveIDs = new HashMap<String, Integer>();
        int objectiveidno = 0;
        for (int s = 0; s < this.getSeriesCount(); ++s) {
            LeicaSCNHandler.ImageCollection c = this.handler.collectionMap.get(s);
            LeicaSCNHandler.Image i = this.handler.imageMap.get(s);
            int r = s - i.imageNumStart;
            double sizeX = (double)i.vSizeX / 1000.0;
            double sizeY = (double)i.vSizeY / 1000.0;
            double offsetX = (double)i.vOffsetX / 1000.0;
            double offsetY = (double)i.vOffsetY / 1000.0;
            double sizeZ = (double)i.vSpacingZ / 1000.0;
            store.setPixelsPhysicalSizeX(new PositiveFloat(sizeX / (double)i.pixels.dimSizeX[0][0][r]), s);
            store.setPixelsPhysicalSizeY(new PositiveFloat(sizeY / (double)i.pixels.dimSizeY[0][0][r]), s);
            if (sizeZ > 0.0) {
                store.setPixelsPhysicalSizeZ(new PositiveFloat(sizeZ), s);
            }
            if (instruments.get(i.devModel) == null) {
                String instrumentID = MetadataTools.createLSID("Instrument", instrumentidno);
                instruments.put(i.devModel, instrumentID);
                instrumentIDs.put(i.devModel, new Integer(instrumentidno));
                store.setInstrumentID(instrumentID, instrumentidno);
                ++instrumentidno;
            }
            if (objectives.get(i.devModel + ":" + i.objMag) == null) {
                int inst = (Integer)instrumentIDs.get(i.devModel);
                String objectiveID = MetadataTools.createLSID("Objective", inst, objectiveidno);
                objectives.put(i.devModel + ":" + i.objMag, objectiveID);
                objectiveIDs.put(i.devModel + ":" + i.objMag, new Integer(objectiveidno));
                store.setObjectiveID(objectiveID, inst, objectiveidno);
                Double mag = Double.parseDouble(i.objMag);
                store.setObjectiveNominalMagnification(new PositiveInteger((int)Math.round(mag)), inst, objectiveidno);
                store.setObjectiveCalibratedMagnification(mag, inst, objectiveidno);
                store.setObjectiveLensNA(new Double(i.illumNA), inst, objectiveidno);
                ++objectiveidno;
            }
            store.setImageInstrumentRef((String)instruments.get(i.devModel), s);
            store.setObjectiveSettingsID((String)objectives.get(i.devModel + ":" + i.objMag), s);
            String channelID = MetadataTools.createLSID("Channel", s);
            store.setChannelID(channelID, s, 0);
            if (i.illumSource.equals("brightfield")) {
                store.setChannelIlluminationType(IlluminationType.TRANSMITTED, s, 0);
            } else {
                store.setChannelIlluminationType(IlluminationType.OTHER, s, 0);
                System.out.println("Unknown illumination source " + i.illumSource + "; please report this");
            }
            for (int q = 0; q < this.core[s].imageCount; ++q) {
                int[] dims = FormatTools.getZCTCoords(this.core[s].dimensionOrder, this.core[s].sizeZ, this.core[s].imageCount / (this.core[s].sizeZ * this.core[s].sizeT), this.core[s].sizeT, this.core[s].imageCount, q);
                store.setPlaneTheZ(new NonNegativeInteger(dims[0]), s, q);
                store.setPlaneTheC(new NonNegativeInteger(dims[1]), s, q);
                store.setPlaneTheT(new NonNegativeInteger(dims[2]), s, q);
                store.setPlanePositionX(offsetX, s, q);
                store.setPlanePositionY(offsetY, s, q);
            }
            store.setImageName(i.name + " (R" + (s - i.imageNumStart) + ")", s);
            store.setImageDescription("Collection " + c.name, s);
            store.setImageAcquisitionDate(new Timestamp(i.creationDate), s);
            this.addGlobalMeta("collection.name", c.name);
            this.addGlobalMeta("collection.uuid", c.uuid);
            this.addGlobalMeta("collection.barcode", c.barcode);
            this.addGlobalMeta("collection.ocr", c.ocr);
            this.addGlobalMeta("creationDate", i.creationDate);
            this.addGlobalMeta("device.model for image #" + s, i.devModel);
            this.addGlobalMeta("device.version for image #" + s, i.devVersion);
            this.addGlobalMeta("view.sizeX for image #" + s, i.vSizeX);
            this.addGlobalMeta("view.sizeY for image #" + s, i.vSizeY);
            this.addGlobalMeta("view.offsetX for image #" + s, i.vOffsetX);
            this.addGlobalMeta("view.offsetY for image #" + s, i.vOffsetY);
            this.addGlobalMeta("view.spacingZ for image #" + s, i.vSpacingZ);
            this.addGlobalMeta("scanSettings.objectiveSettings.objective for image #" + s, i.objMag);
            this.addGlobalMeta("scanSettings.illuminationSettings.numericalAperture for image #" + s, i.illumNA);
            this.addGlobalMeta("scanSettings.illuminationSettings.illuminationSource for image #" + s, i.illumSource);
        }
    }
}

