/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.ome;

import loci.formats.ome.AbstractOMEXMLMetadata;
import ome.xml.model.AffineTransform;
import ome.xml.model.AnnotationRef;
import ome.xml.model.Arc;
import ome.xml.model.BinData;
import ome.xml.model.BinaryFile;
import ome.xml.model.BinaryOnly;
import ome.xml.model.BooleanAnnotation;
import ome.xml.model.Channel;
import ome.xml.model.CommentAnnotation;
import ome.xml.model.Dataset;
import ome.xml.model.DatasetRef;
import ome.xml.model.Detector;
import ome.xml.model.DetectorSettings;
import ome.xml.model.Dichroic;
import ome.xml.model.DichroicRef;
import ome.xml.model.DoubleAnnotation;
import ome.xml.model.Ellipse;
import ome.xml.model.EmissionFilterRef;
import ome.xml.model.ExcitationFilterRef;
import ome.xml.model.Experiment;
import ome.xml.model.ExperimentRef;
import ome.xml.model.Experimenter;
import ome.xml.model.ExperimenterGroup;
import ome.xml.model.ExperimenterGroupRef;
import ome.xml.model.ExperimenterRef;
import ome.xml.model.Filament;
import ome.xml.model.FileAnnotation;
import ome.xml.model.Filter;
import ome.xml.model.FilterSet;
import ome.xml.model.FilterSetRef;
import ome.xml.model.Image;
import ome.xml.model.ImageRef;
import ome.xml.model.ImagingEnvironment;
import ome.xml.model.Instrument;
import ome.xml.model.InstrumentRef;
import ome.xml.model.Label;
import ome.xml.model.Laser;
import ome.xml.model.Leader;
import ome.xml.model.LightEmittingDiode;
import ome.xml.model.LightPath;
import ome.xml.model.LightSource;
import ome.xml.model.LightSourceSettings;
import ome.xml.model.Line;
import ome.xml.model.ListAnnotation;
import ome.xml.model.LongAnnotation;
import ome.xml.model.Mask;
import ome.xml.model.MicrobeamManipulation;
import ome.xml.model.MicrobeamManipulationRef;
import ome.xml.model.Microscope;
import ome.xml.model.OME;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelImpl;
import ome.xml.model.Objective;
import ome.xml.model.ObjectiveSettings;
import ome.xml.model.Pixels;
import ome.xml.model.Plane;
import ome.xml.model.Plate;
import ome.xml.model.PlateAcquisition;
import ome.xml.model.PlateRef;
import ome.xml.model.Point;
import ome.xml.model.Polygon;
import ome.xml.model.Polyline;
import ome.xml.model.Project;
import ome.xml.model.Pump;
import ome.xml.model.ROI;
import ome.xml.model.ROIRef;
import ome.xml.model.Reagent;
import ome.xml.model.ReagentRef;
import ome.xml.model.Rectangle;
import ome.xml.model.Screen;
import ome.xml.model.Shape;
import ome.xml.model.StageLabel;
import ome.xml.model.StructuredAnnotations;
import ome.xml.model.TagAnnotation;
import ome.xml.model.TermAnnotation;
import ome.xml.model.TiffData;
import ome.xml.model.TimestampAnnotation;
import ome.xml.model.TransmittanceRange;
import ome.xml.model.UUID;
import ome.xml.model.Union;
import ome.xml.model.Well;
import ome.xml.model.WellSample;
import ome.xml.model.WellSampleRef;
import ome.xml.model.XMLAnnotation;
import ome.xml.model.enums.AcquisitionMode;
import ome.xml.model.enums.ArcType;
import ome.xml.model.enums.Binning;
import ome.xml.model.enums.ContrastMethod;
import ome.xml.model.enums.Correction;
import ome.xml.model.enums.DetectorType;
import ome.xml.model.enums.DimensionOrder;
import ome.xml.model.enums.ExperimentType;
import ome.xml.model.enums.FilamentType;
import ome.xml.model.enums.FillRule;
import ome.xml.model.enums.FilterType;
import ome.xml.model.enums.FontFamily;
import ome.xml.model.enums.FontStyle;
import ome.xml.model.enums.IlluminationType;
import ome.xml.model.enums.Immersion;
import ome.xml.model.enums.LaserMedium;
import ome.xml.model.enums.LaserType;
import ome.xml.model.enums.LineCap;
import ome.xml.model.enums.Marker;
import ome.xml.model.enums.Medium;
import ome.xml.model.enums.MicrobeamManipulationType;
import ome.xml.model.enums.MicroscopeType;
import ome.xml.model.enums.NamingConvention;
import ome.xml.model.enums.PixelType;
import ome.xml.model.enums.Pulse;
import ome.xml.model.primitives.Color;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.NonNegativeLong;
import ome.xml.model.primitives.PercentFraction;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;
import ome.xml.model.primitives.Timestamp;

public class OMEXMLMetadataImpl
extends AbstractOMEXMLMetadata {
    private OME root;
    private OMEModel model;

    public OMEXMLMetadataImpl() {
        this.createRoot();
    }

    public void createRoot() {
        this.root = new OME();
        this.model = new OMEModelImpl();
    }

    public Object getRoot() {
        return this.root;
    }

    public void setRoot(Object root) {
        if (!(root instanceof OME)) {
            throw new IllegalArgumentException("Expecting OME class or subclass.");
        }
        this.root = (OME)root;
        this.model = new OMEModelImpl();
    }

    public String dumpXML() {
        this.resolveReferences();
        return super.dumpXML();
    }

    public int resolveReferences() {
        return this.model.resolveReferences();
    }

    public int getPixelsBinDataCount(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().sizeOfBinDataList();
    }

    public int getBooleanAnnotationAnnotationCount(int booleanAnnotationIndex) {
        return this.root.getStructuredAnnotations().getBooleanAnnotation(booleanAnnotationIndex).sizeOfLinkedAnnotationList();
    }

    public int getCommentAnnotationAnnotationCount(int commentAnnotationIndex) {
        return this.root.getStructuredAnnotations().getCommentAnnotation(commentAnnotationIndex).sizeOfLinkedAnnotationList();
    }

    public int getDoubleAnnotationAnnotationCount(int doubleAnnotationIndex) {
        return this.root.getStructuredAnnotations().getDoubleAnnotation(doubleAnnotationIndex).sizeOfLinkedAnnotationList();
    }

    public int getFileAnnotationAnnotationCount(int fileAnnotationIndex) {
        return this.root.getStructuredAnnotations().getFileAnnotation(fileAnnotationIndex).sizeOfLinkedAnnotationList();
    }

    public int getListAnnotationAnnotationCount(int listAnnotationIndex) {
        return this.root.getStructuredAnnotations().getListAnnotation(listAnnotationIndex).sizeOfLinkedAnnotationList();
    }

    public int getLongAnnotationAnnotationCount(int longAnnotationIndex) {
        return this.root.getStructuredAnnotations().getLongAnnotation(longAnnotationIndex).sizeOfLinkedAnnotationList();
    }

    public int getTagAnnotationAnnotationCount(int tagAnnotationIndex) {
        return this.root.getStructuredAnnotations().getTagAnnotation(tagAnnotationIndex).sizeOfLinkedAnnotationList();
    }

    public int getTermAnnotationAnnotationCount(int termAnnotationIndex) {
        return this.root.getStructuredAnnotations().getTermAnnotation(termAnnotationIndex).sizeOfLinkedAnnotationList();
    }

    public int getTimestampAnnotationAnnotationCount(int timestampAnnotationIndex) {
        return this.root.getStructuredAnnotations().getTimestampAnnotation(timestampAnnotationIndex).sizeOfLinkedAnnotationList();
    }

    public int getXMLAnnotationAnnotationCount(int xmlAnnotationIndex) {
        return this.root.getStructuredAnnotations().getXMLAnnotation(xmlAnnotationIndex).sizeOfLinkedAnnotationList();
    }

    public String getLightSourceType(int instrumentIndex, int lightSourceIndex) {
        LightSource o = this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        String className = o.getClass().getName();
        return className.substring(className.lastIndexOf(46) + 1, className.length());
    }

    public String getShapeType(int roiIndex, int shapeIndex) {
        Shape o = this.root.getROI(roiIndex).getUnion().getShape(shapeIndex);
        String className = o.getClass().getName();
        return className.substring(className.lastIndexOf(46) + 1, className.length());
    }

    public int getROIAnnotationRefCount(int ROIIndex) {
        return this.root.getROI(ROIIndex).sizeOfLinkedAnnotationList();
    }

    public int getPlateAcquisitionAnnotationRefCount(int plateIndex, int plateAcquisitionIndex) {
        return this.root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex).sizeOfLinkedAnnotationList();
    }

    public int getPlateAnnotationRefCount(int plateIndex) {
        return this.root.getPlate(plateIndex).sizeOfLinkedAnnotationList();
    }

    public int getExperimenterGroupAnnotationRefCount(int experimenterGroupIndex) {
        return this.root.getExperimenterGroup(experimenterGroupIndex).sizeOfLinkedAnnotationList();
    }

    public int getImageAnnotationRefCount(int imageIndex) {
        return this.root.getImage(imageIndex).sizeOfLinkedAnnotationList();
    }

    public int getScreenAnnotationRefCount(int screenIndex) {
        return this.root.getScreen(screenIndex).sizeOfLinkedAnnotationList();
    }

    public int getWellAnnotationRefCount(int plateIndex, int wellIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).sizeOfLinkedAnnotationList();
    }

    public int getDatasetAnnotationRefCount(int datasetIndex) {
        return this.root.getDataset(datasetIndex).sizeOfLinkedAnnotationList();
    }

    public int getProjectAnnotationRefCount(int projectIndex) {
        return this.root.getProject(projectIndex).sizeOfLinkedAnnotationList();
    }

    public int getReagentAnnotationRefCount(int screenIndex, int reagentIndex) {
        return this.root.getScreen(screenIndex).getReagent(reagentIndex).sizeOfLinkedAnnotationList();
    }

    public int getPlaneAnnotationRefCount(int imageIndex, int planeIndex) {
        return this.root.getImage(imageIndex).getPixels().getPlane(planeIndex).sizeOfLinkedAnnotationList();
    }

    public int getExperimenterAnnotationRefCount(int experimenterIndex) {
        return this.root.getExperimenter(experimenterIndex).sizeOfLinkedAnnotationList();
    }

    public int getWellSampleAnnotationRefCount(int plateIndex, int wellIndex, int wellSampleIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getWellSample(wellSampleIndex).sizeOfLinkedAnnotationList();
    }

    public int getPixelsAnnotationRefCount(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().sizeOfLinkedAnnotationList();
    }

    public int getChannelAnnotationRefCount(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).sizeOfLinkedAnnotationList();
    }

    public int getBooleanAnnotationCount() {
        return this.root.getStructuredAnnotations().sizeOfBooleanAnnotationList();
    }

    public int getChannelCount(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().sizeOfChannelList();
    }

    public int getCommentAnnotationCount() {
        return this.root.getStructuredAnnotations().sizeOfCommentAnnotationList();
    }

    public int getDatasetCount() {
        return this.root.sizeOfDatasetList();
    }

    public int getDatasetRefCount(int projectIndex) {
        return this.root.getProject(projectIndex).sizeOfLinkedDatasetList();
    }

    public int getDetectorCount(int instrumentIndex) {
        return this.root.getInstrument(instrumentIndex).sizeOfDetectorList();
    }

    public int getDichroicCount(int instrumentIndex) {
        return this.root.getInstrument(instrumentIndex).sizeOfDichroicList();
    }

    public int getDoubleAnnotationCount() {
        return this.root.getStructuredAnnotations().sizeOfDoubleAnnotationList();
    }

    public int getLightPathEmissionFilterRefCount(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightPath().sizeOfLinkedEmissionFilterList();
    }

    public int getFilterSetEmissionFilterRefCount(int instrumentIndex, int filterSetIndex) {
        return this.root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex).sizeOfLinkedEmissionFilterList();
    }

    public int getLightPathExcitationFilterRefCount(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightPath().sizeOfLinkedExcitationFilterList();
    }

    public int getFilterSetExcitationFilterRefCount(int instrumentIndex, int filterSetIndex) {
        return this.root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex).sizeOfLinkedExcitationFilterList();
    }

    public int getExperimentCount() {
        return this.root.sizeOfExperimentList();
    }

    public int getExperimenterCount() {
        return this.root.sizeOfExperimenterList();
    }

    public int getExperimenterGroupCount() {
        return this.root.sizeOfExperimenterGroupList();
    }

    public int getExperimenterGroupExperimenterRefCount(int experimenterGroupIndex) {
        return this.root.getExperimenterGroup(experimenterGroupIndex).sizeOfLinkedExperimenterList();
    }

    public int getFileAnnotationCount() {
        return this.root.getStructuredAnnotations().sizeOfFileAnnotationList();
    }

    public int getFilterCount(int instrumentIndex) {
        return this.root.getInstrument(instrumentIndex).sizeOfFilterList();
    }

    public int getFilterSetCount(int instrumentIndex) {
        return this.root.getInstrument(instrumentIndex).sizeOfFilterSetList();
    }

    public int getImageCount() {
        return this.root.sizeOfImageList();
    }

    public int getDatasetImageRefCount(int datasetIndex) {
        return this.root.getDataset(datasetIndex).sizeOfLinkedImageList();
    }

    public int getInstrumentCount() {
        return this.root.sizeOfInstrumentList();
    }

    public int getLeaderCount(int experimenterGroupIndex) {
        return this.root.getExperimenterGroup(experimenterGroupIndex).sizeOfLinkedLeaderList();
    }

    public int getLightSourceCount(int instrumentIndex) {
        return this.root.getInstrument(instrumentIndex).sizeOfLightSourceList();
    }

    public int getMicrobeamManipulationLightSourceSettingsCount(int experimentIndex, int microbeamManipulationIndex) {
        return this.root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex).sizeOfLightSourceSettingsList();
    }

    public int getListAnnotationCount() {
        return this.root.getStructuredAnnotations().sizeOfListAnnotationList();
    }

    public int getLongAnnotationCount() {
        return this.root.getStructuredAnnotations().sizeOfLongAnnotationList();
    }

    public int getMicrobeamManipulationCount(int experimentIndex) {
        return this.root.getExperiment(experimentIndex).sizeOfMicrobeamManipulationList();
    }

    public int getMicrobeamManipulationRefCount(int imageIndex) {
        return this.root.getImage(imageIndex).sizeOfLinkedMicrobeamManipulationList();
    }

    public int getObjectiveCount(int instrumentIndex) {
        return this.root.getInstrument(instrumentIndex).sizeOfObjectiveList();
    }

    public int getPlaneCount(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().sizeOfPlaneList();
    }

    public int getPlateCount() {
        return this.root.sizeOfPlateList();
    }

    public int getPlateAcquisitionCount(int plateIndex) {
        return this.root.getPlate(plateIndex).sizeOfPlateAcquisitionList();
    }

    public int getPlateRefCount(int screenIndex) {
        return this.root.getScreen(screenIndex).sizeOfLinkedPlateList();
    }

    public int getProjectCount() {
        return this.root.sizeOfProjectList();
    }

    public int getROICount() {
        return this.root.sizeOfROIList();
    }

    public int getImageROIRefCount(int imageIndex) {
        return this.root.getImage(imageIndex).sizeOfLinkedROIList();
    }

    public int getMicrobeamManipulationROIRefCount(int experimentIndex, int microbeamManipulationIndex) {
        return this.root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex).sizeOfLinkedROIList();
    }

    public int getReagentCount(int screenIndex) {
        return this.root.getScreen(screenIndex).sizeOfReagentList();
    }

    public int getScreenCount() {
        return this.root.sizeOfScreenList();
    }

    public int getShapeCount(int ROIIndex) {
        return this.root.getROI(ROIIndex).getUnion().sizeOfShapeList();
    }

    public int getTagAnnotationCount() {
        return this.root.getStructuredAnnotations().sizeOfTagAnnotationList();
    }

    public int getTermAnnotationCount() {
        return this.root.getStructuredAnnotations().sizeOfTermAnnotationList();
    }

    public int getTiffDataCount(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().sizeOfTiffDataList();
    }

    public int getTimestampAnnotationCount() {
        return this.root.getStructuredAnnotations().sizeOfTimestampAnnotationList();
    }

    public void setUUIDValue(String value, int imageIndex, int tiffDataIndex) {
        TiffData o3;
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfTiffDataList() == tiffDataIndex) {
            o2.addTiffData(new TiffData());
        }
        if ((o3 = o2.getTiffData(tiffDataIndex)).getUUID() == null) {
            o3.setUUID(new UUID());
        }
        UUID o4 = o3.getUUID();
        o4.setValue(value);
    }

    public String getUUIDValue(int imageIndex, int tiffDataIndex) {
        return this.root.getImage(imageIndex).getPixels().getTiffData(tiffDataIndex).getUUID().getValue();
    }

    public int getWellCount(int plateIndex) {
        return this.root.getPlate(plateIndex).sizeOfWellList();
    }

    public int getWellSampleCount(int plateIndex, int wellIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).sizeOfWellSampleList();
    }

    public int getWellSampleRefCount(int plateIndex, int plateAcquisitionIndex) {
        return this.root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex).sizeOfLinkedWellSampleList();
    }

    public int getXMLAnnotationCount() {
        return this.root.getStructuredAnnotations().sizeOfXMLAnnotationList();
    }

    public Boolean getPixelsBinDataBigEndian(int imageIndex, int binDataIndex) {
        return this.root.getImage(imageIndex).getPixels().getBinData(binDataIndex).getBigEndian();
    }

    public String getUUID() {
        return this.root.getUUID();
    }

    public String getArcID(int instrumentIndex, int lightSourceIndex) {
        Arc o = (Arc)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getID();
    }

    public String getArcLotNumber(int instrumentIndex, int lightSourceIndex) {
        Arc o = (Arc)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getLotNumber();
    }

    public String getArcManufacturer(int instrumentIndex, int lightSourceIndex) {
        Arc o = (Arc)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getManufacturer();
    }

    public String getArcModel(int instrumentIndex, int lightSourceIndex) {
        Arc o = (Arc)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getModel();
    }

    public Double getArcPower(int instrumentIndex, int lightSourceIndex) {
        Arc o = (Arc)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getPower();
    }

    public String getArcSerialNumber(int instrumentIndex, int lightSourceIndex) {
        Arc o = (Arc)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getSerialNumber();
    }

    public ArcType getArcType(int instrumentIndex, int lightSourceIndex) {
        Arc o = (Arc)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getType();
    }

    public String getBinaryFileFileName(int fileAnnotationIndex) {
        return this.root.getStructuredAnnotations().getFileAnnotation(fileAnnotationIndex).getBinaryFile().getFileName();
    }

    public String getBinaryFileMIMEType(int fileAnnotationIndex) {
        return this.root.getStructuredAnnotations().getFileAnnotation(fileAnnotationIndex).getBinaryFile().getMIMEType();
    }

    public NonNegativeLong getBinaryFileSize(int fileAnnotationIndex) {
        return this.root.getStructuredAnnotations().getFileAnnotation(fileAnnotationIndex).getBinaryFile().getSize();
    }

    public String getBinaryOnlyMetadataFile(int metadataFileIndex) {
        return this.root.getBinaryOnly().getMetadataFile();
    }

    public String getBinaryOnlyUUID(int UUIDIndex) {
        return this.root.getBinaryOnly().getUUID();
    }

    public String getBooleanAnnotationAnnotationRef(int booleanAnnotationIndex, int annotationRefIndex) {
        return this.root.getStructuredAnnotations().getBooleanAnnotation(booleanAnnotationIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public String getBooleanAnnotationDescription(int booleanAnnotationIndex) {
        return this.root.getStructuredAnnotations().getBooleanAnnotation(booleanAnnotationIndex).getDescription();
    }

    public String getBooleanAnnotationID(int booleanAnnotationIndex) {
        return this.root.getStructuredAnnotations().getBooleanAnnotation(booleanAnnotationIndex).getID();
    }

    public String getBooleanAnnotationNamespace(int booleanAnnotationIndex) {
        return this.root.getStructuredAnnotations().getBooleanAnnotation(booleanAnnotationIndex).getNamespace();
    }

    public Boolean getBooleanAnnotationValue(int booleanAnnotationIndex) {
        return this.root.getStructuredAnnotations().getBooleanAnnotation(booleanAnnotationIndex).getValue();
    }

    public AcquisitionMode getChannelAcquisitionMode(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getAcquisitionMode();
    }

    public String getChannelAnnotationRef(int imageIndex, int channelIndex, int annotationRefIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public Color getChannelColor(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getColor();
    }

    public ContrastMethod getChannelContrastMethod(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getContrastMethod();
    }

    public PositiveInteger getChannelEmissionWavelength(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getEmissionWavelength();
    }

    public PositiveInteger getChannelExcitationWavelength(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getExcitationWavelength();
    }

    public String getChannelFilterSetRef(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLinkedFilterSet().getID();
    }

    public String getChannelFluor(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getFluor();
    }

    public String getChannelID(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getID();
    }

    public IlluminationType getChannelIlluminationType(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getIlluminationType();
    }

    public Double getChannelNDFilter(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getNDFilter();
    }

    public String getChannelName(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getName();
    }

    public Double getChannelPinholeSize(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getPinholeSize();
    }

    public Integer getChannelPockelCellSetting(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getPockelCellSetting();
    }

    public PositiveInteger getChannelSamplesPerPixel(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getSamplesPerPixel();
    }

    public String getCommentAnnotationAnnotationRef(int commentAnnotationIndex, int annotationRefIndex) {
        return this.root.getStructuredAnnotations().getCommentAnnotation(commentAnnotationIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public String getCommentAnnotationDescription(int commentAnnotationIndex) {
        return this.root.getStructuredAnnotations().getCommentAnnotation(commentAnnotationIndex).getDescription();
    }

    public String getCommentAnnotationID(int commentAnnotationIndex) {
        return this.root.getStructuredAnnotations().getCommentAnnotation(commentAnnotationIndex).getID();
    }

    public String getCommentAnnotationNamespace(int commentAnnotationIndex) {
        return this.root.getStructuredAnnotations().getCommentAnnotation(commentAnnotationIndex).getNamespace();
    }

    public String getCommentAnnotationValue(int commentAnnotationIndex) {
        return this.root.getStructuredAnnotations().getCommentAnnotation(commentAnnotationIndex).getValue();
    }

    public String getDatasetAnnotationRef(int datasetIndex, int annotationRefIndex) {
        return this.root.getDataset(datasetIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public String getDatasetDescription(int datasetIndex) {
        return this.root.getDataset(datasetIndex).getDescription();
    }

    public String getDatasetExperimenterGroupRef(int datasetIndex) {
        return this.root.getDataset(datasetIndex).getLinkedExperimenterGroup().getID();
    }

    public String getDatasetExperimenterRef(int datasetIndex) {
        return this.root.getDataset(datasetIndex).getLinkedExperimenter().getID();
    }

    public String getDatasetID(int datasetIndex) {
        return this.root.getDataset(datasetIndex).getID();
    }

    public String getDatasetImageRef(int datasetIndex, int imageRefIndex) {
        return this.root.getDataset(datasetIndex).getLinkedImage(imageRefIndex).getID();
    }

    public String getDatasetName(int datasetIndex) {
        return this.root.getDataset(datasetIndex).getName();
    }

    public Double getDetectorAmplificationGain(int instrumentIndex, int detectorIndex) {
        return this.root.getInstrument(instrumentIndex).getDetector(detectorIndex).getAmplificationGain();
    }

    public Double getDetectorGain(int instrumentIndex, int detectorIndex) {
        return this.root.getInstrument(instrumentIndex).getDetector(detectorIndex).getGain();
    }

    public String getDetectorID(int instrumentIndex, int detectorIndex) {
        return this.root.getInstrument(instrumentIndex).getDetector(detectorIndex).getID();
    }

    public String getDetectorLotNumber(int instrumentIndex, int detectorIndex) {
        return this.root.getInstrument(instrumentIndex).getDetector(detectorIndex).getLotNumber();
    }

    public String getDetectorManufacturer(int instrumentIndex, int detectorIndex) {
        return this.root.getInstrument(instrumentIndex).getDetector(detectorIndex).getManufacturer();
    }

    public String getDetectorModel(int instrumentIndex, int detectorIndex) {
        return this.root.getInstrument(instrumentIndex).getDetector(detectorIndex).getModel();
    }

    public Double getDetectorOffset(int instrumentIndex, int detectorIndex) {
        return this.root.getInstrument(instrumentIndex).getDetector(detectorIndex).getOffset();
    }

    public String getDetectorSerialNumber(int instrumentIndex, int detectorIndex) {
        return this.root.getInstrument(instrumentIndex).getDetector(detectorIndex).getSerialNumber();
    }

    public DetectorType getDetectorType(int instrumentIndex, int detectorIndex) {
        return this.root.getInstrument(instrumentIndex).getDetector(detectorIndex).getType();
    }

    public Double getDetectorVoltage(int instrumentIndex, int detectorIndex) {
        return this.root.getInstrument(instrumentIndex).getDetector(detectorIndex).getVoltage();
    }

    public Double getDetectorZoom(int instrumentIndex, int detectorIndex) {
        return this.root.getInstrument(instrumentIndex).getDetector(detectorIndex).getZoom();
    }

    public Binning getDetectorSettingsBinning(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getDetectorSettings().getBinning();
    }

    public Double getDetectorSettingsGain(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getDetectorSettings().getGain();
    }

    public String getDetectorSettingsID(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getDetectorSettings().getID();
    }

    public Double getDetectorSettingsOffset(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getDetectorSettings().getOffset();
    }

    public Double getDetectorSettingsReadOutRate(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getDetectorSettings().getReadOutRate();
    }

    public Double getDetectorSettingsVoltage(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getDetectorSettings().getVoltage();
    }

    public String getDichroicID(int instrumentIndex, int dichroicIndex) {
        return this.root.getInstrument(instrumentIndex).getDichroic(dichroicIndex).getID();
    }

    public String getDichroicLotNumber(int instrumentIndex, int dichroicIndex) {
        return this.root.getInstrument(instrumentIndex).getDichroic(dichroicIndex).getLotNumber();
    }

    public String getDichroicManufacturer(int instrumentIndex, int dichroicIndex) {
        return this.root.getInstrument(instrumentIndex).getDichroic(dichroicIndex).getManufacturer();
    }

    public String getDichroicModel(int instrumentIndex, int dichroicIndex) {
        return this.root.getInstrument(instrumentIndex).getDichroic(dichroicIndex).getModel();
    }

    public String getDichroicSerialNumber(int instrumentIndex, int dichroicIndex) {
        return this.root.getInstrument(instrumentIndex).getDichroic(dichroicIndex).getSerialNumber();
    }

    public String getDoubleAnnotationAnnotationRef(int doubleAnnotationIndex, int annotationRefIndex) {
        return this.root.getStructuredAnnotations().getDoubleAnnotation(doubleAnnotationIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public String getDoubleAnnotationDescription(int doubleAnnotationIndex) {
        return this.root.getStructuredAnnotations().getDoubleAnnotation(doubleAnnotationIndex).getDescription();
    }

    public String getDoubleAnnotationID(int doubleAnnotationIndex) {
        return this.root.getStructuredAnnotations().getDoubleAnnotation(doubleAnnotationIndex).getID();
    }

    public String getDoubleAnnotationNamespace(int doubleAnnotationIndex) {
        return this.root.getStructuredAnnotations().getDoubleAnnotation(doubleAnnotationIndex).getNamespace();
    }

    public Double getDoubleAnnotationValue(int doubleAnnotationIndex) {
        return this.root.getStructuredAnnotations().getDoubleAnnotation(doubleAnnotationIndex).getValue();
    }

    public Color getEllipseFillColor(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFillColor();
    }

    public FillRule getEllipseFillRule(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFillRule();
    }

    public FontFamily getEllipseFontFamily(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontFamily();
    }

    public NonNegativeInteger getEllipseFontSize(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontSize();
    }

    public FontStyle getEllipseFontStyle(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontStyle();
    }

    public String getEllipseID(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getID();
    }

    public LineCap getEllipseLineCap(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLineCap();
    }

    public Boolean getEllipseLocked(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLocked();
    }

    public Color getEllipseStrokeColor(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeColor();
    }

    public String getEllipseStrokeDashArray(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeDashArray();
    }

    public Double getEllipseStrokeWidth(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeWidth();
    }

    public String getEllipseText(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getText();
    }

    public NonNegativeInteger getEllipseTheC(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheC();
    }

    public NonNegativeInteger getEllipseTheT(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheT();
    }

    public NonNegativeInteger getEllipseTheZ(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheZ();
    }

    public AffineTransform getEllipseTransform(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTransform();
    }

    public Boolean getEllipseVisible(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getVisible();
    }

    public Double getEllipseRadiusX(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getRadiusX();
    }

    public Double getEllipseRadiusY(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getRadiusY();
    }

    public Double getEllipseX(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getX();
    }

    public Double getEllipseY(int ROIIndex, int shapeIndex) {
        Ellipse o = (Ellipse)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getY();
    }

    public String getExperimentDescription(int experimentIndex) {
        return this.root.getExperiment(experimentIndex).getDescription();
    }

    public String getExperimentExperimenterRef(int experimentIndex) {
        return this.root.getExperiment(experimentIndex).getLinkedExperimenter().getID();
    }

    public String getExperimentID(int experimentIndex) {
        return this.root.getExperiment(experimentIndex).getID();
    }

    public ExperimentType getExperimentType(int experimentIndex) {
        return this.root.getExperiment(experimentIndex).getType();
    }

    public String getExperimenterAnnotationRef(int experimenterIndex, int annotationRefIndex) {
        return this.root.getExperimenter(experimenterIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public String getExperimenterEmail(int experimenterIndex) {
        return this.root.getExperimenter(experimenterIndex).getEmail();
    }

    public String getExperimenterFirstName(int experimenterIndex) {
        return this.root.getExperimenter(experimenterIndex).getFirstName();
    }

    public String getExperimenterID(int experimenterIndex) {
        return this.root.getExperimenter(experimenterIndex).getID();
    }

    public String getExperimenterInstitution(int experimenterIndex) {
        return this.root.getExperimenter(experimenterIndex).getInstitution();
    }

    public String getExperimenterLastName(int experimenterIndex) {
        return this.root.getExperimenter(experimenterIndex).getLastName();
    }

    public String getExperimenterMiddleName(int experimenterIndex) {
        return this.root.getExperimenter(experimenterIndex).getMiddleName();
    }

    public String getExperimenterUserName(int experimenterIndex) {
        return this.root.getExperimenter(experimenterIndex).getUserName();
    }

    public String getExperimenterGroupAnnotationRef(int experimenterGroupIndex, int annotationRefIndex) {
        return this.root.getExperimenterGroup(experimenterGroupIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public String getExperimenterGroupDescription(int experimenterGroupIndex) {
        return this.root.getExperimenterGroup(experimenterGroupIndex).getDescription();
    }

    public String getExperimenterGroupExperimenterRef(int experimenterGroupIndex, int experimenterRefIndex) {
        return this.root.getExperimenterGroup(experimenterGroupIndex).getLinkedExperimenter(experimenterRefIndex).getID();
    }

    public String getExperimenterGroupID(int experimenterGroupIndex) {
        return this.root.getExperimenterGroup(experimenterGroupIndex).getID();
    }

    public String getExperimenterGroupLeader(int experimenterGroupIndex, int leaderIndex) {
        return this.root.getExperimenterGroup(experimenterGroupIndex).getLinkedLeader(leaderIndex).getID();
    }

    public String getExperimenterGroupName(int experimenterGroupIndex) {
        return this.root.getExperimenterGroup(experimenterGroupIndex).getName();
    }

    public String getFilamentID(int instrumentIndex, int lightSourceIndex) {
        Filament o = (Filament)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getID();
    }

    public String getFilamentLotNumber(int instrumentIndex, int lightSourceIndex) {
        Filament o = (Filament)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getLotNumber();
    }

    public String getFilamentManufacturer(int instrumentIndex, int lightSourceIndex) {
        Filament o = (Filament)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getManufacturer();
    }

    public String getFilamentModel(int instrumentIndex, int lightSourceIndex) {
        Filament o = (Filament)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getModel();
    }

    public Double getFilamentPower(int instrumentIndex, int lightSourceIndex) {
        Filament o = (Filament)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getPower();
    }

    public String getFilamentSerialNumber(int instrumentIndex, int lightSourceIndex) {
        Filament o = (Filament)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getSerialNumber();
    }

    public FilamentType getFilamentType(int instrumentIndex, int lightSourceIndex) {
        Filament o = (Filament)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getType();
    }

    public String getFileAnnotationAnnotationRef(int fileAnnotationIndex, int annotationRefIndex) {
        return this.root.getStructuredAnnotations().getFileAnnotation(fileAnnotationIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public String getFileAnnotationDescription(int fileAnnotationIndex) {
        return this.root.getStructuredAnnotations().getFileAnnotation(fileAnnotationIndex).getDescription();
    }

    public String getFileAnnotationID(int fileAnnotationIndex) {
        return this.root.getStructuredAnnotations().getFileAnnotation(fileAnnotationIndex).getID();
    }

    public String getFileAnnotationNamespace(int fileAnnotationIndex) {
        return this.root.getStructuredAnnotations().getFileAnnotation(fileAnnotationIndex).getNamespace();
    }

    public String getFilterFilterWheel(int instrumentIndex, int filterIndex) {
        return this.root.getInstrument(instrumentIndex).getFilter(filterIndex).getFilterWheel();
    }

    public String getFilterID(int instrumentIndex, int filterIndex) {
        return this.root.getInstrument(instrumentIndex).getFilter(filterIndex).getID();
    }

    public String getFilterLotNumber(int instrumentIndex, int filterIndex) {
        return this.root.getInstrument(instrumentIndex).getFilter(filterIndex).getLotNumber();
    }

    public String getFilterManufacturer(int instrumentIndex, int filterIndex) {
        return this.root.getInstrument(instrumentIndex).getFilter(filterIndex).getManufacturer();
    }

    public String getFilterModel(int instrumentIndex, int filterIndex) {
        return this.root.getInstrument(instrumentIndex).getFilter(filterIndex).getModel();
    }

    public String getFilterSerialNumber(int instrumentIndex, int filterIndex) {
        return this.root.getInstrument(instrumentIndex).getFilter(filterIndex).getSerialNumber();
    }

    public FilterType getFilterType(int instrumentIndex, int filterIndex) {
        return this.root.getInstrument(instrumentIndex).getFilter(filterIndex).getType();
    }

    public String getFilterSetDichroicRef(int instrumentIndex, int filterSetIndex) {
        return this.root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex).getLinkedDichroic().getID();
    }

    public String getFilterSetEmissionFilterRef(int instrumentIndex, int filterSetIndex, int emissionFilterRefIndex) {
        return this.root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex).getLinkedEmissionFilter(emissionFilterRefIndex).getID();
    }

    public String getFilterSetExcitationFilterRef(int instrumentIndex, int filterSetIndex, int excitationFilterRefIndex) {
        return this.root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex).getLinkedExcitationFilter(excitationFilterRefIndex).getID();
    }

    public String getFilterSetID(int instrumentIndex, int filterSetIndex) {
        return this.root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex).getID();
    }

    public String getFilterSetLotNumber(int instrumentIndex, int filterSetIndex) {
        return this.root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex).getLotNumber();
    }

    public String getFilterSetManufacturer(int instrumentIndex, int filterSetIndex) {
        return this.root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex).getManufacturer();
    }

    public String getFilterSetModel(int instrumentIndex, int filterSetIndex) {
        return this.root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex).getModel();
    }

    public String getFilterSetSerialNumber(int instrumentIndex, int filterSetIndex) {
        return this.root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex).getSerialNumber();
    }

    public Timestamp getImageAcquisitionDate(int imageIndex) {
        return this.root.getImage(imageIndex).getAcquisitionDate();
    }

    public String getImageAnnotationRef(int imageIndex, int annotationRefIndex) {
        return this.root.getImage(imageIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public String getImageDescription(int imageIndex) {
        return this.root.getImage(imageIndex).getDescription();
    }

    public String getImageExperimentRef(int imageIndex) {
        return this.root.getImage(imageIndex).getLinkedExperiment().getID();
    }

    public String getImageExperimenterGroupRef(int imageIndex) {
        return this.root.getImage(imageIndex).getLinkedExperimenterGroup().getID();
    }

    public String getImageExperimenterRef(int imageIndex) {
        return this.root.getImage(imageIndex).getLinkedExperimenter().getID();
    }

    public String getImageID(int imageIndex) {
        return this.root.getImage(imageIndex).getID();
    }

    public String getImageInstrumentRef(int imageIndex) {
        return this.root.getImage(imageIndex).getLinkedInstrument().getID();
    }

    public String getImageMicrobeamManipulationRef(int imageIndex, int microbeamManipulationRefIndex) {
        return this.root.getImage(imageIndex).getLinkedMicrobeamManipulation(microbeamManipulationRefIndex).getID();
    }

    public String getImageName(int imageIndex) {
        return this.root.getImage(imageIndex).getName();
    }

    public String getImageROIRef(int imageIndex, int ROIRefIndex) {
        return this.root.getImage(imageIndex).getLinkedROI(ROIRefIndex).getID();
    }

    public Double getImagingEnvironmentAirPressure(int imageIndex) {
        return this.root.getImage(imageIndex).getImagingEnvironment().getAirPressure();
    }

    public PercentFraction getImagingEnvironmentCO2Percent(int imageIndex) {
        return this.root.getImage(imageIndex).getImagingEnvironment().getCO2Percent();
    }

    public PercentFraction getImagingEnvironmentHumidity(int imageIndex) {
        return this.root.getImage(imageIndex).getImagingEnvironment().getHumidity();
    }

    public Double getImagingEnvironmentTemperature(int imageIndex) {
        return this.root.getImage(imageIndex).getImagingEnvironment().getTemperature();
    }

    public String getInstrumentID(int instrumentIndex) {
        return this.root.getInstrument(instrumentIndex).getID();
    }

    public Color getLabelFillColor(int ROIIndex, int shapeIndex) {
        Label o = (Label)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFillColor();
    }

    public FillRule getLabelFillRule(int ROIIndex, int shapeIndex) {
        Label o = (Label)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFillRule();
    }

    public FontFamily getLabelFontFamily(int ROIIndex, int shapeIndex) {
        Label o = (Label)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontFamily();
    }

    public NonNegativeInteger getLabelFontSize(int ROIIndex, int shapeIndex) {
        Label o = (Label)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontSize();
    }

    public FontStyle getLabelFontStyle(int ROIIndex, int shapeIndex) {
        Label o = (Label)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontStyle();
    }

    public String getLabelID(int ROIIndex, int shapeIndex) {
        Label o = (Label)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getID();
    }

    public LineCap getLabelLineCap(int ROIIndex, int shapeIndex) {
        Label o = (Label)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLineCap();
    }

    public Boolean getLabelLocked(int ROIIndex, int shapeIndex) {
        Label o = (Label)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLocked();
    }

    public Color getLabelStrokeColor(int ROIIndex, int shapeIndex) {
        Label o = (Label)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeColor();
    }

    public String getLabelStrokeDashArray(int ROIIndex, int shapeIndex) {
        Label o = (Label)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeDashArray();
    }

    public Double getLabelStrokeWidth(int ROIIndex, int shapeIndex) {
        Label o = (Label)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeWidth();
    }

    public String getLabelText(int ROIIndex, int shapeIndex) {
        Label o = (Label)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getText();
    }

    public NonNegativeInteger getLabelTheC(int ROIIndex, int shapeIndex) {
        Label o = (Label)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheC();
    }

    public NonNegativeInteger getLabelTheT(int ROIIndex, int shapeIndex) {
        Label o = (Label)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheT();
    }

    public NonNegativeInteger getLabelTheZ(int ROIIndex, int shapeIndex) {
        Label o = (Label)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheZ();
    }

    public AffineTransform getLabelTransform(int ROIIndex, int shapeIndex) {
        Label o = (Label)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTransform();
    }

    public Boolean getLabelVisible(int ROIIndex, int shapeIndex) {
        Label o = (Label)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getVisible();
    }

    public Double getLabelX(int ROIIndex, int shapeIndex) {
        Label o = (Label)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getX();
    }

    public Double getLabelY(int ROIIndex, int shapeIndex) {
        Label o = (Label)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getY();
    }

    public String getLaserID(int instrumentIndex, int lightSourceIndex) {
        Laser o = (Laser)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getID();
    }

    public String getLaserLotNumber(int instrumentIndex, int lightSourceIndex) {
        Laser o = (Laser)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getLotNumber();
    }

    public String getLaserManufacturer(int instrumentIndex, int lightSourceIndex) {
        Laser o = (Laser)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getManufacturer();
    }

    public String getLaserModel(int instrumentIndex, int lightSourceIndex) {
        Laser o = (Laser)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getModel();
    }

    public Double getLaserPower(int instrumentIndex, int lightSourceIndex) {
        Laser o = (Laser)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getPower();
    }

    public String getLaserSerialNumber(int instrumentIndex, int lightSourceIndex) {
        Laser o = (Laser)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getSerialNumber();
    }

    public PositiveInteger getLaserFrequencyMultiplication(int instrumentIndex, int lightSourceIndex) {
        Laser o = (Laser)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getFrequencyMultiplication();
    }

    public LaserMedium getLaserLaserMedium(int instrumentIndex, int lightSourceIndex) {
        Laser o = (Laser)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getLaserMedium();
    }

    public Boolean getLaserPockelCell(int instrumentIndex, int lightSourceIndex) {
        Laser o = (Laser)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getPockelCell();
    }

    public Pulse getLaserPulse(int instrumentIndex, int lightSourceIndex) {
        Laser o = (Laser)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getPulse();
    }

    public String getLaserPump(int instrumentIndex, int lightSourceIndex) {
        Laser o = (Laser)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getLinkedPump().getID();
    }

    public Double getLaserRepetitionRate(int instrumentIndex, int lightSourceIndex) {
        Laser o = (Laser)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getRepetitionRate();
    }

    public Boolean getLaserTuneable(int instrumentIndex, int lightSourceIndex) {
        Laser o = (Laser)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getTuneable();
    }

    public LaserType getLaserType(int instrumentIndex, int lightSourceIndex) {
        Laser o = (Laser)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getType();
    }

    public PositiveInteger getLaserWavelength(int instrumentIndex, int lightSourceIndex) {
        Laser o = (Laser)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getWavelength();
    }

    public String getLightEmittingDiodeID(int instrumentIndex, int lightSourceIndex) {
        LightEmittingDiode o = (LightEmittingDiode)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getID();
    }

    public String getLightEmittingDiodeLotNumber(int instrumentIndex, int lightSourceIndex) {
        LightEmittingDiode o = (LightEmittingDiode)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getLotNumber();
    }

    public String getLightEmittingDiodeManufacturer(int instrumentIndex, int lightSourceIndex) {
        LightEmittingDiode o = (LightEmittingDiode)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getManufacturer();
    }

    public String getLightEmittingDiodeModel(int instrumentIndex, int lightSourceIndex) {
        LightEmittingDiode o = (LightEmittingDiode)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getModel();
    }

    public Double getLightEmittingDiodePower(int instrumentIndex, int lightSourceIndex) {
        LightEmittingDiode o = (LightEmittingDiode)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getPower();
    }

    public String getLightEmittingDiodeSerialNumber(int instrumentIndex, int lightSourceIndex) {
        LightEmittingDiode o = (LightEmittingDiode)this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
        return o.getSerialNumber();
    }

    public String getLightPathDichroicRef(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightPath().getLinkedDichroic().getID();
    }

    public String getLightPathEmissionFilterRef(int imageIndex, int channelIndex, int emissionFilterRefIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightPath().getLinkedEmissionFilter(emissionFilterRefIndex).getID();
    }

    public String getLightPathExcitationFilterRef(int imageIndex, int channelIndex, int excitationFilterRefIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightPath().getLinkedExcitationFilter(excitationFilterRefIndex).getID();
    }

    public PercentFraction getChannelLightSourceSettingsAttenuation(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightSourceSettings().getAttenuation();
    }

    public PercentFraction getMicrobeamManipulationLightSourceSettingsAttenuation(int experimentIndex, int microbeamManipulationIndex, int lightSourceSettingsIndex) {
        return this.root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex).getLightSourceSettings(lightSourceSettingsIndex).getAttenuation();
    }

    public String getChannelLightSourceSettingsID(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightSourceSettings().getID();
    }

    public String getMicrobeamManipulationLightSourceSettingsID(int experimentIndex, int microbeamManipulationIndex, int lightSourceSettingsIndex) {
        return this.root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex).getLightSourceSettings(lightSourceSettingsIndex).getID();
    }

    public PositiveInteger getChannelLightSourceSettingsWavelength(int imageIndex, int channelIndex) {
        return this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightSourceSettings().getWavelength();
    }

    public PositiveInteger getMicrobeamManipulationLightSourceSettingsWavelength(int experimentIndex, int microbeamManipulationIndex, int lightSourceSettingsIndex) {
        return this.root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex).getLightSourceSettings(lightSourceSettingsIndex).getWavelength();
    }

    public Color getLineFillColor(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFillColor();
    }

    public FillRule getLineFillRule(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFillRule();
    }

    public FontFamily getLineFontFamily(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontFamily();
    }

    public NonNegativeInteger getLineFontSize(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontSize();
    }

    public FontStyle getLineFontStyle(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontStyle();
    }

    public String getLineID(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getID();
    }

    public LineCap getLineLineCap(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLineCap();
    }

    public Boolean getLineLocked(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLocked();
    }

    public Color getLineStrokeColor(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeColor();
    }

    public String getLineStrokeDashArray(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeDashArray();
    }

    public Double getLineStrokeWidth(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeWidth();
    }

    public String getLineText(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getText();
    }

    public NonNegativeInteger getLineTheC(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheC();
    }

    public NonNegativeInteger getLineTheT(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheT();
    }

    public NonNegativeInteger getLineTheZ(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheZ();
    }

    public AffineTransform getLineTransform(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTransform();
    }

    public Boolean getLineVisible(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getVisible();
    }

    public Marker getLineMarkerEnd(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getMarkerEnd();
    }

    public Marker getLineMarkerStart(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getMarkerStart();
    }

    public Double getLineX1(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getX1();
    }

    public Double getLineX2(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getX2();
    }

    public Double getLineY1(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getY1();
    }

    public Double getLineY2(int ROIIndex, int shapeIndex) {
        Line o = (Line)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getY2();
    }

    public String getListAnnotationAnnotationRef(int listAnnotationIndex, int annotationRefIndex) {
        return this.root.getStructuredAnnotations().getListAnnotation(listAnnotationIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public String getListAnnotationDescription(int listAnnotationIndex) {
        return this.root.getStructuredAnnotations().getListAnnotation(listAnnotationIndex).getDescription();
    }

    public String getListAnnotationID(int listAnnotationIndex) {
        return this.root.getStructuredAnnotations().getListAnnotation(listAnnotationIndex).getID();
    }

    public String getListAnnotationNamespace(int listAnnotationIndex) {
        return this.root.getStructuredAnnotations().getListAnnotation(listAnnotationIndex).getNamespace();
    }

    public String getLongAnnotationAnnotationRef(int longAnnotationIndex, int annotationRefIndex) {
        return this.root.getStructuredAnnotations().getLongAnnotation(longAnnotationIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public String getLongAnnotationDescription(int longAnnotationIndex) {
        return this.root.getStructuredAnnotations().getLongAnnotation(longAnnotationIndex).getDescription();
    }

    public String getLongAnnotationID(int longAnnotationIndex) {
        return this.root.getStructuredAnnotations().getLongAnnotation(longAnnotationIndex).getID();
    }

    public String getLongAnnotationNamespace(int longAnnotationIndex) {
        return this.root.getStructuredAnnotations().getLongAnnotation(longAnnotationIndex).getNamespace();
    }

    public Long getLongAnnotationValue(int longAnnotationIndex) {
        return this.root.getStructuredAnnotations().getLongAnnotation(longAnnotationIndex).getValue();
    }

    public Color getMaskFillColor(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFillColor();
    }

    public FillRule getMaskFillRule(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFillRule();
    }

    public FontFamily getMaskFontFamily(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontFamily();
    }

    public NonNegativeInteger getMaskFontSize(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontSize();
    }

    public FontStyle getMaskFontStyle(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontStyle();
    }

    public String getMaskID(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getID();
    }

    public LineCap getMaskLineCap(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLineCap();
    }

    public Boolean getMaskLocked(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLocked();
    }

    public Color getMaskStrokeColor(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeColor();
    }

    public String getMaskStrokeDashArray(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeDashArray();
    }

    public Double getMaskStrokeWidth(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeWidth();
    }

    public String getMaskText(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getText();
    }

    public NonNegativeInteger getMaskTheC(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheC();
    }

    public NonNegativeInteger getMaskTheT(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheT();
    }

    public NonNegativeInteger getMaskTheZ(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheZ();
    }

    public AffineTransform getMaskTransform(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTransform();
    }

    public Boolean getMaskVisible(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getVisible();
    }

    public Double getMaskHeight(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getHeight();
    }

    public Double getMaskWidth(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getWidth();
    }

    public Double getMaskX(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getX();
    }

    public Double getMaskY(int ROIIndex, int shapeIndex) {
        Mask o = (Mask)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getY();
    }

    public String getMicrobeamManipulationDescription(int experimentIndex, int microbeamManipulationIndex) {
        return this.root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex).getDescription();
    }

    public String getMicrobeamManipulationExperimenterRef(int experimentIndex, int microbeamManipulationIndex) {
        return this.root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex).getLinkedExperimenter().getID();
    }

    public String getMicrobeamManipulationID(int experimentIndex, int microbeamManipulationIndex) {
        return this.root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex).getID();
    }

    public String getMicrobeamManipulationROIRef(int experimentIndex, int microbeamManipulationIndex, int ROIRefIndex) {
        return this.root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex).getLinkedROI(ROIRefIndex).getID();
    }

    public MicrobeamManipulationType getMicrobeamManipulationType(int experimentIndex, int microbeamManipulationIndex) {
        return this.root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex).getType();
    }

    public String getMicroscopeLotNumber(int instrumentIndex) {
        return this.root.getInstrument(instrumentIndex).getMicroscope().getLotNumber();
    }

    public String getMicroscopeManufacturer(int instrumentIndex) {
        return this.root.getInstrument(instrumentIndex).getMicroscope().getManufacturer();
    }

    public String getMicroscopeModel(int instrumentIndex) {
        return this.root.getInstrument(instrumentIndex).getMicroscope().getModel();
    }

    public String getMicroscopeSerialNumber(int instrumentIndex) {
        return this.root.getInstrument(instrumentIndex).getMicroscope().getSerialNumber();
    }

    public MicroscopeType getMicroscopeType(int instrumentIndex) {
        return this.root.getInstrument(instrumentIndex).getMicroscope().getType();
    }

    public Double getObjectiveCalibratedMagnification(int instrumentIndex, int objectiveIndex) {
        return this.root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getCalibratedMagnification();
    }

    public Correction getObjectiveCorrection(int instrumentIndex, int objectiveIndex) {
        return this.root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getCorrection();
    }

    public String getObjectiveID(int instrumentIndex, int objectiveIndex) {
        return this.root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getID();
    }

    public Immersion getObjectiveImmersion(int instrumentIndex, int objectiveIndex) {
        return this.root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getImmersion();
    }

    public Boolean getObjectiveIris(int instrumentIndex, int objectiveIndex) {
        return this.root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getIris();
    }

    public Double getObjectiveLensNA(int instrumentIndex, int objectiveIndex) {
        return this.root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getLensNA();
    }

    public String getObjectiveLotNumber(int instrumentIndex, int objectiveIndex) {
        return this.root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getLotNumber();
    }

    public String getObjectiveManufacturer(int instrumentIndex, int objectiveIndex) {
        return this.root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getManufacturer();
    }

    public String getObjectiveModel(int instrumentIndex, int objectiveIndex) {
        return this.root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getModel();
    }

    public PositiveInteger getObjectiveNominalMagnification(int instrumentIndex, int objectiveIndex) {
        return this.root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getNominalMagnification();
    }

    public String getObjectiveSerialNumber(int instrumentIndex, int objectiveIndex) {
        return this.root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getSerialNumber();
    }

    public Double getObjectiveWorkingDistance(int instrumentIndex, int objectiveIndex) {
        return this.root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getWorkingDistance();
    }

    public Double getObjectiveSettingsCorrectionCollar(int imageIndex) {
        return this.root.getImage(imageIndex).getObjectiveSettings().getCorrectionCollar();
    }

    public String getObjectiveSettingsID(int imageIndex) {
        return this.root.getImage(imageIndex).getObjectiveSettings().getID();
    }

    public Medium getObjectiveSettingsMedium(int imageIndex) {
        return this.root.getImage(imageIndex).getObjectiveSettings().getMedium();
    }

    public Double getObjectiveSettingsRefractiveIndex(int imageIndex) {
        return this.root.getImage(imageIndex).getObjectiveSettings().getRefractiveIndex();
    }

    public String getPixelsAnnotationRef(int imageIndex, int annotationRefIndex) {
        return this.root.getImage(imageIndex).getPixels().getLinkedAnnotation(annotationRefIndex).getID();
    }

    public DimensionOrder getPixelsDimensionOrder(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().getDimensionOrder();
    }

    public String getPixelsID(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().getID();
    }

    public PositiveFloat getPixelsPhysicalSizeX(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().getPhysicalSizeX();
    }

    public PositiveFloat getPixelsPhysicalSizeY(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().getPhysicalSizeY();
    }

    public PositiveFloat getPixelsPhysicalSizeZ(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().getPhysicalSizeZ();
    }

    public PositiveInteger getPixelsSizeC(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().getSizeC();
    }

    public PositiveInteger getPixelsSizeT(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().getSizeT();
    }

    public PositiveInteger getPixelsSizeX(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().getSizeX();
    }

    public PositiveInteger getPixelsSizeY(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().getSizeY();
    }

    public PositiveInteger getPixelsSizeZ(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().getSizeZ();
    }

    public Double getPixelsTimeIncrement(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().getTimeIncrement();
    }

    public PixelType getPixelsType(int imageIndex) {
        return this.root.getImage(imageIndex).getPixels().getType();
    }

    public String getPlaneAnnotationRef(int imageIndex, int planeIndex, int annotationRefIndex) {
        return this.root.getImage(imageIndex).getPixels().getPlane(planeIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public Double getPlaneDeltaT(int imageIndex, int planeIndex) {
        return this.root.getImage(imageIndex).getPixels().getPlane(planeIndex).getDeltaT();
    }

    public Double getPlaneExposureTime(int imageIndex, int planeIndex) {
        return this.root.getImage(imageIndex).getPixels().getPlane(planeIndex).getExposureTime();
    }

    public String getPlaneHashSHA1(int imageIndex, int planeIndex) {
        return this.root.getImage(imageIndex).getPixels().getPlane(planeIndex).getHashSHA1();
    }

    public Double getPlanePositionX(int imageIndex, int planeIndex) {
        return this.root.getImage(imageIndex).getPixels().getPlane(planeIndex).getPositionX();
    }

    public Double getPlanePositionY(int imageIndex, int planeIndex) {
        return this.root.getImage(imageIndex).getPixels().getPlane(planeIndex).getPositionY();
    }

    public Double getPlanePositionZ(int imageIndex, int planeIndex) {
        return this.root.getImage(imageIndex).getPixels().getPlane(planeIndex).getPositionZ();
    }

    public NonNegativeInteger getPlaneTheC(int imageIndex, int planeIndex) {
        return this.root.getImage(imageIndex).getPixels().getPlane(planeIndex).getTheC();
    }

    public NonNegativeInteger getPlaneTheT(int imageIndex, int planeIndex) {
        return this.root.getImage(imageIndex).getPixels().getPlane(planeIndex).getTheT();
    }

    public NonNegativeInteger getPlaneTheZ(int imageIndex, int planeIndex) {
        return this.root.getImage(imageIndex).getPixels().getPlane(planeIndex).getTheZ();
    }

    public String getPlateAnnotationRef(int plateIndex, int annotationRefIndex) {
        return this.root.getPlate(plateIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public NamingConvention getPlateColumnNamingConvention(int plateIndex) {
        return this.root.getPlate(plateIndex).getColumnNamingConvention();
    }

    public PositiveInteger getPlateColumns(int plateIndex) {
        return this.root.getPlate(plateIndex).getColumns();
    }

    public String getPlateDescription(int plateIndex) {
        return this.root.getPlate(plateIndex).getDescription();
    }

    public String getPlateExternalIdentifier(int plateIndex) {
        return this.root.getPlate(plateIndex).getExternalIdentifier();
    }

    public NonNegativeInteger getPlateFieldIndex(int plateIndex) {
        return this.root.getPlate(plateIndex).getFieldIndex();
    }

    public String getPlateID(int plateIndex) {
        return this.root.getPlate(plateIndex).getID();
    }

    public String getPlateName(int plateIndex) {
        return this.root.getPlate(plateIndex).getName();
    }

    public NamingConvention getPlateRowNamingConvention(int plateIndex) {
        return this.root.getPlate(plateIndex).getRowNamingConvention();
    }

    public PositiveInteger getPlateRows(int plateIndex) {
        return this.root.getPlate(plateIndex).getRows();
    }

    public String getPlateStatus(int plateIndex) {
        return this.root.getPlate(plateIndex).getStatus();
    }

    public Double getPlateWellOriginX(int plateIndex) {
        return this.root.getPlate(plateIndex).getWellOriginX();
    }

    public Double getPlateWellOriginY(int plateIndex) {
        return this.root.getPlate(plateIndex).getWellOriginY();
    }

    public String getPlateAcquisitionAnnotationRef(int plateIndex, int plateAcquisitionIndex, int annotationRefIndex) {
        return this.root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public String getPlateAcquisitionDescription(int plateIndex, int plateAcquisitionIndex) {
        return this.root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex).getDescription();
    }

    public Timestamp getPlateAcquisitionEndTime(int plateIndex, int plateAcquisitionIndex) {
        return this.root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex).getEndTime();
    }

    public String getPlateAcquisitionID(int plateIndex, int plateAcquisitionIndex) {
        return this.root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex).getID();
    }

    public PositiveInteger getPlateAcquisitionMaximumFieldCount(int plateIndex, int plateAcquisitionIndex) {
        return this.root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex).getMaximumFieldCount();
    }

    public String getPlateAcquisitionName(int plateIndex, int plateAcquisitionIndex) {
        return this.root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex).getName();
    }

    public Timestamp getPlateAcquisitionStartTime(int plateIndex, int plateAcquisitionIndex) {
        return this.root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex).getStartTime();
    }

    public String getPlateAcquisitionWellSampleRef(int plateIndex, int plateAcquisitionIndex, int wellSampleRefIndex) {
        return this.root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex).getLinkedWellSample(wellSampleRefIndex).getID();
    }

    public Color getPointFillColor(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFillColor();
    }

    public FillRule getPointFillRule(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFillRule();
    }

    public FontFamily getPointFontFamily(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontFamily();
    }

    public NonNegativeInteger getPointFontSize(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontSize();
    }

    public FontStyle getPointFontStyle(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontStyle();
    }

    public String getPointID(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getID();
    }

    public LineCap getPointLineCap(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLineCap();
    }

    public Boolean getPointLocked(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLocked();
    }

    public Color getPointStrokeColor(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeColor();
    }

    public String getPointStrokeDashArray(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeDashArray();
    }

    public Double getPointStrokeWidth(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeWidth();
    }

    public String getPointText(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getText();
    }

    public NonNegativeInteger getPointTheC(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheC();
    }

    public NonNegativeInteger getPointTheT(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheT();
    }

    public NonNegativeInteger getPointTheZ(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheZ();
    }

    public AffineTransform getPointTransform(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTransform();
    }

    public Boolean getPointVisible(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getVisible();
    }

    public Double getPointX(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getX();
    }

    public Double getPointY(int ROIIndex, int shapeIndex) {
        Point o = (Point)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getY();
    }

    public Color getPolygonFillColor(int ROIIndex, int shapeIndex) {
        Polygon o = (Polygon)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFillColor();
    }

    public FillRule getPolygonFillRule(int ROIIndex, int shapeIndex) {
        Polygon o = (Polygon)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFillRule();
    }

    public FontFamily getPolygonFontFamily(int ROIIndex, int shapeIndex) {
        Polygon o = (Polygon)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontFamily();
    }

    public NonNegativeInteger getPolygonFontSize(int ROIIndex, int shapeIndex) {
        Polygon o = (Polygon)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontSize();
    }

    public FontStyle getPolygonFontStyle(int ROIIndex, int shapeIndex) {
        Polygon o = (Polygon)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontStyle();
    }

    public String getPolygonID(int ROIIndex, int shapeIndex) {
        Polygon o = (Polygon)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getID();
    }

    public LineCap getPolygonLineCap(int ROIIndex, int shapeIndex) {
        Polygon o = (Polygon)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLineCap();
    }

    public Boolean getPolygonLocked(int ROIIndex, int shapeIndex) {
        Polygon o = (Polygon)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLocked();
    }

    public Color getPolygonStrokeColor(int ROIIndex, int shapeIndex) {
        Polygon o = (Polygon)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeColor();
    }

    public String getPolygonStrokeDashArray(int ROIIndex, int shapeIndex) {
        Polygon o = (Polygon)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeDashArray();
    }

    public Double getPolygonStrokeWidth(int ROIIndex, int shapeIndex) {
        Polygon o = (Polygon)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeWidth();
    }

    public String getPolygonText(int ROIIndex, int shapeIndex) {
        Polygon o = (Polygon)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getText();
    }

    public NonNegativeInteger getPolygonTheC(int ROIIndex, int shapeIndex) {
        Polygon o = (Polygon)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheC();
    }

    public NonNegativeInteger getPolygonTheT(int ROIIndex, int shapeIndex) {
        Polygon o = (Polygon)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheT();
    }

    public NonNegativeInteger getPolygonTheZ(int ROIIndex, int shapeIndex) {
        Polygon o = (Polygon)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheZ();
    }

    public AffineTransform getPolygonTransform(int ROIIndex, int shapeIndex) {
        Polygon o = (Polygon)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTransform();
    }

    public Boolean getPolygonVisible(int ROIIndex, int shapeIndex) {
        Polygon o = (Polygon)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getVisible();
    }

    public String getPolygonPoints(int ROIIndex, int shapeIndex) {
        Polygon o = (Polygon)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getPoints();
    }

    public Color getPolylineFillColor(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFillColor();
    }

    public FillRule getPolylineFillRule(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFillRule();
    }

    public FontFamily getPolylineFontFamily(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontFamily();
    }

    public NonNegativeInteger getPolylineFontSize(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontSize();
    }

    public FontStyle getPolylineFontStyle(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontStyle();
    }

    public String getPolylineID(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getID();
    }

    public LineCap getPolylineLineCap(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLineCap();
    }

    public Boolean getPolylineLocked(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLocked();
    }

    public Color getPolylineStrokeColor(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeColor();
    }

    public String getPolylineStrokeDashArray(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeDashArray();
    }

    public Double getPolylineStrokeWidth(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeWidth();
    }

    public String getPolylineText(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getText();
    }

    public NonNegativeInteger getPolylineTheC(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheC();
    }

    public NonNegativeInteger getPolylineTheT(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheT();
    }

    public NonNegativeInteger getPolylineTheZ(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheZ();
    }

    public AffineTransform getPolylineTransform(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTransform();
    }

    public Boolean getPolylineVisible(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getVisible();
    }

    public Marker getPolylineMarkerEnd(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getMarkerEnd();
    }

    public Marker getPolylineMarkerStart(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getMarkerStart();
    }

    public String getPolylinePoints(int ROIIndex, int shapeIndex) {
        Polyline o = (Polyline)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getPoints();
    }

    public String getProjectAnnotationRef(int projectIndex, int annotationRefIndex) {
        return this.root.getProject(projectIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public String getProjectDatasetRef(int projectIndex, int datasetRefIndex) {
        return this.root.getProject(projectIndex).getLinkedDataset(datasetRefIndex).getID();
    }

    public String getProjectDescription(int projectIndex) {
        return this.root.getProject(projectIndex).getDescription();
    }

    public String getProjectExperimenterGroupRef(int projectIndex) {
        return this.root.getProject(projectIndex).getLinkedExperimenterGroup().getID();
    }

    public String getProjectExperimenterRef(int projectIndex) {
        return this.root.getProject(projectIndex).getLinkedExperimenter().getID();
    }

    public String getProjectID(int projectIndex) {
        return this.root.getProject(projectIndex).getID();
    }

    public String getProjectName(int projectIndex) {
        return this.root.getProject(projectIndex).getName();
    }

    public String getROIAnnotationRef(int ROIIndex, int annotationRefIndex) {
        return this.root.getROI(ROIIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public String getROIDescription(int ROIIndex) {
        return this.root.getROI(ROIIndex).getDescription();
    }

    public String getROIID(int ROIIndex) {
        return this.root.getROI(ROIIndex).getID();
    }

    public String getROIName(int ROIIndex) {
        return this.root.getROI(ROIIndex).getName();
    }

    public String getROINamespace(int ROIIndex) {
        return this.root.getROI(ROIIndex).getNamespace();
    }

    public String getReagentAnnotationRef(int screenIndex, int reagentIndex, int annotationRefIndex) {
        return this.root.getScreen(screenIndex).getReagent(reagentIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public String getReagentDescription(int screenIndex, int reagentIndex) {
        return this.root.getScreen(screenIndex).getReagent(reagentIndex).getDescription();
    }

    public String getReagentID(int screenIndex, int reagentIndex) {
        return this.root.getScreen(screenIndex).getReagent(reagentIndex).getID();
    }

    public String getReagentName(int screenIndex, int reagentIndex) {
        return this.root.getScreen(screenIndex).getReagent(reagentIndex).getName();
    }

    public String getReagentReagentIdentifier(int screenIndex, int reagentIndex) {
        return this.root.getScreen(screenIndex).getReagent(reagentIndex).getReagentIdentifier();
    }

    public Color getRectangleFillColor(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFillColor();
    }

    public FillRule getRectangleFillRule(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFillRule();
    }

    public FontFamily getRectangleFontFamily(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontFamily();
    }

    public NonNegativeInteger getRectangleFontSize(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontSize();
    }

    public FontStyle getRectangleFontStyle(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getFontStyle();
    }

    public String getRectangleID(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getID();
    }

    public LineCap getRectangleLineCap(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLineCap();
    }

    public Boolean getRectangleLocked(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getLocked();
    }

    public Color getRectangleStrokeColor(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeColor();
    }

    public String getRectangleStrokeDashArray(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeDashArray();
    }

    public Double getRectangleStrokeWidth(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getStrokeWidth();
    }

    public String getRectangleText(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getText();
    }

    public NonNegativeInteger getRectangleTheC(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheC();
    }

    public NonNegativeInteger getRectangleTheT(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheT();
    }

    public NonNegativeInteger getRectangleTheZ(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTheZ();
    }

    public AffineTransform getRectangleTransform(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getTransform();
    }

    public Boolean getRectangleVisible(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getVisible();
    }

    public Double getRectangleHeight(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getHeight();
    }

    public Double getRectangleWidth(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getWidth();
    }

    public Double getRectangleX(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getX();
    }

    public Double getRectangleY(int ROIIndex, int shapeIndex) {
        Rectangle o = (Rectangle)this.root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
        return o.getY();
    }

    public String getScreenAnnotationRef(int screenIndex, int annotationRefIndex) {
        return this.root.getScreen(screenIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public String getScreenDescription(int screenIndex) {
        return this.root.getScreen(screenIndex).getDescription();
    }

    public String getScreenID(int screenIndex) {
        return this.root.getScreen(screenIndex).getID();
    }

    public String getScreenName(int screenIndex) {
        return this.root.getScreen(screenIndex).getName();
    }

    public String getScreenPlateRef(int screenIndex, int plateRefIndex) {
        return this.root.getScreen(screenIndex).getLinkedPlate(plateRefIndex).getID();
    }

    public String getScreenProtocolDescription(int screenIndex) {
        return this.root.getScreen(screenIndex).getProtocolDescription();
    }

    public String getScreenProtocolIdentifier(int screenIndex) {
        return this.root.getScreen(screenIndex).getProtocolIdentifier();
    }

    public String getScreenReagentSetDescription(int screenIndex) {
        return this.root.getScreen(screenIndex).getReagentSetDescription();
    }

    public String getScreenReagentSetIdentifier(int screenIndex) {
        return this.root.getScreen(screenIndex).getReagentSetIdentifier();
    }

    public String getScreenType(int screenIndex) {
        return this.root.getScreen(screenIndex).getType();
    }

    public String getStageLabelName(int imageIndex) {
        return this.root.getImage(imageIndex).getStageLabel().getName();
    }

    public Double getStageLabelX(int imageIndex) {
        return this.root.getImage(imageIndex).getStageLabel().getX();
    }

    public Double getStageLabelY(int imageIndex) {
        return this.root.getImage(imageIndex).getStageLabel().getY();
    }

    public Double getStageLabelZ(int imageIndex) {
        return this.root.getImage(imageIndex).getStageLabel().getZ();
    }

    public String getTagAnnotationAnnotationRef(int tagAnnotationIndex, int annotationRefIndex) {
        return this.root.getStructuredAnnotations().getTagAnnotation(tagAnnotationIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public String getTagAnnotationDescription(int tagAnnotationIndex) {
        return this.root.getStructuredAnnotations().getTagAnnotation(tagAnnotationIndex).getDescription();
    }

    public String getTagAnnotationID(int tagAnnotationIndex) {
        return this.root.getStructuredAnnotations().getTagAnnotation(tagAnnotationIndex).getID();
    }

    public String getTagAnnotationNamespace(int tagAnnotationIndex) {
        return this.root.getStructuredAnnotations().getTagAnnotation(tagAnnotationIndex).getNamespace();
    }

    public String getTagAnnotationValue(int tagAnnotationIndex) {
        return this.root.getStructuredAnnotations().getTagAnnotation(tagAnnotationIndex).getValue();
    }

    public String getTermAnnotationAnnotationRef(int termAnnotationIndex, int annotationRefIndex) {
        return this.root.getStructuredAnnotations().getTermAnnotation(termAnnotationIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public String getTermAnnotationDescription(int termAnnotationIndex) {
        return this.root.getStructuredAnnotations().getTermAnnotation(termAnnotationIndex).getDescription();
    }

    public String getTermAnnotationID(int termAnnotationIndex) {
        return this.root.getStructuredAnnotations().getTermAnnotation(termAnnotationIndex).getID();
    }

    public String getTermAnnotationNamespace(int termAnnotationIndex) {
        return this.root.getStructuredAnnotations().getTermAnnotation(termAnnotationIndex).getNamespace();
    }

    public String getTermAnnotationValue(int termAnnotationIndex) {
        return this.root.getStructuredAnnotations().getTermAnnotation(termAnnotationIndex).getValue();
    }

    public NonNegativeInteger getTiffDataFirstC(int imageIndex, int tiffDataIndex) {
        return this.root.getImage(imageIndex).getPixels().getTiffData(tiffDataIndex).getFirstC();
    }

    public NonNegativeInteger getTiffDataFirstT(int imageIndex, int tiffDataIndex) {
        return this.root.getImage(imageIndex).getPixels().getTiffData(tiffDataIndex).getFirstT();
    }

    public NonNegativeInteger getTiffDataFirstZ(int imageIndex, int tiffDataIndex) {
        return this.root.getImage(imageIndex).getPixels().getTiffData(tiffDataIndex).getFirstZ();
    }

    public NonNegativeInteger getTiffDataIFD(int imageIndex, int tiffDataIndex) {
        return this.root.getImage(imageIndex).getPixels().getTiffData(tiffDataIndex).getIFD();
    }

    public NonNegativeInteger getTiffDataPlaneCount(int imageIndex, int tiffDataIndex) {
        return this.root.getImage(imageIndex).getPixels().getTiffData(tiffDataIndex).getPlaneCount();
    }

    public String getTimestampAnnotationAnnotationRef(int timestampAnnotationIndex, int annotationRefIndex) {
        return this.root.getStructuredAnnotations().getTimestampAnnotation(timestampAnnotationIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public String getTimestampAnnotationDescription(int timestampAnnotationIndex) {
        return this.root.getStructuredAnnotations().getTimestampAnnotation(timestampAnnotationIndex).getDescription();
    }

    public String getTimestampAnnotationID(int timestampAnnotationIndex) {
        return this.root.getStructuredAnnotations().getTimestampAnnotation(timestampAnnotationIndex).getID();
    }

    public String getTimestampAnnotationNamespace(int timestampAnnotationIndex) {
        return this.root.getStructuredAnnotations().getTimestampAnnotation(timestampAnnotationIndex).getNamespace();
    }

    public Timestamp getTimestampAnnotationValue(int timestampAnnotationIndex) {
        return this.root.getStructuredAnnotations().getTimestampAnnotation(timestampAnnotationIndex).getValue();
    }

    public PositiveInteger getTransmittanceRangeCutIn(int instrumentIndex, int filterIndex) {
        return this.root.getInstrument(instrumentIndex).getFilter(filterIndex).getTransmittanceRange().getCutIn();
    }

    public NonNegativeInteger getTransmittanceRangeCutInTolerance(int instrumentIndex, int filterIndex) {
        return this.root.getInstrument(instrumentIndex).getFilter(filterIndex).getTransmittanceRange().getCutInTolerance();
    }

    public PositiveInteger getTransmittanceRangeCutOut(int instrumentIndex, int filterIndex) {
        return this.root.getInstrument(instrumentIndex).getFilter(filterIndex).getTransmittanceRange().getCutOut();
    }

    public NonNegativeInteger getTransmittanceRangeCutOutTolerance(int instrumentIndex, int filterIndex) {
        return this.root.getInstrument(instrumentIndex).getFilter(filterIndex).getTransmittanceRange().getCutOutTolerance();
    }

    public PercentFraction getTransmittanceRangeTransmittance(int instrumentIndex, int filterIndex) {
        return this.root.getInstrument(instrumentIndex).getFilter(filterIndex).getTransmittanceRange().getTransmittance();
    }

    public String getUUIDFileName(int imageIndex, int tiffDataIndex) {
        return this.root.getImage(imageIndex).getPixels().getTiffData(tiffDataIndex).getUUID().getFileName();
    }

    public String getWellAnnotationRef(int plateIndex, int wellIndex, int annotationRefIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public Color getWellColor(int plateIndex, int wellIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getColor();
    }

    public NonNegativeInteger getWellColumn(int plateIndex, int wellIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getColumn();
    }

    public String getWellExternalDescription(int plateIndex, int wellIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getExternalDescription();
    }

    public String getWellExternalIdentifier(int plateIndex, int wellIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getExternalIdentifier();
    }

    public String getWellID(int plateIndex, int wellIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getID();
    }

    public String getWellReagentRef(int plateIndex, int wellIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getLinkedReagent().getID();
    }

    public NonNegativeInteger getWellRow(int plateIndex, int wellIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getRow();
    }

    public String getWellType(int plateIndex, int wellIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getType();
    }

    public String getWellSampleAnnotationRef(int plateIndex, int wellIndex, int wellSampleIndex, int annotationRefIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getWellSample(wellSampleIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public String getWellSampleID(int plateIndex, int wellIndex, int wellSampleIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getWellSample(wellSampleIndex).getID();
    }

    public String getWellSampleImageRef(int plateIndex, int wellIndex, int wellSampleIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getWellSample(wellSampleIndex).getLinkedImage().getID();
    }

    public NonNegativeInteger getWellSampleIndex(int plateIndex, int wellIndex, int wellSampleIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getWellSample(wellSampleIndex).getIndex();
    }

    public Double getWellSamplePositionX(int plateIndex, int wellIndex, int wellSampleIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getWellSample(wellSampleIndex).getPositionX();
    }

    public Double getWellSamplePositionY(int plateIndex, int wellIndex, int wellSampleIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getWellSample(wellSampleIndex).getPositionY();
    }

    public Timestamp getWellSampleTimepoint(int plateIndex, int wellIndex, int wellSampleIndex) {
        return this.root.getPlate(plateIndex).getWell(wellIndex).getWellSample(wellSampleIndex).getTimepoint();
    }

    public String getXMLAnnotationAnnotationRef(int XMLAnnotationIndex, int annotationRefIndex) {
        return this.root.getStructuredAnnotations().getXMLAnnotation(XMLAnnotationIndex).getLinkedAnnotation(annotationRefIndex).getID();
    }

    public String getXMLAnnotationDescription(int XMLAnnotationIndex) {
        return this.root.getStructuredAnnotations().getXMLAnnotation(XMLAnnotationIndex).getDescription();
    }

    public String getXMLAnnotationID(int XMLAnnotationIndex) {
        return this.root.getStructuredAnnotations().getXMLAnnotation(XMLAnnotationIndex).getID();
    }

    public String getXMLAnnotationNamespace(int XMLAnnotationIndex) {
        return this.root.getStructuredAnnotations().getXMLAnnotation(XMLAnnotationIndex).getNamespace();
    }

    public String getXMLAnnotationValue(int XMLAnnotationIndex) {
        return this.root.getStructuredAnnotations().getXMLAnnotation(XMLAnnotationIndex).getValue();
    }

    public void setPixelsBinDataBigEndian(Boolean bigEndian, int imageIndex, int binDataIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfBinDataList() == binDataIndex) {
            o2.addBinData(new BinData());
        }
        BinData o3 = o2.getBinData(binDataIndex);
        o3.setBigEndian(bigEndian);
    }

    public void setMaskBinData(byte[] binData, int ROIIndex, int shapeIndex) {
    }

    public void setUUID(String uuid) {
        this.root.setUUID(uuid);
    }

    public void setArcID(String id, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Arc());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        this.model.addModelObject(id, o2);
        ((Arc)o2).setID(id);
    }

    public void setArcLotNumber(String lotNumber, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Arc());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Arc)o2).setLotNumber(lotNumber);
    }

    public void setArcManufacturer(String manufacturer, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Arc());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Arc)o2).setManufacturer(manufacturer);
    }

    public void setArcModel(String model, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Arc());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Arc)o2).setModel(model);
    }

    public void setArcPower(Double power, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Arc());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Arc)o2).setPower(power);
    }

    public void setArcSerialNumber(String serialNumber, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Arc());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Arc)o2).setSerialNumber(serialNumber);
    }

    public void setArcType(ArcType type, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Arc());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Arc)o2).setType(type);
    }

    public void setBinaryFileFileName(String fileName, int fileAnnotationIndex) {
        FileAnnotation o2;
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfFileAnnotationList() == fileAnnotationIndex) {
            o1.addFileAnnotation(new FileAnnotation());
        }
        if ((o2 = o1.getFileAnnotation(fileAnnotationIndex)).getBinaryFile() == null) {
            o2.setBinaryFile(new BinaryFile());
        }
        BinaryFile o3 = o2.getBinaryFile();
        o3.setFileName(fileName);
    }

    public void setBinaryFileMIMEType(String mimeType, int fileAnnotationIndex) {
        FileAnnotation o2;
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfFileAnnotationList() == fileAnnotationIndex) {
            o1.addFileAnnotation(new FileAnnotation());
        }
        if ((o2 = o1.getFileAnnotation(fileAnnotationIndex)).getBinaryFile() == null) {
            o2.setBinaryFile(new BinaryFile());
        }
        BinaryFile o3 = o2.getBinaryFile();
        o3.setMIMEType(mimeType);
    }

    public void setBinaryFileSize(NonNegativeLong size, int fileAnnotationIndex) {
        FileAnnotation o2;
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfFileAnnotationList() == fileAnnotationIndex) {
            o1.addFileAnnotation(new FileAnnotation());
        }
        if ((o2 = o1.getFileAnnotation(fileAnnotationIndex)).getBinaryFile() == null) {
            o2.setBinaryFile(new BinaryFile());
        }
        BinaryFile o3 = o2.getBinaryFile();
        o3.setSize(size);
    }

    public void setBinaryOnlyMetadataFile(String metadataFile) {
        OME o0 = this.root;
        if (o0.getBinaryOnly() == null) {
            o0.setBinaryOnly(new BinaryOnly());
        }
        BinaryOnly o1 = o0.getBinaryOnly();
        o1.setMetadataFile(metadataFile);
    }

    public void setBinaryOnlyUUID(String uuid) {
        OME o0 = this.root;
        if (o0.getBinaryOnly() == null) {
            o0.setBinaryOnly(new BinaryOnly());
        }
        BinaryOnly o1 = o0.getBinaryOnly();
        o1.setUUID(uuid);
    }

    public void setBooleanAnnotationAnnotationRef(String annotation, int booleanAnnotationIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getStructuredAnnotations().getBooleanAnnotation(booleanAnnotationIndex), annotationLinks_reference);
    }

    public void setBooleanAnnotationDescription(String description, int booleanAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfBooleanAnnotationList() == booleanAnnotationIndex) {
            o1.addBooleanAnnotation(new BooleanAnnotation());
        }
        BooleanAnnotation o2 = o1.getBooleanAnnotation(booleanAnnotationIndex);
        o2.setDescription(description);
    }

    public void setBooleanAnnotationID(String id, int booleanAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfBooleanAnnotationList() == booleanAnnotationIndex) {
            o1.addBooleanAnnotation(new BooleanAnnotation());
        }
        BooleanAnnotation o2 = o1.getBooleanAnnotation(booleanAnnotationIndex);
        this.model.addModelObject(id, o2);
        o2.setID(id);
    }

    public void setBooleanAnnotationNamespace(String namespace, int booleanAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfBooleanAnnotationList() == booleanAnnotationIndex) {
            o1.addBooleanAnnotation(new BooleanAnnotation());
        }
        BooleanAnnotation o2 = o1.getBooleanAnnotation(booleanAnnotationIndex);
        o2.setNamespace(namespace);
    }

    public void setBooleanAnnotationValue(Boolean value, int booleanAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfBooleanAnnotationList() == booleanAnnotationIndex) {
            o1.addBooleanAnnotation(new BooleanAnnotation());
        }
        BooleanAnnotation o2 = o1.getBooleanAnnotation(booleanAnnotationIndex);
        o2.setValue(value);
    }

    public void setChannelAcquisitionMode(AcquisitionMode acquisitionMode, int imageIndex, int channelIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        Channel o3 = o2.getChannel(channelIndex);
        o3.setAcquisitionMode(acquisitionMode);
    }

    public void setChannelAnnotationRef(String annotation, int imageIndex, int channelIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getImage(imageIndex).getPixels().getChannel(channelIndex), annotationLinks_reference);
    }

    public void setChannelColor(Color color, int imageIndex, int channelIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        Channel o3 = o2.getChannel(channelIndex);
        o3.setColor(color);
    }

    public void setChannelContrastMethod(ContrastMethod contrastMethod, int imageIndex, int channelIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        Channel o3 = o2.getChannel(channelIndex);
        o3.setContrastMethod(contrastMethod);
    }

    public void setChannelEmissionWavelength(PositiveInteger emissionWavelength, int imageIndex, int channelIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        Channel o3 = o2.getChannel(channelIndex);
        o3.setEmissionWavelength(emissionWavelength);
    }

    public void setChannelExcitationWavelength(PositiveInteger excitationWavelength, int imageIndex, int channelIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        Channel o3 = o2.getChannel(channelIndex);
        o3.setExcitationWavelength(excitationWavelength);
    }

    public void setChannelFilterSetRef(String filterSet, int imageIndex, int channelIndex) {
        FilterSetRef filterSet_reference = new FilterSetRef();
        filterSet_reference.setID(filterSet);
        this.model.addReference(this.root.getImage(imageIndex).getPixels().getChannel(channelIndex), filterSet_reference);
    }

    public void setChannelFluor(String fluor, int imageIndex, int channelIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        Channel o3 = o2.getChannel(channelIndex);
        o3.setFluor(fluor);
    }

    public void setChannelID(String id, int imageIndex, int channelIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        Channel o3 = o2.getChannel(channelIndex);
        this.model.addModelObject(id, o3);
        o3.setID(id);
        if (o3.getLightPath() == null) {
            o3.setLightPath(new LightPath());
        }
    }

    public void setChannelIlluminationType(IlluminationType illuminationType, int imageIndex, int channelIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        Channel o3 = o2.getChannel(channelIndex);
        o3.setIlluminationType(illuminationType);
    }

    public void setChannelNDFilter(Double ndFilter, int imageIndex, int channelIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        Channel o3 = o2.getChannel(channelIndex);
        o3.setNDFilter(ndFilter);
    }

    public void setChannelName(String name, int imageIndex, int channelIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        Channel o3 = o2.getChannel(channelIndex);
        o3.setName(name);
    }

    public void setChannelPinholeSize(Double pinholeSize, int imageIndex, int channelIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        Channel o3 = o2.getChannel(channelIndex);
        o3.setPinholeSize(pinholeSize);
    }

    public void setChannelPockelCellSetting(Integer pockelCellSetting, int imageIndex, int channelIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        Channel o3 = o2.getChannel(channelIndex);
        o3.setPockelCellSetting(pockelCellSetting);
    }

    public void setChannelSamplesPerPixel(PositiveInteger samplesPerPixel, int imageIndex, int channelIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        Channel o3 = o2.getChannel(channelIndex);
        o3.setSamplesPerPixel(samplesPerPixel);
    }

    public void setCommentAnnotationAnnotationRef(String annotation, int commentAnnotationIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getStructuredAnnotations().getCommentAnnotation(commentAnnotationIndex), annotationLinks_reference);
    }

    public void setCommentAnnotationDescription(String description, int commentAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfCommentAnnotationList() == commentAnnotationIndex) {
            o1.addCommentAnnotation(new CommentAnnotation());
        }
        CommentAnnotation o2 = o1.getCommentAnnotation(commentAnnotationIndex);
        o2.setDescription(description);
    }

    public void setCommentAnnotationID(String id, int commentAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfCommentAnnotationList() == commentAnnotationIndex) {
            o1.addCommentAnnotation(new CommentAnnotation());
        }
        CommentAnnotation o2 = o1.getCommentAnnotation(commentAnnotationIndex);
        this.model.addModelObject(id, o2);
        o2.setID(id);
    }

    public void setCommentAnnotationNamespace(String namespace, int commentAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfCommentAnnotationList() == commentAnnotationIndex) {
            o1.addCommentAnnotation(new CommentAnnotation());
        }
        CommentAnnotation o2 = o1.getCommentAnnotation(commentAnnotationIndex);
        o2.setNamespace(namespace);
    }

    public void setCommentAnnotationValue(String value, int commentAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfCommentAnnotationList() == commentAnnotationIndex) {
            o1.addCommentAnnotation(new CommentAnnotation());
        }
        CommentAnnotation o2 = o1.getCommentAnnotation(commentAnnotationIndex);
        o2.setValue(value);
    }

    public void setDatasetAnnotationRef(String annotation, int datasetIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getDataset(datasetIndex), annotationLinks_reference);
    }

    public void setDatasetDescription(String description, int datasetIndex) {
        OME o0 = this.root;
        if (o0.sizeOfDatasetList() == datasetIndex) {
            o0.addDataset(new Dataset());
        }
        Dataset o1 = o0.getDataset(datasetIndex);
        o1.setDescription(description);
    }

    public void setDatasetExperimenterGroupRef(String experimenterGroup, int datasetIndex) {
        ExperimenterGroupRef experimenterGroup_reference = new ExperimenterGroupRef();
        experimenterGroup_reference.setID(experimenterGroup);
        this.model.addReference(this.root.getDataset(datasetIndex), experimenterGroup_reference);
    }

    public void setDatasetExperimenterRef(String experimenter, int datasetIndex) {
        ExperimenterRef experimenter_reference = new ExperimenterRef();
        experimenter_reference.setID(experimenter);
        this.model.addReference(this.root.getDataset(datasetIndex), experimenter_reference);
    }

    public void setDatasetID(String id, int datasetIndex) {
        OME o0 = this.root;
        if (o0.sizeOfDatasetList() == datasetIndex) {
            o0.addDataset(new Dataset());
        }
        Dataset o1 = o0.getDataset(datasetIndex);
        this.model.addModelObject(id, o1);
        o1.setID(id);
    }

    public void setDatasetImageRef(String image, int datasetIndex, int imageRefIndex) {
        ImageRef imageLinks_reference = new ImageRef();
        imageLinks_reference.setID(image);
        this.model.addReference(this.root.getDataset(datasetIndex), imageLinks_reference);
    }

    public void setDatasetName(String name, int datasetIndex) {
        OME o0 = this.root;
        if (o0.sizeOfDatasetList() == datasetIndex) {
            o0.addDataset(new Dataset());
        }
        Dataset o1 = o0.getDataset(datasetIndex);
        o1.setName(name);
    }

    public void setDetectorAmplificationGain(Double amplificationGain, int instrumentIndex, int detectorIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDetectorList() == detectorIndex) {
            o1.addDetector(new Detector());
        }
        Detector o2 = o1.getDetector(detectorIndex);
        o2.setAmplificationGain(amplificationGain);
    }

    public void setDetectorGain(Double gain, int instrumentIndex, int detectorIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDetectorList() == detectorIndex) {
            o1.addDetector(new Detector());
        }
        Detector o2 = o1.getDetector(detectorIndex);
        o2.setGain(gain);
    }

    public void setDetectorID(String id, int instrumentIndex, int detectorIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDetectorList() == detectorIndex) {
            o1.addDetector(new Detector());
        }
        Detector o2 = o1.getDetector(detectorIndex);
        this.model.addModelObject(id, o2);
        o2.setID(id);
    }

    public void setDetectorLotNumber(String lotNumber, int instrumentIndex, int detectorIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDetectorList() == detectorIndex) {
            o1.addDetector(new Detector());
        }
        Detector o2 = o1.getDetector(detectorIndex);
        o2.setLotNumber(lotNumber);
    }

    public void setDetectorManufacturer(String manufacturer, int instrumentIndex, int detectorIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDetectorList() == detectorIndex) {
            o1.addDetector(new Detector());
        }
        Detector o2 = o1.getDetector(detectorIndex);
        o2.setManufacturer(manufacturer);
    }

    public void setDetectorModel(String model, int instrumentIndex, int detectorIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDetectorList() == detectorIndex) {
            o1.addDetector(new Detector());
        }
        Detector o2 = o1.getDetector(detectorIndex);
        o2.setModel(model);
    }

    public void setDetectorOffset(Double offset, int instrumentIndex, int detectorIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDetectorList() == detectorIndex) {
            o1.addDetector(new Detector());
        }
        Detector o2 = o1.getDetector(detectorIndex);
        o2.setOffset(offset);
    }

    public void setDetectorSerialNumber(String serialNumber, int instrumentIndex, int detectorIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDetectorList() == detectorIndex) {
            o1.addDetector(new Detector());
        }
        Detector o2 = o1.getDetector(detectorIndex);
        o2.setSerialNumber(serialNumber);
    }

    public void setDetectorType(DetectorType type, int instrumentIndex, int detectorIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDetectorList() == detectorIndex) {
            o1.addDetector(new Detector());
        }
        Detector o2 = o1.getDetector(detectorIndex);
        o2.setType(type);
    }

    public void setDetectorVoltage(Double voltage, int instrumentIndex, int detectorIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDetectorList() == detectorIndex) {
            o1.addDetector(new Detector());
        }
        Detector o2 = o1.getDetector(detectorIndex);
        o2.setVoltage(voltage);
    }

    public void setDetectorZoom(Double zoom, int instrumentIndex, int detectorIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDetectorList() == detectorIndex) {
            o1.addDetector(new Detector());
        }
        Detector o2 = o1.getDetector(detectorIndex);
        o2.setZoom(zoom);
    }

    public void setDetectorSettingsBinning(Binning binning, int imageIndex, int channelIndex) {
        Channel o3;
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        if ((o3 = o2.getChannel(channelIndex)).getDetectorSettings() == null) {
            o3.setDetectorSettings(new DetectorSettings());
        }
        DetectorSettings o4 = o3.getDetectorSettings();
        o4.setBinning(binning);
    }

    public void setDetectorSettingsGain(Double gain, int imageIndex, int channelIndex) {
        Channel o3;
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        if ((o3 = o2.getChannel(channelIndex)).getDetectorSettings() == null) {
            o3.setDetectorSettings(new DetectorSettings());
        }
        DetectorSettings o4 = o3.getDetectorSettings();
        o4.setGain(gain);
    }

    public void setDetectorSettingsID(String id, int imageIndex, int channelIndex) {
        Channel o3;
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        if ((o3 = o2.getChannel(channelIndex)).getDetectorSettings() == null) {
            o3.setDetectorSettings(new DetectorSettings());
        }
        DetectorSettings o4 = o3.getDetectorSettings();
        this.model.addModelObject(id, o4);
        o4.setID(id);
    }

    public void setDetectorSettingsOffset(Double offset, int imageIndex, int channelIndex) {
        Channel o3;
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        if ((o3 = o2.getChannel(channelIndex)).getDetectorSettings() == null) {
            o3.setDetectorSettings(new DetectorSettings());
        }
        DetectorSettings o4 = o3.getDetectorSettings();
        o4.setOffset(offset);
    }

    public void setDetectorSettingsReadOutRate(Double readOutRate, int imageIndex, int channelIndex) {
        Channel o3;
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        if ((o3 = o2.getChannel(channelIndex)).getDetectorSettings() == null) {
            o3.setDetectorSettings(new DetectorSettings());
        }
        DetectorSettings o4 = o3.getDetectorSettings();
        o4.setReadOutRate(readOutRate);
    }

    public void setDetectorSettingsVoltage(Double voltage, int imageIndex, int channelIndex) {
        Channel o3;
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        if ((o3 = o2.getChannel(channelIndex)).getDetectorSettings() == null) {
            o3.setDetectorSettings(new DetectorSettings());
        }
        DetectorSettings o4 = o3.getDetectorSettings();
        o4.setVoltage(voltage);
    }

    public void setDichroicID(String id, int instrumentIndex, int dichroicIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDichroicList() == dichroicIndex) {
            o1.addDichroic(new Dichroic());
        }
        Dichroic o2 = o1.getDichroic(dichroicIndex);
        this.model.addModelObject(id, o2);
        o2.setID(id);
    }

    public void setDichroicLotNumber(String lotNumber, int instrumentIndex, int dichroicIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDichroicList() == dichroicIndex) {
            o1.addDichroic(new Dichroic());
        }
        Dichroic o2 = o1.getDichroic(dichroicIndex);
        o2.setLotNumber(lotNumber);
    }

    public void setDichroicManufacturer(String manufacturer, int instrumentIndex, int dichroicIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDichroicList() == dichroicIndex) {
            o1.addDichroic(new Dichroic());
        }
        Dichroic o2 = o1.getDichroic(dichroicIndex);
        o2.setManufacturer(manufacturer);
    }

    public void setDichroicModel(String model, int instrumentIndex, int dichroicIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDichroicList() == dichroicIndex) {
            o1.addDichroic(new Dichroic());
        }
        Dichroic o2 = o1.getDichroic(dichroicIndex);
        o2.setModel(model);
    }

    public void setDichroicSerialNumber(String serialNumber, int instrumentIndex, int dichroicIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfDichroicList() == dichroicIndex) {
            o1.addDichroic(new Dichroic());
        }
        Dichroic o2 = o1.getDichroic(dichroicIndex);
        o2.setSerialNumber(serialNumber);
    }

    public void setDoubleAnnotationAnnotationRef(String annotation, int doubleAnnotationIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getStructuredAnnotations().getDoubleAnnotation(doubleAnnotationIndex), annotationLinks_reference);
    }

    public void setDoubleAnnotationDescription(String description, int doubleAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfDoubleAnnotationList() == doubleAnnotationIndex) {
            o1.addDoubleAnnotation(new DoubleAnnotation());
        }
        DoubleAnnotation o2 = o1.getDoubleAnnotation(doubleAnnotationIndex);
        o2.setDescription(description);
    }

    public void setDoubleAnnotationID(String id, int doubleAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfDoubleAnnotationList() == doubleAnnotationIndex) {
            o1.addDoubleAnnotation(new DoubleAnnotation());
        }
        DoubleAnnotation o2 = o1.getDoubleAnnotation(doubleAnnotationIndex);
        this.model.addModelObject(id, o2);
        o2.setID(id);
    }

    public void setDoubleAnnotationNamespace(String namespace, int doubleAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfDoubleAnnotationList() == doubleAnnotationIndex) {
            o1.addDoubleAnnotation(new DoubleAnnotation());
        }
        DoubleAnnotation o2 = o1.getDoubleAnnotation(doubleAnnotationIndex);
        o2.setNamespace(namespace);
    }

    public void setDoubleAnnotationValue(Double value, int doubleAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfDoubleAnnotationList() == doubleAnnotationIndex) {
            o1.addDoubleAnnotation(new DoubleAnnotation());
        }
        DoubleAnnotation o2 = o1.getDoubleAnnotation(doubleAnnotationIndex);
        o2.setValue(value);
    }

    public void setEllipseFillColor(Color fillColor, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setFillColor(fillColor);
    }

    public void setEllipseFillRule(FillRule fillRule, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setFillRule(fillRule);
    }

    public void setEllipseFontFamily(FontFamily fontFamily, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setFontFamily(fontFamily);
    }

    public void setEllipseFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setFontSize(fontSize);
    }

    public void setEllipseFontStyle(FontStyle fontStyle, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setFontStyle(fontStyle);
    }

    public void setEllipseID(String id, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        this.model.addModelObject(id, o3);
        ((Ellipse)o3).setID(id);
    }

    public void setEllipseLineCap(LineCap lineCap, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setLineCap(lineCap);
    }

    public void setEllipseLocked(Boolean locked, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setLocked(locked);
    }

    public void setEllipseStrokeColor(Color strokeColor, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setStrokeColor(strokeColor);
    }

    public void setEllipseStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setStrokeDashArray(strokeDashArray);
    }

    public void setEllipseStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setStrokeWidth(strokeWidth);
    }

    public void setEllipseText(String text, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setText(text);
    }

    public void setEllipseTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setTheC(theC);
    }

    public void setEllipseTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setTheT(theT);
    }

    public void setEllipseTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setTheZ(theZ);
    }

    public void setEllipseTransform(AffineTransform transform, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setTransform(transform);
    }

    public void setEllipseVisible(Boolean visible, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setVisible(visible);
    }

    public void setEllipseRadiusX(Double radiusX, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setRadiusX(radiusX);
    }

    public void setEllipseRadiusY(Double radiusY, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setRadiusY(radiusY);
    }

    public void setEllipseX(Double x, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setX(x);
    }

    public void setEllipseY(Double y, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Ellipse());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Ellipse)o3).setY(y);
    }

    public void setExperimentDescription(String description, int experimentIndex) {
        OME o0 = this.root;
        if (o0.sizeOfExperimentList() == experimentIndex) {
            o0.addExperiment(new Experiment());
        }
        Experiment o1 = o0.getExperiment(experimentIndex);
        o1.setDescription(description);
    }

    public void setExperimentExperimenterRef(String experimenter, int experimentIndex) {
        ExperimenterRef experimenter_reference = new ExperimenterRef();
        experimenter_reference.setID(experimenter);
        this.model.addReference(this.root.getExperiment(experimentIndex), experimenter_reference);
    }

    public void setExperimentID(String id, int experimentIndex) {
        OME o0 = this.root;
        if (o0.sizeOfExperimentList() == experimentIndex) {
            o0.addExperiment(new Experiment());
        }
        Experiment o1 = o0.getExperiment(experimentIndex);
        this.model.addModelObject(id, o1);
        o1.setID(id);
    }

    public void setExperimentType(ExperimentType type, int experimentIndex) {
        OME o0 = this.root;
        if (o0.sizeOfExperimentList() == experimentIndex) {
            o0.addExperiment(new Experiment());
        }
        Experiment o1 = o0.getExperiment(experimentIndex);
        o1.setType(type);
    }

    public void setExperimenterAnnotationRef(String annotation, int experimenterIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getExperimenter(experimenterIndex), annotationLinks_reference);
    }

    public void setExperimenterEmail(String email, int experimenterIndex) {
        OME o0 = this.root;
        if (o0.sizeOfExperimenterList() == experimenterIndex) {
            o0.addExperimenter(new Experimenter());
        }
        Experimenter o1 = o0.getExperimenter(experimenterIndex);
        o1.setEmail(email);
    }

    public void setExperimenterFirstName(String firstName, int experimenterIndex) {
        OME o0 = this.root;
        if (o0.sizeOfExperimenterList() == experimenterIndex) {
            o0.addExperimenter(new Experimenter());
        }
        Experimenter o1 = o0.getExperimenter(experimenterIndex);
        o1.setFirstName(firstName);
    }

    public void setExperimenterID(String id, int experimenterIndex) {
        OME o0 = this.root;
        if (o0.sizeOfExperimenterList() == experimenterIndex) {
            o0.addExperimenter(new Experimenter());
        }
        Experimenter o1 = o0.getExperimenter(experimenterIndex);
        this.model.addModelObject(id, o1);
        o1.setID(id);
    }

    public void setExperimenterInstitution(String institution, int experimenterIndex) {
        OME o0 = this.root;
        if (o0.sizeOfExperimenterList() == experimenterIndex) {
            o0.addExperimenter(new Experimenter());
        }
        Experimenter o1 = o0.getExperimenter(experimenterIndex);
        o1.setInstitution(institution);
    }

    public void setExperimenterLastName(String lastName, int experimenterIndex) {
        OME o0 = this.root;
        if (o0.sizeOfExperimenterList() == experimenterIndex) {
            o0.addExperimenter(new Experimenter());
        }
        Experimenter o1 = o0.getExperimenter(experimenterIndex);
        o1.setLastName(lastName);
    }

    public void setExperimenterMiddleName(String middleName, int experimenterIndex) {
        OME o0 = this.root;
        if (o0.sizeOfExperimenterList() == experimenterIndex) {
            o0.addExperimenter(new Experimenter());
        }
        Experimenter o1 = o0.getExperimenter(experimenterIndex);
        o1.setMiddleName(middleName);
    }

    public void setExperimenterUserName(String userName, int experimenterIndex) {
        OME o0 = this.root;
        if (o0.sizeOfExperimenterList() == experimenterIndex) {
            o0.addExperimenter(new Experimenter());
        }
        Experimenter o1 = o0.getExperimenter(experimenterIndex);
        o1.setUserName(userName);
    }

    public void setExperimenterGroupAnnotationRef(String annotation, int experimenterGroupIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getExperimenterGroup(experimenterGroupIndex), annotationLinks_reference);
    }

    public void setExperimenterGroupDescription(String description, int experimenterGroupIndex) {
        OME o0 = this.root;
        if (o0.sizeOfExperimenterGroupList() == experimenterGroupIndex) {
            o0.addExperimenterGroup(new ExperimenterGroup());
        }
        ExperimenterGroup o1 = o0.getExperimenterGroup(experimenterGroupIndex);
        o1.setDescription(description);
    }

    public void setExperimenterGroupExperimenterRef(String experimenter, int experimenterGroupIndex, int experimenterRefIndex) {
        ExperimenterRef experimenterLinks_reference = new ExperimenterRef();
        experimenterLinks_reference.setID(experimenter);
        this.model.addReference(this.root.getExperimenterGroup(experimenterGroupIndex), experimenterLinks_reference);
    }

    public void setExperimenterGroupID(String id, int experimenterGroupIndex) {
        OME o0 = this.root;
        if (o0.sizeOfExperimenterGroupList() == experimenterGroupIndex) {
            o0.addExperimenterGroup(new ExperimenterGroup());
        }
        ExperimenterGroup o1 = o0.getExperimenterGroup(experimenterGroupIndex);
        this.model.addModelObject(id, o1);
        o1.setID(id);
    }

    public void setExperimenterGroupLeader(String leader, int experimenterGroupIndex, int leaderIndex) {
        Leader leaders_reference = new Leader();
        leaders_reference.setID(leader);
        this.model.addReference(this.root.getExperimenterGroup(experimenterGroupIndex), leaders_reference);
    }

    public void setExperimenterGroupName(String name, int experimenterGroupIndex) {
        OME o0 = this.root;
        if (o0.sizeOfExperimenterGroupList() == experimenterGroupIndex) {
            o0.addExperimenterGroup(new ExperimenterGroup());
        }
        ExperimenterGroup o1 = o0.getExperimenterGroup(experimenterGroupIndex);
        o1.setName(name);
    }

    public void setFilamentID(String id, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Filament());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        this.model.addModelObject(id, o2);
        ((Filament)o2).setID(id);
    }

    public void setFilamentLotNumber(String lotNumber, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Filament());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Filament)o2).setLotNumber(lotNumber);
    }

    public void setFilamentManufacturer(String manufacturer, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Filament());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Filament)o2).setManufacturer(manufacturer);
    }

    public void setFilamentModel(String model, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Filament());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Filament)o2).setModel(model);
    }

    public void setFilamentPower(Double power, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Filament());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Filament)o2).setPower(power);
    }

    public void setFilamentSerialNumber(String serialNumber, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Filament());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Filament)o2).setSerialNumber(serialNumber);
    }

    public void setFilamentType(FilamentType type, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Filament());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Filament)o2).setType(type);
    }

    public void setFileAnnotationAnnotationRef(String annotation, int fileAnnotationIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getStructuredAnnotations().getFileAnnotation(fileAnnotationIndex), annotationLinks_reference);
    }

    public void setFileAnnotationDescription(String description, int fileAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfFileAnnotationList() == fileAnnotationIndex) {
            o1.addFileAnnotation(new FileAnnotation());
        }
        FileAnnotation o2 = o1.getFileAnnotation(fileAnnotationIndex);
        o2.setDescription(description);
    }

    public void setFileAnnotationID(String id, int fileAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfFileAnnotationList() == fileAnnotationIndex) {
            o1.addFileAnnotation(new FileAnnotation());
        }
        FileAnnotation o2 = o1.getFileAnnotation(fileAnnotationIndex);
        this.model.addModelObject(id, o2);
        o2.setID(id);
    }

    public void setFileAnnotationNamespace(String namespace, int fileAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfFileAnnotationList() == fileAnnotationIndex) {
            o1.addFileAnnotation(new FileAnnotation());
        }
        FileAnnotation o2 = o1.getFileAnnotation(fileAnnotationIndex);
        o2.setNamespace(namespace);
    }

    public void setFilterFilterWheel(String filterWheel, int instrumentIndex, int filterIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterList() == filterIndex) {
            o1.addFilter(new Filter());
        }
        Filter o2 = o1.getFilter(filterIndex);
        o2.setFilterWheel(filterWheel);
    }

    public void setFilterID(String id, int instrumentIndex, int filterIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterList() == filterIndex) {
            o1.addFilter(new Filter());
        }
        Filter o2 = o1.getFilter(filterIndex);
        this.model.addModelObject(id, o2);
        o2.setID(id);
    }

    public void setFilterLotNumber(String lotNumber, int instrumentIndex, int filterIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterList() == filterIndex) {
            o1.addFilter(new Filter());
        }
        Filter o2 = o1.getFilter(filterIndex);
        o2.setLotNumber(lotNumber);
    }

    public void setFilterManufacturer(String manufacturer, int instrumentIndex, int filterIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterList() == filterIndex) {
            o1.addFilter(new Filter());
        }
        Filter o2 = o1.getFilter(filterIndex);
        o2.setManufacturer(manufacturer);
    }

    public void setFilterModel(String model, int instrumentIndex, int filterIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterList() == filterIndex) {
            o1.addFilter(new Filter());
        }
        Filter o2 = o1.getFilter(filterIndex);
        o2.setModel(model);
    }

    public void setFilterSerialNumber(String serialNumber, int instrumentIndex, int filterIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterList() == filterIndex) {
            o1.addFilter(new Filter());
        }
        Filter o2 = o1.getFilter(filterIndex);
        o2.setSerialNumber(serialNumber);
    }

    public void setFilterType(FilterType type, int instrumentIndex, int filterIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterList() == filterIndex) {
            o1.addFilter(new Filter());
        }
        Filter o2 = o1.getFilter(filterIndex);
        o2.setType(type);
    }

    public void setFilterSetDichroicRef(String dichroic, int instrumentIndex, int filterSetIndex) {
        DichroicRef dichroic_reference = new DichroicRef();
        dichroic_reference.setID(dichroic);
        this.model.addReference(this.root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex), dichroic_reference);
    }

    public void setFilterSetEmissionFilterRef(String emissionFilter, int instrumentIndex, int filterSetIndex, int emissionFilterRefIndex) {
        EmissionFilterRef emissionFilterLinks_reference = new EmissionFilterRef();
        emissionFilterLinks_reference.setID(emissionFilter);
        this.model.addReference(this.root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex), emissionFilterLinks_reference);
    }

    public void setFilterSetExcitationFilterRef(String excitationFilter, int instrumentIndex, int filterSetIndex, int excitationFilterRefIndex) {
        ExcitationFilterRef excitationFilterLinks_reference = new ExcitationFilterRef();
        excitationFilterLinks_reference.setID(excitationFilter);
        this.model.addReference(this.root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex), excitationFilterLinks_reference);
    }

    public void setFilterSetID(String id, int instrumentIndex, int filterSetIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterSetList() == filterSetIndex) {
            o1.addFilterSet(new FilterSet());
        }
        FilterSet o2 = o1.getFilterSet(filterSetIndex);
        this.model.addModelObject(id, o2);
        o2.setID(id);
    }

    public void setFilterSetLotNumber(String lotNumber, int instrumentIndex, int filterSetIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterSetList() == filterSetIndex) {
            o1.addFilterSet(new FilterSet());
        }
        FilterSet o2 = o1.getFilterSet(filterSetIndex);
        o2.setLotNumber(lotNumber);
    }

    public void setFilterSetManufacturer(String manufacturer, int instrumentIndex, int filterSetIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterSetList() == filterSetIndex) {
            o1.addFilterSet(new FilterSet());
        }
        FilterSet o2 = o1.getFilterSet(filterSetIndex);
        o2.setManufacturer(manufacturer);
    }

    public void setFilterSetModel(String model, int instrumentIndex, int filterSetIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterSetList() == filterSetIndex) {
            o1.addFilterSet(new FilterSet());
        }
        FilterSet o2 = o1.getFilterSet(filterSetIndex);
        o2.setModel(model);
    }

    public void setFilterSetSerialNumber(String serialNumber, int instrumentIndex, int filterSetIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterSetList() == filterSetIndex) {
            o1.addFilterSet(new FilterSet());
        }
        FilterSet o2 = o1.getFilterSet(filterSetIndex);
        o2.setSerialNumber(serialNumber);
    }

    public void setImageAcquisitionDate(Timestamp acquisitionDate, int imageIndex) {
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        Image o1 = o0.getImage(imageIndex);
        o1.setAcquisitionDate(acquisitionDate);
    }

    public void setImageAnnotationRef(String annotation, int imageIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getImage(imageIndex), annotationLinks_reference);
    }

    public void setImageDescription(String description, int imageIndex) {
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        Image o1 = o0.getImage(imageIndex);
        o1.setDescription(description);
    }

    public void setImageExperimentRef(String experiment, int imageIndex) {
        ExperimentRef experiment_reference = new ExperimentRef();
        experiment_reference.setID(experiment);
        this.model.addReference(this.root.getImage(imageIndex), experiment_reference);
    }

    public void setImageExperimenterGroupRef(String experimenterGroup, int imageIndex) {
        ExperimenterGroupRef experimenterGroup_reference = new ExperimenterGroupRef();
        experimenterGroup_reference.setID(experimenterGroup);
        this.model.addReference(this.root.getImage(imageIndex), experimenterGroup_reference);
    }

    public void setImageExperimenterRef(String experimenter, int imageIndex) {
        ExperimenterRef experimenter_reference = new ExperimenterRef();
        experimenter_reference.setID(experimenter);
        this.model.addReference(this.root.getImage(imageIndex), experimenter_reference);
    }

    public void setImageID(String id, int imageIndex) {
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        Image o1 = o0.getImage(imageIndex);
        this.model.addModelObject(id, o1);
        o1.setID(id);
    }

    public void setImageInstrumentRef(String instrument, int imageIndex) {
        InstrumentRef instrument_reference = new InstrumentRef();
        instrument_reference.setID(instrument);
        this.model.addReference(this.root.getImage(imageIndex), instrument_reference);
    }

    public void setImageMicrobeamManipulationRef(String microbeamManipulation, int imageIndex, int microbeamManipulationRefIndex) {
        MicrobeamManipulationRef microbeamManipulationLinks_reference = new MicrobeamManipulationRef();
        microbeamManipulationLinks_reference.setID(microbeamManipulation);
        this.model.addReference(this.root.getImage(imageIndex), microbeamManipulationLinks_reference);
    }

    public void setImageName(String name, int imageIndex) {
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        Image o1 = o0.getImage(imageIndex);
        o1.setName(name);
    }

    public void setImageROIRef(String roi, int imageIndex, int ROIRefIndex) {
        ROIRef roiLinks_reference = new ROIRef();
        roiLinks_reference.setID(roi);
        this.model.addReference(this.root.getImage(imageIndex), roiLinks_reference);
    }

    public void setImagingEnvironmentAirPressure(Double airPressure, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getImagingEnvironment() == null) {
            o1.setImagingEnvironment(new ImagingEnvironment());
        }
        ImagingEnvironment o2 = o1.getImagingEnvironment();
        o2.setAirPressure(airPressure);
    }

    public void setImagingEnvironmentCO2Percent(PercentFraction co2Percent, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getImagingEnvironment() == null) {
            o1.setImagingEnvironment(new ImagingEnvironment());
        }
        ImagingEnvironment o2 = o1.getImagingEnvironment();
        o2.setCO2Percent(co2Percent);
    }

    public void setImagingEnvironmentHumidity(PercentFraction humidity, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getImagingEnvironment() == null) {
            o1.setImagingEnvironment(new ImagingEnvironment());
        }
        ImagingEnvironment o2 = o1.getImagingEnvironment();
        o2.setHumidity(humidity);
    }

    public void setImagingEnvironmentTemperature(Double temperature, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getImagingEnvironment() == null) {
            o1.setImagingEnvironment(new ImagingEnvironment());
        }
        ImagingEnvironment o2 = o1.getImagingEnvironment();
        o2.setTemperature(temperature);
    }

    public void setInstrumentID(String id, int instrumentIndex) {
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        Instrument o1 = o0.getInstrument(instrumentIndex);
        this.model.addModelObject(id, o1);
        o1.setID(id);
    }

    public void setLabelFillColor(Color fillColor, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Label());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Label)o3).setFillColor(fillColor);
    }

    public void setLabelFillRule(FillRule fillRule, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Label());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Label)o3).setFillRule(fillRule);
    }

    public void setLabelFontFamily(FontFamily fontFamily, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Label());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Label)o3).setFontFamily(fontFamily);
    }

    public void setLabelFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Label());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Label)o3).setFontSize(fontSize);
    }

    public void setLabelFontStyle(FontStyle fontStyle, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Label());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Label)o3).setFontStyle(fontStyle);
    }

    public void setLabelID(String id, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Label());
        }
        Shape o3 = o2.getShape(shapeIndex);
        this.model.addModelObject(id, o3);
        ((Label)o3).setID(id);
    }

    public void setLabelLineCap(LineCap lineCap, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Label());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Label)o3).setLineCap(lineCap);
    }

    public void setLabelLocked(Boolean locked, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Label());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Label)o3).setLocked(locked);
    }

    public void setLabelStrokeColor(Color strokeColor, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Label());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Label)o3).setStrokeColor(strokeColor);
    }

    public void setLabelStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Label());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Label)o3).setStrokeDashArray(strokeDashArray);
    }

    public void setLabelStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Label());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Label)o3).setStrokeWidth(strokeWidth);
    }

    public void setLabelText(String text, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Label());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Label)o3).setText(text);
    }

    public void setLabelTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Label());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Label)o3).setTheC(theC);
    }

    public void setLabelTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Label());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Label)o3).setTheT(theT);
    }

    public void setLabelTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Label());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Label)o3).setTheZ(theZ);
    }

    public void setLabelTransform(AffineTransform transform, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Label());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Label)o3).setTransform(transform);
    }

    public void setLabelVisible(Boolean visible, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Label());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Label)o3).setVisible(visible);
    }

    public void setLabelX(Double x, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Label());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Label)o3).setX(x);
    }

    public void setLabelY(Double y, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Label());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Label)o3).setY(y);
    }

    public void setLaserID(String id, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Laser());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        this.model.addModelObject(id, o2);
        ((Laser)o2).setID(id);
    }

    public void setLaserLotNumber(String lotNumber, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Laser());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Laser)o2).setLotNumber(lotNumber);
    }

    public void setLaserManufacturer(String manufacturer, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Laser());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Laser)o2).setManufacturer(manufacturer);
    }

    public void setLaserModel(String model, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Laser());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Laser)o2).setModel(model);
    }

    public void setLaserPower(Double power, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Laser());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Laser)o2).setPower(power);
    }

    public void setLaserSerialNumber(String serialNumber, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Laser());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Laser)o2).setSerialNumber(serialNumber);
    }

    public void setLaserFrequencyMultiplication(PositiveInteger frequencyMultiplication, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Laser());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Laser)o2).setFrequencyMultiplication(frequencyMultiplication);
    }

    public void setLaserLaserMedium(LaserMedium laserMedium, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Laser());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Laser)o2).setLaserMedium(laserMedium);
    }

    public void setLaserPockelCell(Boolean pockelCell, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Laser());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Laser)o2).setPockelCell(pockelCell);
    }

    public void setLaserPulse(Pulse pulse, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Laser());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Laser)o2).setPulse(pulse);
    }

    public void setLaserPump(String pump, int instrumentIndex, int lightSourceIndex) {
        Pump pump_reference = new Pump();
        pump_reference.setID(pump);
        this.model.addReference(this.root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex), pump_reference);
    }

    public void setLaserRepetitionRate(Double repetitionRate, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Laser());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Laser)o2).setRepetitionRate(repetitionRate);
    }

    public void setLaserTuneable(Boolean tuneable, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Laser());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Laser)o2).setTuneable(tuneable);
    }

    public void setLaserType(LaserType type, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Laser());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Laser)o2).setType(type);
    }

    public void setLaserWavelength(PositiveInteger wavelength, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new Laser());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((Laser)o2).setWavelength(wavelength);
    }

    public void setLightEmittingDiodeID(String id, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new LightEmittingDiode());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        this.model.addModelObject(id, o2);
        ((LightEmittingDiode)o2).setID(id);
    }

    public void setLightEmittingDiodeLotNumber(String lotNumber, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new LightEmittingDiode());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((LightEmittingDiode)o2).setLotNumber(lotNumber);
    }

    public void setLightEmittingDiodeManufacturer(String manufacturer, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new LightEmittingDiode());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((LightEmittingDiode)o2).setManufacturer(manufacturer);
    }

    public void setLightEmittingDiodeModel(String model, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new LightEmittingDiode());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((LightEmittingDiode)o2).setModel(model);
    }

    public void setLightEmittingDiodePower(Double power, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new LightEmittingDiode());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((LightEmittingDiode)o2).setPower(power);
    }

    public void setLightEmittingDiodeSerialNumber(String serialNumber, int instrumentIndex, int lightSourceIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfLightSourceList() == lightSourceIndex) {
            o1.addLightSource(new LightEmittingDiode());
        }
        LightSource o2 = o1.getLightSource(lightSourceIndex);
        ((LightEmittingDiode)o2).setSerialNumber(serialNumber);
    }

    public void setLightPathDichroicRef(String dichroic, int imageIndex, int channelIndex) {
        DichroicRef dichroic_reference = new DichroicRef();
        dichroic_reference.setID(dichroic);
        this.model.addReference(this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightPath(), dichroic_reference);
    }

    public void setLightPathEmissionFilterRef(String emissionFilter, int imageIndex, int channelIndex, int emissionFilterRefIndex) {
        EmissionFilterRef emissionFilterLinks_reference = new EmissionFilterRef();
        emissionFilterLinks_reference.setID(emissionFilter);
        this.model.addReference(this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightPath(), emissionFilterLinks_reference);
    }

    public void setLightPathExcitationFilterRef(String excitationFilter, int imageIndex, int channelIndex, int excitationFilterRefIndex) {
        ExcitationFilterRef excitationFilterLinks_reference = new ExcitationFilterRef();
        excitationFilterLinks_reference.setID(excitationFilter);
        this.model.addReference(this.root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightPath(), excitationFilterLinks_reference);
    }

    public void setChannelLightSourceSettingsAttenuation(PercentFraction attenuation, int imageIndex, int channelIndex) {
        Channel o3;
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        if ((o3 = o2.getChannel(channelIndex)).getLightSourceSettings() == null) {
            o3.setLightSourceSettings(new LightSourceSettings());
        }
        LightSourceSettings o4 = o3.getLightSourceSettings();
        o4.setAttenuation(attenuation);
    }

    public void setMicrobeamManipulationLightSourceSettingsAttenuation(PercentFraction attenuation, int experimentIndex, int microbeamManipulationIndex, int lightSourceSettingsIndex) {
        MicrobeamManipulation o2;
        Experiment o1;
        OME o0 = this.root;
        if (o0.sizeOfExperimentList() == experimentIndex) {
            o0.addExperiment(new Experiment());
        }
        if ((o1 = o0.getExperiment(experimentIndex)).sizeOfMicrobeamManipulationList() == microbeamManipulationIndex) {
            o1.addMicrobeamManipulation(new MicrobeamManipulation());
        }
        if ((o2 = o1.getMicrobeamManipulation(microbeamManipulationIndex)).sizeOfLightSourceSettingsList() == lightSourceSettingsIndex) {
            o2.addLightSourceSettings(new LightSourceSettings());
        }
        LightSourceSettings o3 = o2.getLightSourceSettings(lightSourceSettingsIndex);
        o3.setAttenuation(attenuation);
    }

    public void setChannelLightSourceSettingsID(String id, int imageIndex, int channelIndex) {
        Channel o3;
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        if ((o3 = o2.getChannel(channelIndex)).getLightSourceSettings() == null) {
            o3.setLightSourceSettings(new LightSourceSettings());
        }
        LightSourceSettings o4 = o3.getLightSourceSettings();
        this.model.addModelObject(id, o4);
        o4.setID(id);
    }

    public void setMicrobeamManipulationLightSourceSettingsID(String id, int experimentIndex, int microbeamManipulationIndex, int lightSourceSettingsIndex) {
        MicrobeamManipulation o2;
        Experiment o1;
        OME o0 = this.root;
        if (o0.sizeOfExperimentList() == experimentIndex) {
            o0.addExperiment(new Experiment());
        }
        if ((o1 = o0.getExperiment(experimentIndex)).sizeOfMicrobeamManipulationList() == microbeamManipulationIndex) {
            o1.addMicrobeamManipulation(new MicrobeamManipulation());
        }
        if ((o2 = o1.getMicrobeamManipulation(microbeamManipulationIndex)).sizeOfLightSourceSettingsList() == lightSourceSettingsIndex) {
            o2.addLightSourceSettings(new LightSourceSettings());
        }
        LightSourceSettings o3 = o2.getLightSourceSettings(lightSourceSettingsIndex);
        this.model.addModelObject(id, o3);
        o3.setID(id);
    }

    public void setChannelLightSourceSettingsWavelength(PositiveInteger wavelength, int imageIndex, int channelIndex) {
        Channel o3;
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfChannelList() == channelIndex) {
            o2.addChannel(new Channel());
        }
        if ((o3 = o2.getChannel(channelIndex)).getLightSourceSettings() == null) {
            o3.setLightSourceSettings(new LightSourceSettings());
        }
        LightSourceSettings o4 = o3.getLightSourceSettings();
        o4.setWavelength(wavelength);
    }

    public void setMicrobeamManipulationLightSourceSettingsWavelength(PositiveInteger wavelength, int experimentIndex, int microbeamManipulationIndex, int lightSourceSettingsIndex) {
        MicrobeamManipulation o2;
        Experiment o1;
        OME o0 = this.root;
        if (o0.sizeOfExperimentList() == experimentIndex) {
            o0.addExperiment(new Experiment());
        }
        if ((o1 = o0.getExperiment(experimentIndex)).sizeOfMicrobeamManipulationList() == microbeamManipulationIndex) {
            o1.addMicrobeamManipulation(new MicrobeamManipulation());
        }
        if ((o2 = o1.getMicrobeamManipulation(microbeamManipulationIndex)).sizeOfLightSourceSettingsList() == lightSourceSettingsIndex) {
            o2.addLightSourceSettings(new LightSourceSettings());
        }
        LightSourceSettings o3 = o2.getLightSourceSettings(lightSourceSettingsIndex);
        o3.setWavelength(wavelength);
    }

    public void setLineFillColor(Color fillColor, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setFillColor(fillColor);
    }

    public void setLineFillRule(FillRule fillRule, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setFillRule(fillRule);
    }

    public void setLineFontFamily(FontFamily fontFamily, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setFontFamily(fontFamily);
    }

    public void setLineFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setFontSize(fontSize);
    }

    public void setLineFontStyle(FontStyle fontStyle, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setFontStyle(fontStyle);
    }

    public void setLineID(String id, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        this.model.addModelObject(id, o3);
        ((Line)o3).setID(id);
    }

    public void setLineLineCap(LineCap lineCap, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setLineCap(lineCap);
    }

    public void setLineLocked(Boolean locked, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setLocked(locked);
    }

    public void setLineStrokeColor(Color strokeColor, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setStrokeColor(strokeColor);
    }

    public void setLineStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setStrokeDashArray(strokeDashArray);
    }

    public void setLineStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setStrokeWidth(strokeWidth);
    }

    public void setLineText(String text, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setText(text);
    }

    public void setLineTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setTheC(theC);
    }

    public void setLineTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setTheT(theT);
    }

    public void setLineTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setTheZ(theZ);
    }

    public void setLineTransform(AffineTransform transform, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setTransform(transform);
    }

    public void setLineVisible(Boolean visible, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setVisible(visible);
    }

    public void setLineMarkerEnd(Marker markerEnd, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setMarkerEnd(markerEnd);
    }

    public void setLineMarkerStart(Marker markerStart, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setMarkerStart(markerStart);
    }

    public void setLineX1(Double x1, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setX1(x1);
    }

    public void setLineX2(Double x2, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setX2(x2);
    }

    public void setLineY1(Double y1, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setY1(y1);
    }

    public void setLineY2(Double y2, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Line());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Line)o3).setY2(y2);
    }

    public void setListAnnotationAnnotationRef(String annotation, int listAnnotationIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getStructuredAnnotations().getListAnnotation(listAnnotationIndex), annotationLinks_reference);
    }

    public void setListAnnotationDescription(String description, int listAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfListAnnotationList() == listAnnotationIndex) {
            o1.addListAnnotation(new ListAnnotation());
        }
        ListAnnotation o2 = o1.getListAnnotation(listAnnotationIndex);
        o2.setDescription(description);
    }

    public void setListAnnotationID(String id, int listAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfListAnnotationList() == listAnnotationIndex) {
            o1.addListAnnotation(new ListAnnotation());
        }
        ListAnnotation o2 = o1.getListAnnotation(listAnnotationIndex);
        this.model.addModelObject(id, o2);
        o2.setID(id);
    }

    public void setListAnnotationNamespace(String namespace, int listAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfListAnnotationList() == listAnnotationIndex) {
            o1.addListAnnotation(new ListAnnotation());
        }
        ListAnnotation o2 = o1.getListAnnotation(listAnnotationIndex);
        o2.setNamespace(namespace);
    }

    public void setLongAnnotationAnnotationRef(String annotation, int longAnnotationIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getStructuredAnnotations().getLongAnnotation(longAnnotationIndex), annotationLinks_reference);
    }

    public void setLongAnnotationDescription(String description, int longAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfLongAnnotationList() == longAnnotationIndex) {
            o1.addLongAnnotation(new LongAnnotation());
        }
        LongAnnotation o2 = o1.getLongAnnotation(longAnnotationIndex);
        o2.setDescription(description);
    }

    public void setLongAnnotationID(String id, int longAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfLongAnnotationList() == longAnnotationIndex) {
            o1.addLongAnnotation(new LongAnnotation());
        }
        LongAnnotation o2 = o1.getLongAnnotation(longAnnotationIndex);
        this.model.addModelObject(id, o2);
        o2.setID(id);
    }

    public void setLongAnnotationNamespace(String namespace, int longAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfLongAnnotationList() == longAnnotationIndex) {
            o1.addLongAnnotation(new LongAnnotation());
        }
        LongAnnotation o2 = o1.getLongAnnotation(longAnnotationIndex);
        o2.setNamespace(namespace);
    }

    public void setLongAnnotationValue(Long value, int longAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfLongAnnotationList() == longAnnotationIndex) {
            o1.addLongAnnotation(new LongAnnotation());
        }
        LongAnnotation o2 = o1.getLongAnnotation(longAnnotationIndex);
        o2.setValue(value);
    }

    public void setMaskFillColor(Color fillColor, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setFillColor(fillColor);
    }

    public void setMaskFillRule(FillRule fillRule, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setFillRule(fillRule);
    }

    public void setMaskFontFamily(FontFamily fontFamily, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setFontFamily(fontFamily);
    }

    public void setMaskFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setFontSize(fontSize);
    }

    public void setMaskFontStyle(FontStyle fontStyle, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setFontStyle(fontStyle);
    }

    public void setMaskID(String id, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        this.model.addModelObject(id, o3);
        ((Mask)o3).setID(id);
    }

    public void setMaskLineCap(LineCap lineCap, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setLineCap(lineCap);
    }

    public void setMaskLocked(Boolean locked, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setLocked(locked);
    }

    public void setMaskStrokeColor(Color strokeColor, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setStrokeColor(strokeColor);
    }

    public void setMaskStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setStrokeDashArray(strokeDashArray);
    }

    public void setMaskStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setStrokeWidth(strokeWidth);
    }

    public void setMaskText(String text, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setText(text);
    }

    public void setMaskTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setTheC(theC);
    }

    public void setMaskTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setTheT(theT);
    }

    public void setMaskTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setTheZ(theZ);
    }

    public void setMaskTransform(AffineTransform transform, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setTransform(transform);
    }

    public void setMaskVisible(Boolean visible, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setVisible(visible);
    }

    public void setMaskHeight(Double height, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setHeight(height);
    }

    public void setMaskWidth(Double width, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setWidth(width);
    }

    public void setMaskX(Double x, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setX(x);
    }

    public void setMaskY(Double y, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Mask());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Mask)o3).setY(y);
    }

    public void setMicrobeamManipulationDescription(String description, int experimentIndex, int microbeamManipulationIndex) {
        Experiment o1;
        OME o0 = this.root;
        if (o0.sizeOfExperimentList() == experimentIndex) {
            o0.addExperiment(new Experiment());
        }
        if ((o1 = o0.getExperiment(experimentIndex)).sizeOfMicrobeamManipulationList() == microbeamManipulationIndex) {
            o1.addMicrobeamManipulation(new MicrobeamManipulation());
        }
        MicrobeamManipulation o2 = o1.getMicrobeamManipulation(microbeamManipulationIndex);
        o2.setDescription(description);
    }

    public void setMicrobeamManipulationExperimenterRef(String experimenter, int experimentIndex, int microbeamManipulationIndex) {
        ExperimenterRef experimenter_reference = new ExperimenterRef();
        experimenter_reference.setID(experimenter);
        this.model.addReference(this.root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex), experimenter_reference);
    }

    public void setMicrobeamManipulationID(String id, int experimentIndex, int microbeamManipulationIndex) {
        Experiment o1;
        OME o0 = this.root;
        if (o0.sizeOfExperimentList() == experimentIndex) {
            o0.addExperiment(new Experiment());
        }
        if ((o1 = o0.getExperiment(experimentIndex)).sizeOfMicrobeamManipulationList() == microbeamManipulationIndex) {
            o1.addMicrobeamManipulation(new MicrobeamManipulation());
        }
        MicrobeamManipulation o2 = o1.getMicrobeamManipulation(microbeamManipulationIndex);
        this.model.addModelObject(id, o2);
        o2.setID(id);
    }

    public void setMicrobeamManipulationROIRef(String roi, int experimentIndex, int microbeamManipulationIndex, int ROIRefIndex) {
        ROIRef roiLinks_reference = new ROIRef();
        roiLinks_reference.setID(roi);
        this.model.addReference(this.root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex), roiLinks_reference);
    }

    public void setMicrobeamManipulationType(MicrobeamManipulationType type, int experimentIndex, int microbeamManipulationIndex) {
        Experiment o1;
        OME o0 = this.root;
        if (o0.sizeOfExperimentList() == experimentIndex) {
            o0.addExperiment(new Experiment());
        }
        if ((o1 = o0.getExperiment(experimentIndex)).sizeOfMicrobeamManipulationList() == microbeamManipulationIndex) {
            o1.addMicrobeamManipulation(new MicrobeamManipulation());
        }
        MicrobeamManipulation o2 = o1.getMicrobeamManipulation(microbeamManipulationIndex);
        o2.setType(type);
    }

    public void setMicroscopeLotNumber(String lotNumber, int instrumentIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).getMicroscope() == null) {
            o1.setMicroscope(new Microscope());
        }
        Microscope o2 = o1.getMicroscope();
        o2.setLotNumber(lotNumber);
    }

    public void setMicroscopeManufacturer(String manufacturer, int instrumentIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).getMicroscope() == null) {
            o1.setMicroscope(new Microscope());
        }
        Microscope o2 = o1.getMicroscope();
        o2.setManufacturer(manufacturer);
    }

    public void setMicroscopeModel(String model, int instrumentIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).getMicroscope() == null) {
            o1.setMicroscope(new Microscope());
        }
        Microscope o2 = o1.getMicroscope();
        o2.setModel(model);
    }

    public void setMicroscopeSerialNumber(String serialNumber, int instrumentIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).getMicroscope() == null) {
            o1.setMicroscope(new Microscope());
        }
        Microscope o2 = o1.getMicroscope();
        o2.setSerialNumber(serialNumber);
    }

    public void setMicroscopeType(MicroscopeType type, int instrumentIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).getMicroscope() == null) {
            o1.setMicroscope(new Microscope());
        }
        Microscope o2 = o1.getMicroscope();
        o2.setType(type);
    }

    public void setObjectiveCalibratedMagnification(Double calibratedMagnification, int instrumentIndex, int objectiveIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfObjectiveList() == objectiveIndex) {
            o1.addObjective(new Objective());
        }
        Objective o2 = o1.getObjective(objectiveIndex);
        o2.setCalibratedMagnification(calibratedMagnification);
    }

    public void setObjectiveCorrection(Correction correction, int instrumentIndex, int objectiveIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfObjectiveList() == objectiveIndex) {
            o1.addObjective(new Objective());
        }
        Objective o2 = o1.getObjective(objectiveIndex);
        o2.setCorrection(correction);
    }

    public void setObjectiveID(String id, int instrumentIndex, int objectiveIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfObjectiveList() == objectiveIndex) {
            o1.addObjective(new Objective());
        }
        Objective o2 = o1.getObjective(objectiveIndex);
        this.model.addModelObject(id, o2);
        o2.setID(id);
    }

    public void setObjectiveImmersion(Immersion immersion, int instrumentIndex, int objectiveIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfObjectiveList() == objectiveIndex) {
            o1.addObjective(new Objective());
        }
        Objective o2 = o1.getObjective(objectiveIndex);
        o2.setImmersion(immersion);
    }

    public void setObjectiveIris(Boolean iris, int instrumentIndex, int objectiveIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfObjectiveList() == objectiveIndex) {
            o1.addObjective(new Objective());
        }
        Objective o2 = o1.getObjective(objectiveIndex);
        o2.setIris(iris);
    }

    public void setObjectiveLensNA(Double lensNA, int instrumentIndex, int objectiveIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfObjectiveList() == objectiveIndex) {
            o1.addObjective(new Objective());
        }
        Objective o2 = o1.getObjective(objectiveIndex);
        o2.setLensNA(lensNA);
    }

    public void setObjectiveLotNumber(String lotNumber, int instrumentIndex, int objectiveIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfObjectiveList() == objectiveIndex) {
            o1.addObjective(new Objective());
        }
        Objective o2 = o1.getObjective(objectiveIndex);
        o2.setLotNumber(lotNumber);
    }

    public void setObjectiveManufacturer(String manufacturer, int instrumentIndex, int objectiveIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfObjectiveList() == objectiveIndex) {
            o1.addObjective(new Objective());
        }
        Objective o2 = o1.getObjective(objectiveIndex);
        o2.setManufacturer(manufacturer);
    }

    public void setObjectiveModel(String model, int instrumentIndex, int objectiveIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfObjectiveList() == objectiveIndex) {
            o1.addObjective(new Objective());
        }
        Objective o2 = o1.getObjective(objectiveIndex);
        o2.setModel(model);
    }

    public void setObjectiveNominalMagnification(PositiveInteger nominalMagnification, int instrumentIndex, int objectiveIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfObjectiveList() == objectiveIndex) {
            o1.addObjective(new Objective());
        }
        Objective o2 = o1.getObjective(objectiveIndex);
        o2.setNominalMagnification(nominalMagnification);
    }

    public void setObjectiveSerialNumber(String serialNumber, int instrumentIndex, int objectiveIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfObjectiveList() == objectiveIndex) {
            o1.addObjective(new Objective());
        }
        Objective o2 = o1.getObjective(objectiveIndex);
        o2.setSerialNumber(serialNumber);
    }

    public void setObjectiveWorkingDistance(Double workingDistance, int instrumentIndex, int objectiveIndex) {
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfObjectiveList() == objectiveIndex) {
            o1.addObjective(new Objective());
        }
        Objective o2 = o1.getObjective(objectiveIndex);
        o2.setWorkingDistance(workingDistance);
    }

    public void setObjectiveSettingsCorrectionCollar(Double correctionCollar, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getObjectiveSettings() == null) {
            o1.setObjectiveSettings(new ObjectiveSettings());
        }
        ObjectiveSettings o2 = o1.getObjectiveSettings();
        o2.setCorrectionCollar(correctionCollar);
    }

    public void setObjectiveSettingsID(String id, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getObjectiveSettings() == null) {
            o1.setObjectiveSettings(new ObjectiveSettings());
        }
        ObjectiveSettings o2 = o1.getObjectiveSettings();
        this.model.addModelObject(id, o2);
        o2.setID(id);
    }

    public void setObjectiveSettingsMedium(Medium medium, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getObjectiveSettings() == null) {
            o1.setObjectiveSettings(new ObjectiveSettings());
        }
        ObjectiveSettings o2 = o1.getObjectiveSettings();
        o2.setMedium(medium);
    }

    public void setObjectiveSettingsRefractiveIndex(Double refractiveIndex, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getObjectiveSettings() == null) {
            o1.setObjectiveSettings(new ObjectiveSettings());
        }
        ObjectiveSettings o2 = o1.getObjectiveSettings();
        o2.setRefractiveIndex(refractiveIndex);
    }

    public void setPixelsAnnotationRef(String annotation, int imageIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getImage(imageIndex).getPixels(), annotationLinks_reference);
    }

    public void setPixelsDimensionOrder(DimensionOrder dimensionOrder, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        Pixels o2 = o1.getPixels();
        o2.setDimensionOrder(dimensionOrder);
    }

    public void setPixelsID(String id, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        Pixels o2 = o1.getPixels();
        this.model.addModelObject(id, o2);
        o2.setID(id);
    }

    public void setPixelsPhysicalSizeX(PositiveFloat physicalSizeX, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        Pixels o2 = o1.getPixels();
        o2.setPhysicalSizeX(physicalSizeX);
    }

    public void setPixelsPhysicalSizeY(PositiveFloat physicalSizeY, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        Pixels o2 = o1.getPixels();
        o2.setPhysicalSizeY(physicalSizeY);
    }

    public void setPixelsPhysicalSizeZ(PositiveFloat physicalSizeZ, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        Pixels o2 = o1.getPixels();
        o2.setPhysicalSizeZ(physicalSizeZ);
    }

    public void setPixelsSizeC(PositiveInteger sizeC, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        Pixels o2 = o1.getPixels();
        o2.setSizeC(sizeC);
    }

    public void setPixelsSizeT(PositiveInteger sizeT, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        Pixels o2 = o1.getPixels();
        o2.setSizeT(sizeT);
    }

    public void setPixelsSizeX(PositiveInteger sizeX, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        Pixels o2 = o1.getPixels();
        o2.setSizeX(sizeX);
    }

    public void setPixelsSizeY(PositiveInteger sizeY, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        Pixels o2 = o1.getPixels();
        o2.setSizeY(sizeY);
    }

    public void setPixelsSizeZ(PositiveInteger sizeZ, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        Pixels o2 = o1.getPixels();
        o2.setSizeZ(sizeZ);
    }

    public void setPixelsTimeIncrement(Double timeIncrement, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        Pixels o2 = o1.getPixels();
        o2.setTimeIncrement(timeIncrement);
    }

    public void setPixelsType(PixelType type, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        Pixels o2 = o1.getPixels();
        o2.setType(type);
    }

    public void setPlaneAnnotationRef(String annotation, int imageIndex, int planeIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getImage(imageIndex).getPixels().getPlane(planeIndex), annotationLinks_reference);
    }

    public void setPlaneDeltaT(Double deltaT, int imageIndex, int planeIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfPlaneList() == planeIndex) {
            o2.addPlane(new Plane());
        }
        Plane o3 = o2.getPlane(planeIndex);
        o3.setDeltaT(deltaT);
    }

    public void setPlaneExposureTime(Double exposureTime, int imageIndex, int planeIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfPlaneList() == planeIndex) {
            o2.addPlane(new Plane());
        }
        Plane o3 = o2.getPlane(planeIndex);
        o3.setExposureTime(exposureTime);
    }

    public void setPlaneHashSHA1(String hashSHA1, int imageIndex, int planeIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfPlaneList() == planeIndex) {
            o2.addPlane(new Plane());
        }
        Plane o3 = o2.getPlane(planeIndex);
        o3.setHashSHA1(hashSHA1);
    }

    public void setPlanePositionX(Double positionX, int imageIndex, int planeIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfPlaneList() == planeIndex) {
            o2.addPlane(new Plane());
        }
        Plane o3 = o2.getPlane(planeIndex);
        o3.setPositionX(positionX);
    }

    public void setPlanePositionY(Double positionY, int imageIndex, int planeIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfPlaneList() == planeIndex) {
            o2.addPlane(new Plane());
        }
        Plane o3 = o2.getPlane(planeIndex);
        o3.setPositionY(positionY);
    }

    public void setPlanePositionZ(Double positionZ, int imageIndex, int planeIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfPlaneList() == planeIndex) {
            o2.addPlane(new Plane());
        }
        Plane o3 = o2.getPlane(planeIndex);
        o3.setPositionZ(positionZ);
    }

    public void setPlaneTheC(NonNegativeInteger theC, int imageIndex, int planeIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfPlaneList() == planeIndex) {
            o2.addPlane(new Plane());
        }
        Plane o3 = o2.getPlane(planeIndex);
        o3.setTheC(theC);
    }

    public void setPlaneTheT(NonNegativeInteger theT, int imageIndex, int planeIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfPlaneList() == planeIndex) {
            o2.addPlane(new Plane());
        }
        Plane o3 = o2.getPlane(planeIndex);
        o3.setTheT(theT);
    }

    public void setPlaneTheZ(NonNegativeInteger theZ, int imageIndex, int planeIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfPlaneList() == planeIndex) {
            o2.addPlane(new Plane());
        }
        Plane o3 = o2.getPlane(planeIndex);
        o3.setTheZ(theZ);
    }

    public void setPlateAnnotationRef(String annotation, int plateIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getPlate(plateIndex), annotationLinks_reference);
    }

    public void setPlateColumnNamingConvention(NamingConvention columnNamingConvention, int plateIndex) {
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        Plate o1 = o0.getPlate(plateIndex);
        o1.setColumnNamingConvention(columnNamingConvention);
    }

    public void setPlateColumns(PositiveInteger columns, int plateIndex) {
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        Plate o1 = o0.getPlate(plateIndex);
        o1.setColumns(columns);
    }

    public void setPlateDescription(String description, int plateIndex) {
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        Plate o1 = o0.getPlate(plateIndex);
        o1.setDescription(description);
    }

    public void setPlateExternalIdentifier(String externalIdentifier, int plateIndex) {
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        Plate o1 = o0.getPlate(plateIndex);
        o1.setExternalIdentifier(externalIdentifier);
    }

    public void setPlateFieldIndex(NonNegativeInteger fieldIndex, int plateIndex) {
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        Plate o1 = o0.getPlate(plateIndex);
        o1.setFieldIndex(fieldIndex);
    }

    public void setPlateID(String id, int plateIndex) {
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        Plate o1 = o0.getPlate(plateIndex);
        this.model.addModelObject(id, o1);
        o1.setID(id);
    }

    public void setPlateName(String name, int plateIndex) {
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        Plate o1 = o0.getPlate(plateIndex);
        o1.setName(name);
    }

    public void setPlateRowNamingConvention(NamingConvention rowNamingConvention, int plateIndex) {
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        Plate o1 = o0.getPlate(plateIndex);
        o1.setRowNamingConvention(rowNamingConvention);
    }

    public void setPlateRows(PositiveInteger rows, int plateIndex) {
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        Plate o1 = o0.getPlate(plateIndex);
        o1.setRows(rows);
    }

    public void setPlateStatus(String status, int plateIndex) {
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        Plate o1 = o0.getPlate(plateIndex);
        o1.setStatus(status);
    }

    public void setPlateWellOriginX(Double wellOriginX, int plateIndex) {
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        Plate o1 = o0.getPlate(plateIndex);
        o1.setWellOriginX(wellOriginX);
    }

    public void setPlateWellOriginY(Double wellOriginY, int plateIndex) {
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        Plate o1 = o0.getPlate(plateIndex);
        o1.setWellOriginY(wellOriginY);
    }

    public void setPlateAcquisitionAnnotationRef(String annotation, int plateIndex, int plateAcquisitionIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex), annotationLinks_reference);
    }

    public void setPlateAcquisitionDescription(String description, int plateIndex, int plateAcquisitionIndex) {
        Plate o1;
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfPlateAcquisitionList() == plateAcquisitionIndex) {
            o1.addPlateAcquisition(new PlateAcquisition());
        }
        PlateAcquisition o2 = o1.getPlateAcquisition(plateAcquisitionIndex);
        o2.setDescription(description);
    }

    public void setPlateAcquisitionEndTime(Timestamp endTime, int plateIndex, int plateAcquisitionIndex) {
        Plate o1;
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfPlateAcquisitionList() == plateAcquisitionIndex) {
            o1.addPlateAcquisition(new PlateAcquisition());
        }
        PlateAcquisition o2 = o1.getPlateAcquisition(plateAcquisitionIndex);
        o2.setEndTime(endTime);
    }

    public void setPlateAcquisitionID(String id, int plateIndex, int plateAcquisitionIndex) {
        Plate o1;
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfPlateAcquisitionList() == plateAcquisitionIndex) {
            o1.addPlateAcquisition(new PlateAcquisition());
        }
        PlateAcquisition o2 = o1.getPlateAcquisition(plateAcquisitionIndex);
        this.model.addModelObject(id, o2);
        o2.setID(id);
    }

    public void setPlateAcquisitionMaximumFieldCount(PositiveInteger maximumFieldCount, int plateIndex, int plateAcquisitionIndex) {
        Plate o1;
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfPlateAcquisitionList() == plateAcquisitionIndex) {
            o1.addPlateAcquisition(new PlateAcquisition());
        }
        PlateAcquisition o2 = o1.getPlateAcquisition(plateAcquisitionIndex);
        o2.setMaximumFieldCount(maximumFieldCount);
    }

    public void setPlateAcquisitionName(String name, int plateIndex, int plateAcquisitionIndex) {
        Plate o1;
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfPlateAcquisitionList() == plateAcquisitionIndex) {
            o1.addPlateAcquisition(new PlateAcquisition());
        }
        PlateAcquisition o2 = o1.getPlateAcquisition(plateAcquisitionIndex);
        o2.setName(name);
    }

    public void setPlateAcquisitionStartTime(Timestamp startTime, int plateIndex, int plateAcquisitionIndex) {
        Plate o1;
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfPlateAcquisitionList() == plateAcquisitionIndex) {
            o1.addPlateAcquisition(new PlateAcquisition());
        }
        PlateAcquisition o2 = o1.getPlateAcquisition(plateAcquisitionIndex);
        o2.setStartTime(startTime);
    }

    public void setPlateAcquisitionWellSampleRef(String wellSample, int plateIndex, int plateAcquisitionIndex, int wellSampleRefIndex) {
        WellSampleRef wellSamples_reference = new WellSampleRef();
        wellSamples_reference.setID(wellSample);
        this.model.addReference(this.root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex), wellSamples_reference);
    }

    public void setPointFillColor(Color fillColor, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setFillColor(fillColor);
    }

    public void setPointFillRule(FillRule fillRule, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setFillRule(fillRule);
    }

    public void setPointFontFamily(FontFamily fontFamily, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setFontFamily(fontFamily);
    }

    public void setPointFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setFontSize(fontSize);
    }

    public void setPointFontStyle(FontStyle fontStyle, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setFontStyle(fontStyle);
    }

    public void setPointID(String id, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        this.model.addModelObject(id, o3);
        ((Point)o3).setID(id);
    }

    public void setPointLineCap(LineCap lineCap, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setLineCap(lineCap);
    }

    public void setPointLocked(Boolean locked, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setLocked(locked);
    }

    public void setPointStrokeColor(Color strokeColor, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setStrokeColor(strokeColor);
    }

    public void setPointStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setStrokeDashArray(strokeDashArray);
    }

    public void setPointStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setStrokeWidth(strokeWidth);
    }

    public void setPointText(String text, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setText(text);
    }

    public void setPointTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setTheC(theC);
    }

    public void setPointTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setTheT(theT);
    }

    public void setPointTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setTheZ(theZ);
    }

    public void setPointTransform(AffineTransform transform, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setTransform(transform);
    }

    public void setPointVisible(Boolean visible, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setVisible(visible);
    }

    public void setPointX(Double x, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setX(x);
    }

    public void setPointY(Double y, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Point());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Point)o3).setY(y);
    }

    public void setPolygonFillColor(Color fillColor, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polygon());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polygon)o3).setFillColor(fillColor);
    }

    public void setPolygonFillRule(FillRule fillRule, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polygon());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polygon)o3).setFillRule(fillRule);
    }

    public void setPolygonFontFamily(FontFamily fontFamily, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polygon());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polygon)o3).setFontFamily(fontFamily);
    }

    public void setPolygonFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polygon());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polygon)o3).setFontSize(fontSize);
    }

    public void setPolygonFontStyle(FontStyle fontStyle, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polygon());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polygon)o3).setFontStyle(fontStyle);
    }

    public void setPolygonID(String id, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polygon());
        }
        Shape o3 = o2.getShape(shapeIndex);
        this.model.addModelObject(id, o3);
        ((Polygon)o3).setID(id);
    }

    public void setPolygonLineCap(LineCap lineCap, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polygon());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polygon)o3).setLineCap(lineCap);
    }

    public void setPolygonLocked(Boolean locked, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polygon());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polygon)o3).setLocked(locked);
    }

    public void setPolygonStrokeColor(Color strokeColor, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polygon());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polygon)o3).setStrokeColor(strokeColor);
    }

    public void setPolygonStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polygon());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polygon)o3).setStrokeDashArray(strokeDashArray);
    }

    public void setPolygonStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polygon());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polygon)o3).setStrokeWidth(strokeWidth);
    }

    public void setPolygonText(String text, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polygon());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polygon)o3).setText(text);
    }

    public void setPolygonTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polygon());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polygon)o3).setTheC(theC);
    }

    public void setPolygonTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polygon());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polygon)o3).setTheT(theT);
    }

    public void setPolygonTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polygon());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polygon)o3).setTheZ(theZ);
    }

    public void setPolygonTransform(AffineTransform transform, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polygon());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polygon)o3).setTransform(transform);
    }

    public void setPolygonVisible(Boolean visible, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polygon());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polygon)o3).setVisible(visible);
    }

    public void setPolygonPoints(String points, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polygon());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polygon)o3).setPoints(points);
    }

    public void setPolylineFillColor(Color fillColor, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setFillColor(fillColor);
    }

    public void setPolylineFillRule(FillRule fillRule, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setFillRule(fillRule);
    }

    public void setPolylineFontFamily(FontFamily fontFamily, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setFontFamily(fontFamily);
    }

    public void setPolylineFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setFontSize(fontSize);
    }

    public void setPolylineFontStyle(FontStyle fontStyle, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setFontStyle(fontStyle);
    }

    public void setPolylineID(String id, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        this.model.addModelObject(id, o3);
        ((Polyline)o3).setID(id);
    }

    public void setPolylineLineCap(LineCap lineCap, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setLineCap(lineCap);
    }

    public void setPolylineLocked(Boolean locked, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setLocked(locked);
    }

    public void setPolylineStrokeColor(Color strokeColor, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setStrokeColor(strokeColor);
    }

    public void setPolylineStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setStrokeDashArray(strokeDashArray);
    }

    public void setPolylineStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setStrokeWidth(strokeWidth);
    }

    public void setPolylineText(String text, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setText(text);
    }

    public void setPolylineTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setTheC(theC);
    }

    public void setPolylineTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setTheT(theT);
    }

    public void setPolylineTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setTheZ(theZ);
    }

    public void setPolylineTransform(AffineTransform transform, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setTransform(transform);
    }

    public void setPolylineVisible(Boolean visible, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setVisible(visible);
    }

    public void setPolylineMarkerEnd(Marker markerEnd, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setMarkerEnd(markerEnd);
    }

    public void setPolylineMarkerStart(Marker markerStart, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setMarkerStart(markerStart);
    }

    public void setPolylinePoints(String points, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Polyline());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Polyline)o3).setPoints(points);
    }

    public void setProjectAnnotationRef(String annotation, int projectIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getProject(projectIndex), annotationLinks_reference);
    }

    public void setProjectDatasetRef(String dataset, int projectIndex, int datasetRefIndex) {
        DatasetRef datasetLinks_reference = new DatasetRef();
        datasetLinks_reference.setID(dataset);
        this.model.addReference(this.root.getProject(projectIndex), datasetLinks_reference);
    }

    public void setProjectDescription(String description, int projectIndex) {
        OME o0 = this.root;
        if (o0.sizeOfProjectList() == projectIndex) {
            o0.addProject(new Project());
        }
        Project o1 = o0.getProject(projectIndex);
        o1.setDescription(description);
    }

    public void setProjectExperimenterGroupRef(String experimenterGroup, int projectIndex) {
        ExperimenterGroupRef experimenterGroup_reference = new ExperimenterGroupRef();
        experimenterGroup_reference.setID(experimenterGroup);
        this.model.addReference(this.root.getProject(projectIndex), experimenterGroup_reference);
    }

    public void setProjectExperimenterRef(String experimenter, int projectIndex) {
        ExperimenterRef experimenter_reference = new ExperimenterRef();
        experimenter_reference.setID(experimenter);
        this.model.addReference(this.root.getProject(projectIndex), experimenter_reference);
    }

    public void setProjectID(String id, int projectIndex) {
        OME o0 = this.root;
        if (o0.sizeOfProjectList() == projectIndex) {
            o0.addProject(new Project());
        }
        Project o1 = o0.getProject(projectIndex);
        this.model.addModelObject(id, o1);
        o1.setID(id);
    }

    public void setProjectName(String name, int projectIndex) {
        OME o0 = this.root;
        if (o0.sizeOfProjectList() == projectIndex) {
            o0.addProject(new Project());
        }
        Project o1 = o0.getProject(projectIndex);
        o1.setName(name);
    }

    public void setROIAnnotationRef(String annotation, int ROIIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getROI(ROIIndex), annotationLinks_reference);
    }

    public void setROIDescription(String description, int ROIIndex) {
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        ROI o1 = o0.getROI(ROIIndex);
        o1.setDescription(description);
    }

    public void setROIID(String id, int ROIIndex) {
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        ROI o1 = o0.getROI(ROIIndex);
        this.model.addModelObject(id, o1);
        o1.setID(id);
    }

    public void setROIName(String name, int ROIIndex) {
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        ROI o1 = o0.getROI(ROIIndex);
        o1.setName(name);
    }

    public void setROINamespace(String namespace, int ROIIndex) {
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        ROI o1 = o0.getROI(ROIIndex);
        o1.setNamespace(namespace);
    }

    public void setReagentAnnotationRef(String annotation, int screenIndex, int reagentIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getScreen(screenIndex).getReagent(reagentIndex), annotationLinks_reference);
    }

    public void setReagentDescription(String description, int screenIndex, int reagentIndex) {
        Screen o1;
        OME o0 = this.root;
        if (o0.sizeOfScreenList() == screenIndex) {
            o0.addScreen(new Screen());
        }
        if ((o1 = o0.getScreen(screenIndex)).sizeOfReagentList() == reagentIndex) {
            o1.addReagent(new Reagent());
        }
        Reagent o2 = o1.getReagent(reagentIndex);
        o2.setDescription(description);
    }

    public void setReagentID(String id, int screenIndex, int reagentIndex) {
        Screen o1;
        OME o0 = this.root;
        if (o0.sizeOfScreenList() == screenIndex) {
            o0.addScreen(new Screen());
        }
        if ((o1 = o0.getScreen(screenIndex)).sizeOfReagentList() == reagentIndex) {
            o1.addReagent(new Reagent());
        }
        Reagent o2 = o1.getReagent(reagentIndex);
        this.model.addModelObject(id, o2);
        o2.setID(id);
    }

    public void setReagentName(String name, int screenIndex, int reagentIndex) {
        Screen o1;
        OME o0 = this.root;
        if (o0.sizeOfScreenList() == screenIndex) {
            o0.addScreen(new Screen());
        }
        if ((o1 = o0.getScreen(screenIndex)).sizeOfReagentList() == reagentIndex) {
            o1.addReagent(new Reagent());
        }
        Reagent o2 = o1.getReagent(reagentIndex);
        o2.setName(name);
    }

    public void setReagentReagentIdentifier(String reagentIdentifier, int screenIndex, int reagentIndex) {
        Screen o1;
        OME o0 = this.root;
        if (o0.sizeOfScreenList() == screenIndex) {
            o0.addScreen(new Screen());
        }
        if ((o1 = o0.getScreen(screenIndex)).sizeOfReagentList() == reagentIndex) {
            o1.addReagent(new Reagent());
        }
        Reagent o2 = o1.getReagent(reagentIndex);
        o2.setReagentIdentifier(reagentIdentifier);
    }

    public void setRectangleFillColor(Color fillColor, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setFillColor(fillColor);
    }

    public void setRectangleFillRule(FillRule fillRule, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setFillRule(fillRule);
    }

    public void setRectangleFontFamily(FontFamily fontFamily, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setFontFamily(fontFamily);
    }

    public void setRectangleFontSize(NonNegativeInteger fontSize, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setFontSize(fontSize);
    }

    public void setRectangleFontStyle(FontStyle fontStyle, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setFontStyle(fontStyle);
    }

    public void setRectangleID(String id, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        this.model.addModelObject(id, o3);
        ((Rectangle)o3).setID(id);
    }

    public void setRectangleLineCap(LineCap lineCap, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setLineCap(lineCap);
    }

    public void setRectangleLocked(Boolean locked, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setLocked(locked);
    }

    public void setRectangleStrokeColor(Color strokeColor, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setStrokeColor(strokeColor);
    }

    public void setRectangleStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setStrokeDashArray(strokeDashArray);
    }

    public void setRectangleStrokeWidth(Double strokeWidth, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setStrokeWidth(strokeWidth);
    }

    public void setRectangleText(String text, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setText(text);
    }

    public void setRectangleTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setTheC(theC);
    }

    public void setRectangleTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setTheT(theT);
    }

    public void setRectangleTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setTheZ(theZ);
    }

    public void setRectangleTransform(AffineTransform transform, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setTransform(transform);
    }

    public void setRectangleVisible(Boolean visible, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setVisible(visible);
    }

    public void setRectangleHeight(Double height, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setHeight(height);
    }

    public void setRectangleWidth(Double width, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setWidth(width);
    }

    public void setRectangleX(Double x, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setX(x);
    }

    public void setRectangleY(Double y, int ROIIndex, int shapeIndex) {
        Union o2;
        ROI o1;
        OME o0 = this.root;
        if (o0.sizeOfROIList() == ROIIndex) {
            o0.addROI(new ROI());
        }
        if ((o1 = o0.getROI(ROIIndex)).getUnion() == null) {
            o1.setUnion(new Union());
        }
        if ((o2 = o1.getUnion()).sizeOfShapeList() == shapeIndex) {
            o2.addShape(new Rectangle());
        }
        Shape o3 = o2.getShape(shapeIndex);
        ((Rectangle)o3).setY(y);
    }

    public void setScreenAnnotationRef(String annotation, int screenIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getScreen(screenIndex), annotationLinks_reference);
    }

    public void setScreenDescription(String description, int screenIndex) {
        OME o0 = this.root;
        if (o0.sizeOfScreenList() == screenIndex) {
            o0.addScreen(new Screen());
        }
        Screen o1 = o0.getScreen(screenIndex);
        o1.setDescription(description);
    }

    public void setScreenID(String id, int screenIndex) {
        OME o0 = this.root;
        if (o0.sizeOfScreenList() == screenIndex) {
            o0.addScreen(new Screen());
        }
        Screen o1 = o0.getScreen(screenIndex);
        this.model.addModelObject(id, o1);
        o1.setID(id);
    }

    public void setScreenName(String name, int screenIndex) {
        OME o0 = this.root;
        if (o0.sizeOfScreenList() == screenIndex) {
            o0.addScreen(new Screen());
        }
        Screen o1 = o0.getScreen(screenIndex);
        o1.setName(name);
    }

    public void setScreenPlateRef(String plate, int screenIndex, int plateRefIndex) {
        PlateRef plateLinks_reference = new PlateRef();
        plateLinks_reference.setID(plate);
        this.model.addReference(this.root.getScreen(screenIndex), plateLinks_reference);
    }

    public void setScreenProtocolDescription(String protocolDescription, int screenIndex) {
        OME o0 = this.root;
        if (o0.sizeOfScreenList() == screenIndex) {
            o0.addScreen(new Screen());
        }
        Screen o1 = o0.getScreen(screenIndex);
        o1.setProtocolDescription(protocolDescription);
    }

    public void setScreenProtocolIdentifier(String protocolIdentifier, int screenIndex) {
        OME o0 = this.root;
        if (o0.sizeOfScreenList() == screenIndex) {
            o0.addScreen(new Screen());
        }
        Screen o1 = o0.getScreen(screenIndex);
        o1.setProtocolIdentifier(protocolIdentifier);
    }

    public void setScreenReagentSetDescription(String reagentSetDescription, int screenIndex) {
        OME o0 = this.root;
        if (o0.sizeOfScreenList() == screenIndex) {
            o0.addScreen(new Screen());
        }
        Screen o1 = o0.getScreen(screenIndex);
        o1.setReagentSetDescription(reagentSetDescription);
    }

    public void setScreenReagentSetIdentifier(String reagentSetIdentifier, int screenIndex) {
        OME o0 = this.root;
        if (o0.sizeOfScreenList() == screenIndex) {
            o0.addScreen(new Screen());
        }
        Screen o1 = o0.getScreen(screenIndex);
        o1.setReagentSetIdentifier(reagentSetIdentifier);
    }

    public void setScreenType(String type, int screenIndex) {
        OME o0 = this.root;
        if (o0.sizeOfScreenList() == screenIndex) {
            o0.addScreen(new Screen());
        }
        Screen o1 = o0.getScreen(screenIndex);
        o1.setType(type);
    }

    public void setStageLabelName(String name, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getStageLabel() == null) {
            o1.setStageLabel(new StageLabel());
        }
        StageLabel o2 = o1.getStageLabel();
        o2.setName(name);
    }

    public void setStageLabelX(Double x, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getStageLabel() == null) {
            o1.setStageLabel(new StageLabel());
        }
        StageLabel o2 = o1.getStageLabel();
        o2.setX(x);
    }

    public void setStageLabelY(Double y, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getStageLabel() == null) {
            o1.setStageLabel(new StageLabel());
        }
        StageLabel o2 = o1.getStageLabel();
        o2.setY(y);
    }

    public void setStageLabelZ(Double z, int imageIndex) {
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getStageLabel() == null) {
            o1.setStageLabel(new StageLabel());
        }
        StageLabel o2 = o1.getStageLabel();
        o2.setZ(z);
    }

    public void setTagAnnotationAnnotationRef(String annotation, int tagAnnotationIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getStructuredAnnotations().getTagAnnotation(tagAnnotationIndex), annotationLinks_reference);
    }

    public void setTagAnnotationDescription(String description, int tagAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfTagAnnotationList() == tagAnnotationIndex) {
            o1.addTagAnnotation(new TagAnnotation());
        }
        TagAnnotation o2 = o1.getTagAnnotation(tagAnnotationIndex);
        o2.setDescription(description);
    }

    public void setTagAnnotationID(String id, int tagAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfTagAnnotationList() == tagAnnotationIndex) {
            o1.addTagAnnotation(new TagAnnotation());
        }
        TagAnnotation o2 = o1.getTagAnnotation(tagAnnotationIndex);
        this.model.addModelObject(id, o2);
        o2.setID(id);
    }

    public void setTagAnnotationNamespace(String namespace, int tagAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfTagAnnotationList() == tagAnnotationIndex) {
            o1.addTagAnnotation(new TagAnnotation());
        }
        TagAnnotation o2 = o1.getTagAnnotation(tagAnnotationIndex);
        o2.setNamespace(namespace);
    }

    public void setTagAnnotationValue(String value, int tagAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfTagAnnotationList() == tagAnnotationIndex) {
            o1.addTagAnnotation(new TagAnnotation());
        }
        TagAnnotation o2 = o1.getTagAnnotation(tagAnnotationIndex);
        o2.setValue(value);
    }

    public void setTermAnnotationAnnotationRef(String annotation, int termAnnotationIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getStructuredAnnotations().getTermAnnotation(termAnnotationIndex), annotationLinks_reference);
    }

    public void setTermAnnotationDescription(String description, int termAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfTermAnnotationList() == termAnnotationIndex) {
            o1.addTermAnnotation(new TermAnnotation());
        }
        TermAnnotation o2 = o1.getTermAnnotation(termAnnotationIndex);
        o2.setDescription(description);
    }

    public void setTermAnnotationID(String id, int termAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfTermAnnotationList() == termAnnotationIndex) {
            o1.addTermAnnotation(new TermAnnotation());
        }
        TermAnnotation o2 = o1.getTermAnnotation(termAnnotationIndex);
        this.model.addModelObject(id, o2);
        o2.setID(id);
    }

    public void setTermAnnotationNamespace(String namespace, int termAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfTermAnnotationList() == termAnnotationIndex) {
            o1.addTermAnnotation(new TermAnnotation());
        }
        TermAnnotation o2 = o1.getTermAnnotation(termAnnotationIndex);
        o2.setNamespace(namespace);
    }

    public void setTermAnnotationValue(String value, int termAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfTermAnnotationList() == termAnnotationIndex) {
            o1.addTermAnnotation(new TermAnnotation());
        }
        TermAnnotation o2 = o1.getTermAnnotation(termAnnotationIndex);
        o2.setValue(value);
    }

    public void setTiffDataFirstC(NonNegativeInteger firstC, int imageIndex, int tiffDataIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfTiffDataList() == tiffDataIndex) {
            o2.addTiffData(new TiffData());
        }
        TiffData o3 = o2.getTiffData(tiffDataIndex);
        o3.setFirstC(firstC);
    }

    public void setTiffDataFirstT(NonNegativeInteger firstT, int imageIndex, int tiffDataIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfTiffDataList() == tiffDataIndex) {
            o2.addTiffData(new TiffData());
        }
        TiffData o3 = o2.getTiffData(tiffDataIndex);
        o3.setFirstT(firstT);
    }

    public void setTiffDataFirstZ(NonNegativeInteger firstZ, int imageIndex, int tiffDataIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfTiffDataList() == tiffDataIndex) {
            o2.addTiffData(new TiffData());
        }
        TiffData o3 = o2.getTiffData(tiffDataIndex);
        o3.setFirstZ(firstZ);
    }

    public void setTiffDataIFD(NonNegativeInteger ifd, int imageIndex, int tiffDataIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfTiffDataList() == tiffDataIndex) {
            o2.addTiffData(new TiffData());
        }
        TiffData o3 = o2.getTiffData(tiffDataIndex);
        o3.setIFD(ifd);
    }

    public void setTiffDataPlaneCount(NonNegativeInteger planeCount, int imageIndex, int tiffDataIndex) {
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfTiffDataList() == tiffDataIndex) {
            o2.addTiffData(new TiffData());
        }
        TiffData o3 = o2.getTiffData(tiffDataIndex);
        o3.setPlaneCount(planeCount);
    }

    public void setTimestampAnnotationAnnotationRef(String annotation, int timestampAnnotationIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getStructuredAnnotations().getTimestampAnnotation(timestampAnnotationIndex), annotationLinks_reference);
    }

    public void setTimestampAnnotationDescription(String description, int timestampAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfTimestampAnnotationList() == timestampAnnotationIndex) {
            o1.addTimestampAnnotation(new TimestampAnnotation());
        }
        TimestampAnnotation o2 = o1.getTimestampAnnotation(timestampAnnotationIndex);
        o2.setDescription(description);
    }

    public void setTimestampAnnotationID(String id, int timestampAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfTimestampAnnotationList() == timestampAnnotationIndex) {
            o1.addTimestampAnnotation(new TimestampAnnotation());
        }
        TimestampAnnotation o2 = o1.getTimestampAnnotation(timestampAnnotationIndex);
        this.model.addModelObject(id, o2);
        o2.setID(id);
    }

    public void setTimestampAnnotationNamespace(String namespace, int timestampAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfTimestampAnnotationList() == timestampAnnotationIndex) {
            o1.addTimestampAnnotation(new TimestampAnnotation());
        }
        TimestampAnnotation o2 = o1.getTimestampAnnotation(timestampAnnotationIndex);
        o2.setNamespace(namespace);
    }

    public void setTimestampAnnotationValue(Timestamp value, int timestampAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfTimestampAnnotationList() == timestampAnnotationIndex) {
            o1.addTimestampAnnotation(new TimestampAnnotation());
        }
        TimestampAnnotation o2 = o1.getTimestampAnnotation(timestampAnnotationIndex);
        o2.setValue(value);
    }

    public void setTransmittanceRangeCutIn(PositiveInteger cutIn, int instrumentIndex, int filterIndex) {
        Filter o2;
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterList() == filterIndex) {
            o1.addFilter(new Filter());
        }
        if ((o2 = o1.getFilter(filterIndex)).getTransmittanceRange() == null) {
            o2.setTransmittanceRange(new TransmittanceRange());
        }
        TransmittanceRange o3 = o2.getTransmittanceRange();
        o3.setCutIn(cutIn);
    }

    public void setTransmittanceRangeCutInTolerance(NonNegativeInteger cutInTolerance, int instrumentIndex, int filterIndex) {
        Filter o2;
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterList() == filterIndex) {
            o1.addFilter(new Filter());
        }
        if ((o2 = o1.getFilter(filterIndex)).getTransmittanceRange() == null) {
            o2.setTransmittanceRange(new TransmittanceRange());
        }
        TransmittanceRange o3 = o2.getTransmittanceRange();
        o3.setCutInTolerance(cutInTolerance);
    }

    public void setTransmittanceRangeCutOut(PositiveInteger cutOut, int instrumentIndex, int filterIndex) {
        Filter o2;
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterList() == filterIndex) {
            o1.addFilter(new Filter());
        }
        if ((o2 = o1.getFilter(filterIndex)).getTransmittanceRange() == null) {
            o2.setTransmittanceRange(new TransmittanceRange());
        }
        TransmittanceRange o3 = o2.getTransmittanceRange();
        o3.setCutOut(cutOut);
    }

    public void setTransmittanceRangeCutOutTolerance(NonNegativeInteger cutOutTolerance, int instrumentIndex, int filterIndex) {
        Filter o2;
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterList() == filterIndex) {
            o1.addFilter(new Filter());
        }
        if ((o2 = o1.getFilter(filterIndex)).getTransmittanceRange() == null) {
            o2.setTransmittanceRange(new TransmittanceRange());
        }
        TransmittanceRange o3 = o2.getTransmittanceRange();
        o3.setCutOutTolerance(cutOutTolerance);
    }

    public void setTransmittanceRangeTransmittance(PercentFraction transmittance, int instrumentIndex, int filterIndex) {
        Filter o2;
        Instrument o1;
        OME o0 = this.root;
        if (o0.sizeOfInstrumentList() == instrumentIndex) {
            o0.addInstrument(new Instrument());
        }
        if ((o1 = o0.getInstrument(instrumentIndex)).sizeOfFilterList() == filterIndex) {
            o1.addFilter(new Filter());
        }
        if ((o2 = o1.getFilter(filterIndex)).getTransmittanceRange() == null) {
            o2.setTransmittanceRange(new TransmittanceRange());
        }
        TransmittanceRange o3 = o2.getTransmittanceRange();
        o3.setTransmittance(transmittance);
    }

    public void setUUIDFileName(String fileName, int imageIndex, int tiffDataIndex) {
        TiffData o3;
        Pixels o2;
        Image o1;
        OME o0 = this.root;
        if (o0.sizeOfImageList() == imageIndex) {
            o0.addImage(new Image());
        }
        if ((o1 = o0.getImage(imageIndex)).getPixels() == null) {
            o1.setPixels(new Pixels());
        }
        if ((o2 = o1.getPixels()).sizeOfTiffDataList() == tiffDataIndex) {
            o2.addTiffData(new TiffData());
        }
        if ((o3 = o2.getTiffData(tiffDataIndex)).getUUID() == null) {
            o3.setUUID(new UUID());
        }
        UUID o4 = o3.getUUID();
        o4.setFileName(fileName);
    }

    public void setWellAnnotationRef(String annotation, int plateIndex, int wellIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getPlate(plateIndex).getWell(wellIndex), annotationLinks_reference);
    }

    public void setWellColor(Color color, int plateIndex, int wellIndex) {
        Plate o1;
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfWellList() == wellIndex) {
            o1.addWell(new Well());
        }
        Well o2 = o1.getWell(wellIndex);
        o2.setColor(color);
    }

    public void setWellColumn(NonNegativeInteger column, int plateIndex, int wellIndex) {
        Plate o1;
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfWellList() == wellIndex) {
            o1.addWell(new Well());
        }
        Well o2 = o1.getWell(wellIndex);
        o2.setColumn(column);
    }

    public void setWellExternalDescription(String externalDescription, int plateIndex, int wellIndex) {
        Plate o1;
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfWellList() == wellIndex) {
            o1.addWell(new Well());
        }
        Well o2 = o1.getWell(wellIndex);
        o2.setExternalDescription(externalDescription);
    }

    public void setWellExternalIdentifier(String externalIdentifier, int plateIndex, int wellIndex) {
        Plate o1;
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfWellList() == wellIndex) {
            o1.addWell(new Well());
        }
        Well o2 = o1.getWell(wellIndex);
        o2.setExternalIdentifier(externalIdentifier);
    }

    public void setWellID(String id, int plateIndex, int wellIndex) {
        Plate o1;
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfWellList() == wellIndex) {
            o1.addWell(new Well());
        }
        Well o2 = o1.getWell(wellIndex);
        this.model.addModelObject(id, o2);
        o2.setID(id);
    }

    public void setWellReagentRef(String reagent, int plateIndex, int wellIndex) {
        ReagentRef reagent_reference = new ReagentRef();
        reagent_reference.setID(reagent);
        this.model.addReference(this.root.getPlate(plateIndex).getWell(wellIndex), reagent_reference);
    }

    public void setWellRow(NonNegativeInteger row, int plateIndex, int wellIndex) {
        Plate o1;
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfWellList() == wellIndex) {
            o1.addWell(new Well());
        }
        Well o2 = o1.getWell(wellIndex);
        o2.setRow(row);
    }

    public void setWellType(String type, int plateIndex, int wellIndex) {
        Plate o1;
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfWellList() == wellIndex) {
            o1.addWell(new Well());
        }
        Well o2 = o1.getWell(wellIndex);
        o2.setType(type);
    }

    public void setWellSampleAnnotationRef(String annotation, int plateIndex, int wellIndex, int wellSampleIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getPlate(plateIndex).getWell(wellIndex).getWellSample(wellSampleIndex), annotationLinks_reference);
    }

    public void setWellSampleID(String id, int plateIndex, int wellIndex, int wellSampleIndex) {
        Well o2;
        Plate o1;
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfWellList() == wellIndex) {
            o1.addWell(new Well());
        }
        if ((o2 = o1.getWell(wellIndex)).sizeOfWellSampleList() == wellSampleIndex) {
            o2.addWellSample(new WellSample());
        }
        WellSample o3 = o2.getWellSample(wellSampleIndex);
        this.model.addModelObject(id, o3);
        o3.setID(id);
    }

    public void setWellSampleImageRef(String image, int plateIndex, int wellIndex, int wellSampleIndex) {
        ImageRef image_reference = new ImageRef();
        image_reference.setID(image);
        this.model.addReference(this.root.getPlate(plateIndex).getWell(wellIndex).getWellSample(wellSampleIndex), image_reference);
    }

    public void setWellSampleIndex(NonNegativeInteger index, int plateIndex, int wellIndex, int wellSampleIndex) {
        Well o2;
        Plate o1;
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfWellList() == wellIndex) {
            o1.addWell(new Well());
        }
        if ((o2 = o1.getWell(wellIndex)).sizeOfWellSampleList() == wellSampleIndex) {
            o2.addWellSample(new WellSample());
        }
        WellSample o3 = o2.getWellSample(wellSampleIndex);
        o3.setIndex(index);
    }

    public void setWellSamplePositionX(Double positionX, int plateIndex, int wellIndex, int wellSampleIndex) {
        Well o2;
        Plate o1;
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfWellList() == wellIndex) {
            o1.addWell(new Well());
        }
        if ((o2 = o1.getWell(wellIndex)).sizeOfWellSampleList() == wellSampleIndex) {
            o2.addWellSample(new WellSample());
        }
        WellSample o3 = o2.getWellSample(wellSampleIndex);
        o3.setPositionX(positionX);
    }

    public void setWellSamplePositionY(Double positionY, int plateIndex, int wellIndex, int wellSampleIndex) {
        Well o2;
        Plate o1;
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfWellList() == wellIndex) {
            o1.addWell(new Well());
        }
        if ((o2 = o1.getWell(wellIndex)).sizeOfWellSampleList() == wellSampleIndex) {
            o2.addWellSample(new WellSample());
        }
        WellSample o3 = o2.getWellSample(wellSampleIndex);
        o3.setPositionY(positionY);
    }

    public void setWellSampleTimepoint(Timestamp timepoint, int plateIndex, int wellIndex, int wellSampleIndex) {
        Well o2;
        Plate o1;
        OME o0 = this.root;
        if (o0.sizeOfPlateList() == plateIndex) {
            o0.addPlate(new Plate());
        }
        if ((o1 = o0.getPlate(plateIndex)).sizeOfWellList() == wellIndex) {
            o1.addWell(new Well());
        }
        if ((o2 = o1.getWell(wellIndex)).sizeOfWellSampleList() == wellSampleIndex) {
            o2.addWellSample(new WellSample());
        }
        WellSample o3 = o2.getWellSample(wellSampleIndex);
        o3.setTimepoint(timepoint);
    }

    public void setXMLAnnotationAnnotationRef(String annotation, int XMLAnnotationIndex, int annotationRefIndex) {
        AnnotationRef annotationLinks_reference = new AnnotationRef();
        annotationLinks_reference.setID(annotation);
        this.model.addReference(this.root.getStructuredAnnotations().getXMLAnnotation(XMLAnnotationIndex), annotationLinks_reference);
    }

    public void setXMLAnnotationDescription(String description, int XMLAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfXMLAnnotationList() == XMLAnnotationIndex) {
            o1.addXMLAnnotation(new XMLAnnotation());
        }
        XMLAnnotation o2 = o1.getXMLAnnotation(XMLAnnotationIndex);
        o2.setDescription(description);
    }

    public void setXMLAnnotationID(String id, int XMLAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfXMLAnnotationList() == XMLAnnotationIndex) {
            o1.addXMLAnnotation(new XMLAnnotation());
        }
        XMLAnnotation o2 = o1.getXMLAnnotation(XMLAnnotationIndex);
        this.model.addModelObject(id, o2);
        o2.setID(id);
    }

    public void setXMLAnnotationNamespace(String namespace, int XMLAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfXMLAnnotationList() == XMLAnnotationIndex) {
            o1.addXMLAnnotation(new XMLAnnotation());
        }
        XMLAnnotation o2 = o1.getXMLAnnotation(XMLAnnotationIndex);
        o2.setNamespace(namespace);
    }

    public void setXMLAnnotationValue(String value, int XMLAnnotationIndex) {
        StructuredAnnotations o1;
        OME o0 = this.root;
        if (o0.getStructuredAnnotations() == null) {
            o0.setStructuredAnnotations(new StructuredAnnotations());
        }
        if ((o1 = o0.getStructuredAnnotations()).sizeOfXMLAnnotationList() == XMLAnnotationIndex) {
            o1.addXMLAnnotation(new XMLAnnotation());
        }
        XMLAnnotation o2 = o1.getXMLAnnotation(XMLAnnotationIndex);
        o2.setValue(value);
    }
}

