/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.collection;

import ch.systemsx.cisd.common.collection.AbstractCollectionDecorator;
import ch.systemsx.cisd.common.collection.IValidator;
import java.util.Collection;
import java.util.Iterator;

public class FilteredCollection<E>
extends AbstractCollectionDecorator<E> {
    protected final IValidator<E> validator;

    public static <E> Collection<E> decorate(Collection<E> coll, IValidator<E> validator) {
        return new FilteredCollection<E>(coll, validator);
    }

    protected FilteredCollection(Collection<E> collection, IValidator<E> validator) {
        super(FilteredCollection.filterCollection(collection, validator));
        assert (validator != null);
        this.validator = validator;
    }

    protected static final <E> Collection<E> filterCollection(Collection<? extends E> collection, IValidator<E> validator) {
        if (collection == null) {
            return null;
        }
        Iterator<E> iter = collection.iterator();
        while (iter.hasNext()) {
            if (validator.isValid(iter.next())) continue;
            iter.remove();
        }
        return collection;
    }

    protected boolean isValid(E object) {
        return this.validator.isValid(object);
    }

    @Override
    public final boolean add(E object) {
        if (this.isValid(object)) {
            return this.getCollection().add(object);
        }
        return false;
    }

    @Override
    public final boolean addAll(Collection<? extends E> collection) {
        boolean changed = false;
        for (E e : collection) {
            if (!this.add(e) || changed) continue;
            changed = true;
        }
        return changed;
    }
}

