/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.common.hdf5;

import ch.systemsx.cisd.openbis.common.hdf5.HDF5Container;
import ch.systemsx.cisd.openbis.common.hdf5.IHDF5ContainerWriter;
import java.io.File;

public class HierarchicalStructureDuplicatorFileToHDF5 {
    private final File file;
    private final String rootPath;
    private final IHDF5ContainerWriter writer;

    public static void makeDuplicate(File file, String rootPath, IHDF5ContainerWriter writer) {
        new HierarchicalStructureDuplicatorFileToHDF5(file, rootPath, writer).makeDuplicate();
    }

    private HierarchicalStructureDuplicatorFileToHDF5(File file, String rootPath, IHDF5ContainerWriter writer) {
        this.file = file;
        this.rootPath = rootPath;
        this.writer = writer;
    }

    private void makeDuplicate() {
        if (!this.file.exists()) {
            throw new IllegalArgumentException("File does not exist " + this.file);
        }
        this.writer.archiveToHDF5Container(this.rootPath, this.file);
    }

    public static class DuplicatorWriterClient
    implements HDF5Container.IHDF5WriterClient {
        private final File file;
        private final String rootPath;

        public DuplicatorWriterClient(File file) {
            this(file, "/");
        }

        public DuplicatorWriterClient(File file, String rootPath) {
            this.file = file;
            this.rootPath = rootPath;
        }

        @Override
        public void runWithSimpleWriter(IHDF5ContainerWriter writer) {
            HierarchicalStructureDuplicatorFileToHDF5.makeDuplicate(this.file, this.rootPath, writer);
        }
    }
}

