/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.coreplugin;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.logging.Log4jSimpleLogger;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.logging.LogLevel;
import ch.systemsx.cisd.common.properties.PropertyParametersUtil;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.shared.basic.string.CommaSeparatedListBuilder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CorePlugin;
import ch.systemsx.cisd.openbis.generic.shared.coreplugin.CorePluginScanner;
import ch.systemsx.cisd.openbis.generic.shared.coreplugin.CorePluginsUtils;
import ch.systemsx.cisd.openbis.generic.shared.coreplugin.IPluginType;
import ch.systemsx.cisd.openbis.generic.shared.coreplugin.ModuleEnabledChecker;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;

public class CorePluginsInjector {
    static final String DELETE_KEY_WORD = "__DELETE__";
    private static final String UNALLOWED_PLUGIN_NAME_CHARACTERS = " ,=";
    static final String DISABLED_CORE_PLUGINS_KEY = "disabled-core-plugins";
    static final String DISABLED_MARKER_FILE_NAME = "disabled";
    static final String PLUGIN_PROPERTIES_FILE_NAME = "plugin.properties";
    private static final ISimpleLogger DEFAULT_LOGGER = new Log4jSimpleLogger(LogFactory.getLogger(LogCategory.OPERATION, CorePluginsInjector.class));
    private final ISimpleLogger logger;
    private final Set<String> keysOfKeyLists;
    private final CorePluginScanner.ScannerType scannerType;
    private final IPluginType[] pluginTypes;

    public CorePluginsInjector(CorePluginScanner.ScannerType scannerType, IPluginType[] pluginTypes) {
        this(scannerType, pluginTypes, DEFAULT_LOGGER);
    }

    CorePluginsInjector(CorePluginScanner.ScannerType scannerType, IPluginType[] pluginTypes, ISimpleLogger logger) {
        this.scannerType = scannerType;
        this.pluginTypes = pluginTypes;
        this.logger = logger;
        this.keysOfKeyLists = new HashSet<String>();
        IPluginType[] iPluginTypeArray = pluginTypes;
        int n = pluginTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginType type = iPluginTypeArray[n2];
            String keyOfKeyListPropertyOrNull = type.getKeyOfKeyListPropertyOrNull();
            if (keyOfKeyListPropertyOrNull != null) {
                this.keysOfKeyLists.add(keyOfKeyListPropertyOrNull);
            }
            ++n2;
        }
    }

    public Map<String, File> injectCorePlugins(Properties properties) {
        String corePluginsFolderPath = CorePluginsUtils.getCorePluginsFolder(properties, this.scannerType);
        return this.injectCorePlugins(properties, corePluginsFolderPath);
    }

    public Map<String, File> injectCorePlugins(Properties properties, String corePluginsFolderPath) {
        ModuleEnabledChecker moduleEnabledChecker = new ModuleEnabledChecker(properties);
        List<String> disabledPlugins = PropertyUtils.getList(properties, DISABLED_CORE_PLUGINS_KEY);
        PluginKeyBundles pluginKeyBundles = new PluginKeyBundles(properties, this.pluginTypes);
        HashSet<String> pluginNames = new HashSet<String>();
        pluginKeyBundles.addAndCheckUniquePluginNames(pluginNames);
        Map<IPluginType, Map<String, NamedCorePluginFolder>> plugins = this.scanForCorePlugins(corePluginsFolderPath, moduleEnabledChecker, disabledPlugins, pluginNames);
        for (Map.Entry<IPluginType, Map<String, NamedCorePluginFolder>> entry : plugins.entrySet()) {
            IPluginType pluginType = entry.getKey();
            Map<String, NamedCorePluginFolder> map = entry.getValue();
            for (Map.Entry<String, NamedCorePluginFolder> entry2 : map.entrySet()) {
                NamedCorePluginFolder plugin = entry2.getValue();
                File definingFolder = plugin.getDefiningFolder();
                if (new File(definingFolder, DISABLED_MARKER_FILE_NAME).exists()) continue;
                String technology = plugin.getTechnology();
                Properties pluginProperties = plugin.getPluginProperties();
                if (pluginType.isUniquePluginNameRequired()) {
                    String pluginKey = pluginType.getPluginKey(technology, plugin.getName(), pluginProperties);
                    pluginKeyBundles.addPluginNameFor(pluginType, pluginKey);
                    String prefix = String.valueOf(pluginType.getPrefix()) + pluginKey + ".";
                    for (Map.Entry<Object, Object> keyValuePair : pluginProperties.entrySet()) {
                        String value = keyValuePair.getValue().toString();
                        this.injectProperty(properties, String.valueOf(prefix) + keyValuePair.getKey(), value);
                    }
                } else {
                    PluginKeyBundles miscPluginKeyBundles = new PluginKeyBundles(pluginProperties, this.pluginTypes);
                    for (Map.Entry<Object, Object> keyValuePair : pluginProperties.entrySet()) {
                        String value = keyValuePair.getValue().toString();
                        String key = keyValuePair.getKey().toString();
                        if (this.keysOfKeyLists.contains(key)) continue;
                        this.injectProperty(properties, key, value);
                    }
                    pluginKeyBundles.add(miscPluginKeyBundles);
                }
                this.logger.log(LogLevel.INFO, "Plugin " + plugin + " added.");
            }
        }
        pluginKeyBundles.addOrReplaceKeyBundleIn(properties);
        HashMap<String, File> pluginFolders = new HashMap<String, File>();
        for (Map<String, NamedCorePluginFolder> map : plugins.values()) {
            for (String name : map.keySet()) {
                pluginFolders.put(name, map.get(name).getDefiningFolder());
            }
        }
        return pluginFolders;
    }

    private void injectProperty(Properties properties, String key, String value) {
        String property = properties.getProperty(key);
        if (property != null && property.trim().equals(DELETE_KEY_WORD)) {
            properties.remove(key);
        } else {
            properties.setProperty(key, value);
        }
    }

    private Map<IPluginType, Map<String, NamedCorePluginFolder>> scanForCorePlugins(String corePluginsFolderPath, ModuleEnabledChecker moduleEnabledChecker, List<String> disabledPlugins, Set<String> pluginNames) {
        LinkedHashMap<IPluginType, Map<String, NamedCorePluginFolder>> typeToPluginsMap = new LinkedHashMap<IPluginType, Map<String, NamedCorePluginFolder>>();
        CorePluginScanner scanner = new CorePluginScanner(corePluginsFolderPath, this.scannerType, this.logger);
        List<CorePlugin> plugins = scanner.scanForPlugins();
        for (CorePlugin corePlugin : plugins) {
            String module = corePlugin.getName();
            if (!moduleEnabledChecker.isModuleEnabled(module)) {
                this.logger.log(LogLevel.INFO, "Core plugins for module '" + module + "' are not enabled.");
                continue;
            }
            IPluginType[] iPluginTypeArray = this.pluginTypes;
            int n = this.pluginTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginType pluginType = iPluginTypeArray[n2];
                File file = new File(corePluginsFolderPath, CorePluginScanner.constructPath(corePlugin, this.scannerType, pluginType));
                if (file.isDirectory()) {
                    File[] pluginFolders;
                    File[] fileArray = pluginFolders = file.listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return !name.startsWith(".");
                        }
                    });
                    int n3 = pluginFolders.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File pluginFolder = fileArray[n4];
                        String pluginName = pluginFolder.getName();
                        NamedCorePluginFolder plugin = new NamedCorePluginFolder(module, pluginType, pluginFolder);
                        String fullPluginName = plugin.getFullPluginName();
                        if (!this.isDisabled(disabledPlugins, fullPluginName)) {
                            String fullPluginKey = String.valueOf(pluginType.getPrefix()) + pluginType.getPluginKey(module, pluginName, plugin.getPluginProperties());
                            this.assertAndAddPluginName(fullPluginKey, pluginNames, pluginType);
                            LinkedHashMap<String, NamedCorePluginFolder> map = (LinkedHashMap<String, NamedCorePluginFolder>)typeToPluginsMap.get(pluginType);
                            if (map == null) {
                                map = new LinkedHashMap<String, NamedCorePluginFolder>();
                                typeToPluginsMap.put(pluginType, map);
                            }
                            map.put(fullPluginKey, plugin);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return typeToPluginsMap;
    }

    private boolean isDisabled(List<String> disabledPlugins, String fullPluginName) {
        for (String disabledPlugin : disabledPlugins) {
            if (!fullPluginName.startsWith(disabledPlugin)) continue;
            return true;
        }
        return false;
    }

    private void assertAndAddPluginName(String pluginName, Set<String> pluginNames, IPluginType pluginType) {
        int i = 0;
        while (i < UNALLOWED_PLUGIN_NAME_CHARACTERS.length()) {
            char c = UNALLOWED_PLUGIN_NAME_CHARACTERS.charAt(i);
            if (pluginName.contains(Character.toString(c))) {
                throw new EnvironmentFailureException("Plugin name contains '" + c + "': " + pluginName);
            }
            ++i;
        }
        if (pluginType.isUniquePluginNameRequired()) {
            if (pluginNames.contains(pluginName)) {
                throw new ConfigurationFailureException("There is already a plugin named '" + pluginName + "'.");
            }
            pluginNames.add(pluginName);
        }
    }

    private static final class KeyBundle {
        private final String key;
        private final Set<String> keys;
        private final String prefix;

        KeyBundle(Properties properties, String prefix, String key) {
            this.prefix = prefix;
            this.key = key;
            this.keys = new TreeSet<String>();
            String keysAsString = properties.getProperty(key);
            if (keysAsString != null) {
                String[] keyArray = PropertyParametersUtil.parseItemisedProperty(keysAsString, key);
                this.keys.addAll(Arrays.asList(keyArray));
            }
        }

        public void addKey(String newKey) {
            this.keys.add(newKey);
        }

        void addAndCheckUniquePluginNames(Set<String> pluginNames) {
            for (String keyPrefix : this.keys) {
                String fullPrefix = String.valueOf(this.prefix) + keyPrefix;
                if (pluginNames.contains(fullPrefix)) {
                    throw new ConfigurationFailureException("Property key '" + fullPrefix + "' for key list '" + this.key + "' is already defined in some other key list.");
                }
                pluginNames.add(fullPrefix);
            }
        }

        void addOrReplaceKeyBundleIn(Properties properties) {
            if (!this.keys.isEmpty()) {
                CommaSeparatedListBuilder builder = new CommaSeparatedListBuilder();
                for (String k : this.keys) {
                    builder.append(k);
                }
                properties.setProperty(this.key, builder.toString());
            }
        }
    }

    private static final class NamedCorePluginFolder {
        private final String fullPluginName;
        private final File definingFolder;
        private final String technology;
        private final String name;
        private Properties pluginProperties;

        NamedCorePluginFolder(String technology, IPluginType pluginType, File definingFolder) {
            this.technology = technology;
            this.name = definingFolder.getName();
            this.fullPluginName = String.valueOf(technology) + ":" + pluginType.getSubFolderName() + ":" + this.name;
            this.definingFolder = definingFolder;
            if (!definingFolder.isDirectory()) {
                throw new EnvironmentFailureException("Is not a directory: " + definingFolder);
            }
            this.pluginProperties = this.getPluginProperties(definingFolder);
        }

        String getTechnology() {
            return this.technology;
        }

        String getName() {
            return this.name;
        }

        String getFullPluginName() {
            return this.fullPluginName;
        }

        File getDefiningFolder() {
            return this.definingFolder;
        }

        Properties getPluginProperties() {
            return this.pluginProperties;
        }

        public String toString() {
            return String.valueOf(this.fullPluginName) + " [" + this.definingFolder + "]";
        }

        private Properties getPluginProperties(File folder) {
            File pluginPropertiesFile = new File(folder, CorePluginsInjector.PLUGIN_PROPERTIES_FILE_NAME);
            if (!pluginPropertiesFile.exists()) {
                throw new EnvironmentFailureException("Missing plugin properties: " + pluginPropertiesFile);
            }
            File[] scripts = folder.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String fileName) {
                    return !fileName.equals(CorePluginsInjector.PLUGIN_PROPERTIES_FILE_NAME);
                }
            });
            Properties properties = this.loadProperties(pluginPropertiesFile);
            for (Map.Entry<Object, Object> keyValuePair : properties.entrySet()) {
                String value = keyValuePair.getValue().toString();
                File[] fileArray = scripts;
                int n = scripts.length;
                int n2 = 0;
                while (n2 < n) {
                    File script = fileArray[n2];
                    value = value.replace(script.getName(), script.getPath());
                    ++n2;
                }
                keyValuePair.setValue(value);
            }
            return properties;
        }

        private Properties loadProperties(File pluginPropertiesFile) {
            Properties properties = new Properties();
            FileInputStream inStream = null;
            try {
                try {
                    inStream = new FileInputStream(pluginPropertiesFile);
                    properties.load(inStream);
                }
                catch (IOException ex) {
                    throw new EnvironmentFailureException("Couldn't load plugin properties '" + pluginPropertiesFile + "'.", ex);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inStream);
            return properties;
        }
    }

    private static final class PluginKeyBundles {
        private Map<IPluginType, KeyBundle> keyBundles = new LinkedHashMap<IPluginType, KeyBundle>();

        PluginKeyBundles(Properties properties, IPluginType[] pluginTypes) {
            IPluginType[] iPluginTypeArray = pluginTypes;
            int n = pluginTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginType pluginType = iPluginTypeArray[n2];
                String key = pluginType.getKeyOfKeyListPropertyOrNull();
                if (key != null) {
                    this.keyBundles.put(pluginType, new KeyBundle(properties, pluginType.getPrefix(), key));
                }
                ++n2;
            }
        }

        public void add(PluginKeyBundles bundles) {
            Set<Map.Entry<IPluginType, KeyBundle>> entrySet = this.keyBundles.entrySet();
            for (Map.Entry<IPluginType, KeyBundle> entry : entrySet) {
                IPluginType pluginType = entry.getKey();
                KeyBundle keyBundle = bundles.keyBundles.get(pluginType);
                if (keyBundle == null) continue;
                entry.getValue().keys.addAll(keyBundle.keys);
            }
        }

        void addAndCheckUniquePluginNames(Set<String> pluginNames) {
            for (KeyBundle keyBundle : this.keyBundles.values()) {
                keyBundle.addAndCheckUniquePluginNames(pluginNames);
            }
        }

        void addPluginNameFor(IPluginType pluginType, String pluginKey) {
            KeyBundle keyBundle = this.keyBundles.get(pluginType);
            if (keyBundle != null) {
                keyBundle.addKey(pluginKey);
            }
        }

        void addOrReplaceKeyBundleIn(Properties properties) {
            for (KeyBundle bundle : this.keyBundles.values()) {
                bundle.addOrReplaceKeyBundleIn(properties);
            }
        }
    }
}

