/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.translator;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleTypePE;
import ch.systemsx.cisd.openbis.generic.shared.translator.DataSetTypeTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.ExperimentTypeTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.MaterialTypeTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.SampleTypeTranslator;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.util.HashMap;

public class EntityTypeTranslator {
    public static EntityType translate(EntityTypePE entityTypePE) {
        if (entityTypePE == null) {
            return null;
        }
        HashMap<PropertyTypePE, PropertyType> cache = new HashMap<PropertyTypePE, PropertyType>();
        switch (entityTypePE.getEntityKind()) {
            case EXPERIMENT: {
                ExperimentTypePE experimentTypePE = (ExperimentTypePE)entityTypePE;
                HibernateUtils.initialize(experimentTypePE.getExperimentTypePropertyTypes());
                return ExperimentTypeTranslator.translate(experimentTypePE, cache);
            }
            case SAMPLE: {
                SampleTypePE sampleTypePE = (SampleTypePE)entityTypePE;
                HibernateUtils.initialize(sampleTypePE.getSampleTypePropertyTypes());
                return SampleTypeTranslator.translate(sampleTypePE, cache);
            }
            case DATA_SET: {
                DataSetTypePE dataSetTypePE = (DataSetTypePE)entityTypePE;
                HibernateUtils.initialize(dataSetTypePE.getDataSetTypePropertyTypes());
                return DataSetTypeTranslator.translate(dataSetTypePE, cache);
            }
            case MATERIAL: {
                MaterialTypePE materialTypePE = (MaterialTypePE)entityTypePE;
                HibernateUtils.initialize(materialTypePE.getMaterialTypePropertyTypes());
                return MaterialTypeTranslator.translate(materialTypePE, cache);
            }
        }
        throw new IllegalArgumentException("Unsupported entity kind: " + (Object)((Object)entityTypePE.getEntityKind()));
    }
}

