/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.tools;

import java.awt.image.BufferedImage;

public class AsciiImage {
    private static final String NL = System.getProperty("line.separator");
    private static final String CHARS = " .,-+o*O#";
    private BufferedImage img;

    public AsciiImage(BufferedImage img) {
        this.img = img;
    }

    public String toString() {
        int width = this.img.getWidth();
        int height = this.img.getHeight();
        StringBuilder sb = new StringBuilder();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int pix = this.img.getRGB(x, y);
                int a = 0xFF & pix >> 24;
                int r = 0xFF & pix >> 16;
                int g = 0xFF & pix >> 8;
                int b = 0xFF & pix;
                int avg = (r + g + b) / 3;
                sb.append(this.getChar(avg));
            }
            sb.append(NL);
        }
        return sb.toString();
    }

    private char getChar(int value) {
        int index = CHARS.length() * value / 256;
        return CHARS.charAt(index);
    }
}

