/*
 * Decompiled with CFR 0.152.
 */
package net.lemnik.eodsql.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import javax.sql.DataSource;
import net.lemnik.eodsql.BaseQuery;
import net.lemnik.eodsql.EoDException;
import net.lemnik.eodsql.TransactionQuery;
import net.lemnik.eodsql.impl.BaseQueryImpl;
import net.lemnik.eodsql.spi.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TransactionQueryImpl
extends BaseQueryImpl {
    final boolean noAutoClose;

    public TransactionQueryImpl(Connection connection, Class<? extends BaseQuery> clazz) {
        super(new BaseQueryImpl.SingleConnectionSource(connection), clazz, TransactionQuery.class);
        this.noAutoClose = false;
        this.addTransactionMethods();
        try {
            connection.setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            throw new EoDException("Cannot set auto-commit on Connection", sQLException);
        }
    }

    public TransactionQueryImpl(DataSource dataSource, Class<? extends BaseQuery> clazz) {
        super(new BaseQueryImpl.DataSourceConnectionSource(dataSource, false), clazz, TransactionQuery.class);
        this.noAutoClose = true;
        this.addTransactionMethods();
    }

    @Override
    protected Context<Annotation> createContext(Annotation annotation, Class<?> clazz, Object[] objectArray) {
        Context<Annotation> context = new Context<Annotation>(annotation, clazz, objectArray);
        if (this.noAutoClose) {
            context.setDontCloseConnection(true);
        }
        return context;
    }

    protected void commit() throws SQLException {
        Connection connection = this.connectionSource.getConnection();
        connection.commit();
        this.connectionSource.releaseConnection(connection);
    }

    protected void rollback() throws SQLException {
        Connection connection = this.connectionSource.getConnection();
        connection.rollback();
        this.connectionSource.releaseConnection(connection);
    }

    protected void rollback(Savepoint savepoint) throws SQLException {
        Connection connection = this.connectionSource.getConnection();
        connection.rollback(savepoint);
        this.connectionSource.releaseConnection(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Savepoint setSavepoint() throws SQLException {
        Connection connection = this.connectionSource.getConnection();
        try {
            Savepoint savepoint = connection.setSavepoint();
            return savepoint;
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Savepoint setSavepoint(String string) throws SQLException {
        Connection connection = this.connectionSource.getConnection();
        try {
            Savepoint savepoint = connection.setSavepoint(string);
            return savepoint;
        }
        finally {
            this.connectionSource.releaseConnection(connection);
        }
    }

    protected void addTransactionMethods() {
        try {
            InvokeRollback invokeRollback = new InvokeRollback();
            InvokeSetSavepoint invokeSetSavepoint = new InvokeSetSavepoint();
            this.methods.put(TransactionQuery.class.getMethod("commit", new Class[0]), new InvokeCommit());
            this.methods.put(TransactionQuery.class.getMethod("close", Boolean.TYPE), new InvokeCommitClose());
            this.methods.put(TransactionQuery.class.getMethod("rollback", new Class[0]), invokeRollback);
            this.methods.put(TransactionQuery.class.getMethod("rollback", Savepoint.class), invokeRollback);
            this.methods.put(TransactionQuery.class.getMethod("setSavepoint", new Class[0]), invokeSetSavepoint);
            this.methods.put(TransactionQuery.class.getMethod("setSavepoint", String.class), invokeSetSavepoint);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    class InvokeSetSavepoint
    implements BaseQueryImpl.Callable {
        InvokeSetSavepoint() {
        }

        public Object invoke(Method method, Object[] objectArray) throws Throwable {
            if (objectArray == null || objectArray.length == 0) {
                return TransactionQueryImpl.this.setSavepoint();
            }
            return TransactionQueryImpl.this.setSavepoint((String)objectArray[0]);
        }
    }

    class InvokeRollback
    implements BaseQueryImpl.Callable {
        InvokeRollback() {
        }

        public Object invoke(Method method, Object[] objectArray) throws Throwable {
            if (objectArray == null || objectArray.length == 0) {
                TransactionQueryImpl.this.rollback();
            } else {
                TransactionQueryImpl.this.rollback((Savepoint)objectArray[0]);
            }
            return null;
        }
    }

    class InvokeCommitClose
    implements BaseQueryImpl.Callable {
        InvokeCommitClose() {
        }

        public Object invoke(Method method, Object[] objectArray) throws Throwable {
            Boolean bl = (Boolean)objectArray[0];
            if (bl.equals(Boolean.TRUE)) {
                TransactionQueryImpl.this.commit();
            }
            TransactionQueryImpl.this.close();
            return null;
        }
    }

    class InvokeCommit
    implements BaseQueryImpl.Callable {
        InvokeCommit() {
        }

        public Object invoke(Method method, Object[] objectArray) throws Throwable {
            TransactionQueryImpl.this.commit();
            return null;
        }
    }
}

