/*
 * Decompiled with CFR 0.152.
 */
package net.lemnik.eodsql.spi.util;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import net.lemnik.eodsql.DataSet;
import net.lemnik.eodsql.DataSetCache;
import net.lemnik.eodsql.spi.Context;
import net.lemnik.eodsql.spi.Resource;
import net.lemnik.eodsql.spi.util.DataObjectBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConnectedDataSet<T>
implements DataSet<T> {
    protected final Context context;
    protected final ResultSet results;
    protected final DataObjectBinding<T> binding;
    protected DataSetCache<T> cache;
    private Integer size = null;
    private boolean disconnected = false;

    public ConnectedDataSet(DataObjectBinding<T> binding, Context<?> context, DataSetCache<T> cache) {
        this.binding = binding;
        this.context = context;
        this.cache = cache;
        Resource<ResultSet> resultsResource = context.getResource(ResultSet.class);
        this.results = resultsResource.get();
        cache.init(this);
    }

    protected void setSize(Integer size) {
        this.size = size;
    }

    @Override
    public void close() {
        try {
            if (!this.disconnected) {
                this.cache.destroy();
                this.cache = null;
                this.context.close();
                this.disconnected = true;
            }
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public boolean isConnected() {
        return !this.disconnected;
    }

    @Override
    public void disconnect() {
        if (!this.disconnected) {
            try {
                List<T> tmp = this.getArrayList(false);
                this.setSize(tmp.size());
                this.close();
                this.disconnected = true;
                this.cache = new HardDataSetCache(tmp);
            }
            catch (SQLException sqle) {
                throw new RuntimeException(sqle);
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public T get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        Object value = null;
        if (this.cache.isCached(index)) {
            value = this.cache.getObject(index);
        }
        if (value == null) {
            try {
                if (!this.results.absolute(index + 1)) {
                    throw new IndexOutOfBoundsException("Index out of bounds: " + index);
                }
                value = this.binding.unmarshall(this.results);
                this.cache.setObject(index, value);
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        }
        return value;
    }

    @Override
    public Iterator<T> iterator() {
        return new IteratorImpl(0);
    }

    @Override
    public ListIterator<T> listIterator() {
        return new IteratorImpl(0);
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new IteratorImpl(index);
    }

    private List<T> getArrayList(boolean addToCache) throws SQLException {
        if (this.cache instanceof HardDataSetCache) {
            return ((HardDataSetCache)this.cache).cache;
        }
        this.results.beforeFirst();
        ArrayList tmp = new ArrayList();
        int row = 0;
        while (this.results.next()) {
            Object value = null;
            if (this.cache.isCached(row)) {
                value = this.cache.getObject(row);
            }
            if (value == null) {
                value = this.binding.unmarshall(this.results);
                if (addToCache) {
                    this.cache.setObject(row, value);
                }
            }
            tmp.add(value);
            ++row;
        }
        tmp.trimToSize();
        return tmp;
    }

    @Override
    public boolean contains(Object o) {
        if (o != null) {
            for (T v : this) {
                if (!o.equals(v)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int indexOf(Object o) {
        if (o != null) {
            int index = 0;
            for (T v : this) {
                if (o.equals(v)) {
                    return index;
                }
                ++index;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (o != null) {
            try {
                this.results.afterLast();
                int index = this.results.getRow();
                while (this.results.previous()) {
                    Object value = null;
                    if (this.cache.isCached(--index)) {
                        value = this.cache.getObject(index);
                    }
                    if (value == null) {
                        this.binding.unmarshall(this.results);
                        this.cache.setObject(index, value);
                    }
                    if (o != value && !o.equals(value)) continue;
                    return index;
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        }
        return -1;
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        if (fromIndex < toIndex && fromIndex >= 0 && toIndex < this.size()) {
            return new SubList(fromIndex, toIndex);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> e = c.iterator();
        while (e.hasNext()) {
            if (this.contains(e.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int size() {
        if (this.size == null) {
            try {
                this.results.last();
                this.size = this.results.getRow();
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.size;
    }

    @Override
    public Object[] toArray() {
        this.disconnect();
        try {
            return this.getArrayList(false).toArray();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.disconnect();
        try {
            return this.getArrayList(false).toArray(a);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(T e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SubList
    extends AbstractList<T> {
        private final int from;
        private final int to;

        private SubList(int from, int to) {
            this.from = from;
            this.to = to;
        }

        @Override
        public T get(int index) {
            int row = index + this.from;
            if (row >= this.from && row < this.to) {
                return ConnectedDataSet.this.get(row);
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int size() {
            return this.to - this.from;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HardDataSetCache<T>
    implements DataSetCache<T> {
        private final List<T> cache;

        private HardDataSetCache(List<T> cache) {
            this.cache = cache;
        }

        @Override
        public void init(DataSet<T> dataSet) {
        }

        @Override
        public boolean isCached(int row) {
            return row < this.cache.size();
        }

        @Override
        public T getObject(int row) {
            return this.cache.get(row);
        }

        @Override
        public void setObject(int row, T object) {
        }

        @Override
        public void destroy() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IteratorImpl
    implements ListIterator<T> {
        private int cursor = 0;

        IteratorImpl(int start) {
            this.cursor = start;
        }

        @Override
        public boolean hasNext() {
            if (ConnectedDataSet.this.isEmpty()) {
                return false;
            }
            return this.cursor < ConnectedDataSet.this.size();
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                return ConnectedDataSet.this.get(this.cursor++);
            }
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0 && !ConnectedDataSet.this.isEmpty();
        }

        @Override
        public T previous() {
            if (this.hasPrevious()) {
                return ConnectedDataSet.this.get(--this.cursor);
            }
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void remove() {
            ConnectedDataSet.this.remove(this.previousIndex());
        }

        @Override
        public void set(T e) {
            ConnectedDataSet.this.set(this.previousIndex(), e);
        }

        @Override
        public void add(T e) {
            ConnectedDataSet.this.add(this.previousIndex(), e);
        }
    }
}

