/*
 * Decompiled with CFR 0.152.
 */
package net.lemnik.eodsql.spi.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.lemnik.eodsql.DataIterator;
import net.lemnik.eodsql.InvalidDataTypeException;
import net.lemnik.eodsql.InvalidQueryException;
import net.lemnik.eodsql.spi.Context;
import net.lemnik.eodsql.spi.util.AbstractResultSetWrapper;
import net.lemnik.eodsql.spi.util.DataObjectBinding;
import net.lemnik.eodsql.spi.util.DefaultDataIterator;
import net.lemnik.eodsql.spi.util.ResultSetWrapper;
import net.lemnik.eodsql.spi.util.RubberstampingDataIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataIteratorWrapper
extends ResultSetWrapper<DataIterator<?>> {
    public static final String PARAMETER_RUBBERSTAMP = "net.elmnik.eodsql.spi.util.DataIteratorWrapper#rubberstamp";
    private boolean rubberstamping = false;
    private DataObjectBinding<?> binding;

    private DataIteratorWrapper(DataObjectBinding<?> dataObjectBinding, Map<String, Object> map) {
        this.binding = dataObjectBinding;
        this.rubberstamping = DataIteratorWrapper.isRubberstamping(map);
    }

    private static boolean isRubberstamping(Map<String, Object> map) {
        return map.containsKey(PARAMETER_RUBBERSTAMP) && map.get(PARAMETER_RUBBERSTAMP).equals(Boolean.TRUE);
    }

    @Override
    public DataIterator<?> wrap(Context<?> context) throws SQLException {
        context.setAutoclose(false);
        if (this.rubberstamping) {
            RubberstampingDataIterator rubberstampingDataIterator = new RubberstampingDataIterator(context, this.binding);
            return rubberstampingDataIterator;
        }
        DefaultDataIterator defaultDataIterator = new DefaultDataIterator(context, this.binding);
        return defaultDataIterator;
    }

    @Override
    public int getPreferredResultSetType() {
        return 1003;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Factory
    implements ResultSetWrapper.Factory {
        private static final Set<Class> DATA_ITERATOR_TYPE = Collections.singleton(DataIterator.class);

        Factory() {
        }

        @Override
        public boolean isTypeConstructable(Type type, Map<String, Object> map) throws InvalidQueryException {
            DataObjectBinding<?> dataObjectBinding;
            Class<?> clazz = AbstractResultSetWrapper.getDataObjectClass(type, DATA_ITERATOR_TYPE);
            if (clazz == null) {
                return false;
            }
            if (DataIteratorWrapper.isRubberstamping(map) && !(dataObjectBinding = DataObjectBinding.getDataObjectBinding(clazz, AbstractResultSetWrapper.getBindingType(map))).isRubberstampCapable()) {
                throw new InvalidDataTypeException("DataIterator is rubberstamping, but the data-type is notable to rubberstamp.", clazz);
            }
            return true;
        }

        @Override
        public ResultSetWrapper create(Type type, Map<String, Object> map) {
            DataObjectBinding dataObjectBinding;
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class<?> clazz = ResultSetWrapper.toClass(parameterizedType.getActualTypeArguments()[0]);
            if (map.containsKey("net.lemnik.eodsql.spi.util.ResultSetWrapper#binding")) {
                DataObjectBinding dataObjectBinding2 = (DataObjectBinding)map.get("net.lemnik.eodsql.spi.util.ResultSetWrapper#binding");
                dataObjectBinding2.setObjectType(clazz);
                dataObjectBinding = dataObjectBinding2;
            } else {
                dataObjectBinding = DataObjectBinding.getDataObjectBinding(clazz, AbstractResultSetWrapper.getBindingType(map));
            }
            return new DataIteratorWrapper(dataObjectBinding, map);
        }
    }
}

