/*
 * Decompiled with CFR 0.152.
 */
package net.lemnik.eodsql.spi.util;

import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import net.lemnik.eodsql.EoDException;
import net.lemnik.eodsql.InvalidDataTypeException;
import net.lemnik.eodsql.spi.util.DataObjectBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapDataObjectBinding
extends DataObjectBinding<Map<String, Object>> {
    @Override
    protected void setObjectType(Class<Map<String, Object>> clazz) {
        if (!Map.class.isAssignableFrom(clazz)) {
            throw new InvalidDataTypeException(clazz);
        }
    }

    @Override
    public Class<Map<String, Object>> getObjectType() {
        return MapDataObjectBinding.getStringObjectMapObjectType();
    }

    public static Class<Map<String, Object>> getStringObjectMapObjectType() {
        return HashMap.class;
    }

    @Override
    public Map<String, Object> newInstance() throws EoDException {
        return new HashMap<String, Object>();
    }

    @Override
    public void marshall(Map<String, Object> map, ResultSet resultSet) throws SQLException, EoDException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            int n = resultSet.findColumn(entry.getKey());
            int n2 = resultSetMetaData.getColumnType(n);
            if (entry.getValue() == null) {
                resultSet.updateNull(n);
                continue;
            }
            switch (n2) {
                case -7: 
                case 16: {
                    resultSet.updateBoolean(n, (boolean)((Boolean)entry.getValue()));
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    resultSet.updateString(n, entry.getValue().toString());
                    break;
                }
                case 91: {
                    resultSet.updateDate(n, new Date(((java.util.Date)entry.getValue()).getTime()));
                    break;
                }
                case 92: {
                    resultSet.updateTime(n, new Time(((java.util.Date)entry.getValue()).getTime()));
                    break;
                }
                case 93: {
                    resultSet.updateTimestamp(n, new Timestamp(((java.util.Date)entry.getValue()).getTime()));
                    break;
                }
                case 2: 
                case 3: {
                    resultSet.updateBigDecimal(n, (BigDecimal)entry.getValue());
                    break;
                }
                case 7: {
                    resultSet.updateFloat(n, ((Float)entry.getValue()).floatValue());
                    break;
                }
                case 6: 
                case 8: {
                    resultSet.updateDouble(n, (double)((Double)entry.getValue()));
                    break;
                }
                case -6: {
                    resultSet.updateByte(n, (byte)((Byte)entry.getValue()));
                    break;
                }
                case 5: {
                    resultSet.updateShort(n, (short)((Short)entry.getValue()));
                    break;
                }
                case 4: {
                    resultSet.updateInt(n, (int)((Integer)entry.getValue()));
                    break;
                }
                case -5: {
                    resultSet.updateLong(n, (long)((Long)entry.getValue()));
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    resultSet.updateBytes(n, (byte[])entry.getValue());
                    break;
                }
                case 2000: {
                    resultSet.updateObject(n, entry.getValue());
                    break;
                }
                case 2003: {
                    resultSet.updateArray(n, (Array)entry.getValue());
                }
            }
        }
    }

    @Override
    public void unmarshall(ResultSet resultSet, Map<String, Object> map) throws SQLException, EoDException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            int n = resultSetMetaData.getColumnType(i);
            String string = resultSetMetaData.getColumnName(i).toLowerCase();
            switch (n) {
                case -7: 
                case 16: {
                    map.put(string, resultSet.getBoolean(i));
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    map.put(string, resultSet.getString(i));
                    break;
                }
                case 91: {
                    map.put(string, resultSet.getDate(i));
                    break;
                }
                case 92: {
                    map.put(string, resultSet.getTime(i));
                    break;
                }
                case 93: {
                    map.put(string, resultSet.getTimestamp(i));
                    break;
                }
                case 2: 
                case 3: {
                    map.put(string, resultSet.getBigDecimal(i));
                    break;
                }
                case 7: {
                    map.put(string, Float.valueOf(resultSet.getFloat(i)));
                    break;
                }
                case 6: 
                case 8: {
                    map.put(string, resultSet.getDouble(i));
                    break;
                }
                case -6: {
                    map.put(string, resultSet.getByte(i));
                    break;
                }
                case 5: {
                    map.put(string, resultSet.getShort(i));
                    break;
                }
                case 4: {
                    map.put(string, resultSet.getInt(i));
                    break;
                }
                case -5: {
                    map.put(string, resultSet.getLong(i));
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    map.put(string, resultSet.getBytes(i));
                    break;
                }
                case 2000: {
                    map.put(string, resultSet.getObject(i));
                    break;
                }
                case 2003: {
                    map.put(string, resultSet.getArray(i));
                }
            }
            if (!resultSet.wasNull()) continue;
            map.put(string, null);
        }
    }
}

