/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.authentication.stacked;

import ch.systemsx.cisd.authentication.IAuthenticationService;
import ch.systemsx.cisd.authentication.Principal;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import java.util.ArrayList;
import java.util.List;

public class StackedAuthenticationService
implements IAuthenticationService {
    private final List<IAuthenticationService> delegates;
    private final boolean remote;
    private final boolean supportsListingByUserId;
    private final boolean supportsListingByEmail;
    private final boolean supportsListingByLastName;

    public StackedAuthenticationService(List<IAuthenticationService> authenticationServices) {
        this.delegates = authenticationServices;
        boolean foundRemote = false;
        boolean foundSupportsListingByUserId = false;
        boolean foundSupportsListingByEmail = false;
        boolean foundSupportsListingByLastName = false;
        for (IAuthenticationService service : this.delegates) {
            foundRemote |= service.isRemote();
            foundSupportsListingByUserId |= service.supportsListingByUserId();
            foundSupportsListingByEmail |= service.supportsListingByEmail();
            foundSupportsListingByLastName |= service.supportsListingByLastName();
        }
        this.remote = foundRemote;
        this.supportsListingByUserId = foundSupportsListingByUserId;
        this.supportsListingByEmail = foundSupportsListingByEmail;
        this.supportsListingByLastName = foundSupportsListingByLastName;
    }

    @Override
    public String authenticateApplication() {
        return "DUMMY-TOKEN";
    }

    @Override
    public boolean authenticateUser(String dummyToken, String user, String password) {
        return this.authenticateUser(user, password);
    }

    @Override
    public boolean authenticateUser(String user, String password) {
        Principal principalOrNull = this.tryGetAndAuthenticateUser(user, password);
        return Principal.isAuthenticated(principalOrNull);
    }

    @Override
    public Principal getPrincipal(String dummyToken, String user) throws IllegalArgumentException {
        return this.getPrincipal(user);
    }

    @Override
    public Principal getPrincipal(String user) throws IllegalArgumentException {
        Principal principalOrNull = this.tryGetAndAuthenticateUser(user, null);
        if (principalOrNull == null) {
            throw new IllegalArgumentException("Cannot find user '" + user + "'.");
        }
        return principalOrNull;
    }

    @Override
    public Principal tryGetAndAuthenticateUser(String dummyToken, String user, String passwordOrNull) {
        return this.tryGetAndAuthenticateUser(user, passwordOrNull);
    }

    @Override
    public Principal tryGetAndAuthenticateUser(String user, String passwordOrNull) {
        for (IAuthenticationService service : this.delegates) {
            Principal principal = service.tryGetAndAuthenticateUser(user, passwordOrNull);
            if (principal == null) continue;
            return principal;
        }
        return null;
    }

    @Override
    public Principal tryGetAndAuthenticateUserByEmail(String applicationToken, String email, String passwordOrNull) {
        return this.tryGetAndAuthenticateUserByEmail(email, passwordOrNull);
    }

    @Override
    public Principal tryGetAndAuthenticateUserByEmail(String email, String passwordOrNull) {
        for (IAuthenticationService service : this.delegates) {
            Principal principal;
            if (!service.supportsListingByEmail() || (principal = service.tryGetAndAuthenticateUserByEmail(email, passwordOrNull)) == null) continue;
            return principal;
        }
        return null;
    }

    @Override
    public List<Principal> listPrincipalsByEmail(String applicationToken, String emailQuery) {
        return this.listPrincipalsByEmail(emailQuery);
    }

    @Override
    public List<Principal> listPrincipalsByEmail(String emailQuery) {
        if (!this.supportsListingByEmail) {
            throw new UnsupportedOperationException();
        }
        ArrayList<Principal> principals = new ArrayList<Principal>();
        for (IAuthenticationService service : this.delegates) {
            if (!service.supportsListingByEmail()) continue;
            principals.addAll(service.listPrincipalsByEmail(emailQuery));
        }
        return principals;
    }

    @Override
    public List<Principal> listPrincipalsByLastName(String applicationToken, String lastNameQuery) {
        return this.listPrincipalsByLastName(lastNameQuery);
    }

    @Override
    public List<Principal> listPrincipalsByLastName(String lastNameQuery) {
        if (!this.supportsListingByLastName) {
            throw new UnsupportedOperationException();
        }
        ArrayList<Principal> principals = new ArrayList<Principal>();
        for (IAuthenticationService service : this.delegates) {
            if (!service.supportsListingByLastName()) continue;
            principals.addAll(service.listPrincipalsByLastName(lastNameQuery));
        }
        return principals;
    }

    @Override
    public List<Principal> listPrincipalsByUserId(String applicationToken, String userIdQuery) {
        return this.listPrincipalsByUserId(userIdQuery);
    }

    @Override
    public List<Principal> listPrincipalsByUserId(String userIdQuery) {
        if (!this.supportsListingByUserId) {
            throw new UnsupportedOperationException();
        }
        ArrayList<Principal> principals = new ArrayList<Principal>();
        for (IAuthenticationService service : this.delegates) {
            if (!service.supportsListingByUserId()) continue;
            principals.addAll(service.listPrincipalsByUserId(userIdQuery));
        }
        return principals;
    }

    @Override
    public boolean supportsListingByEmail() {
        return this.supportsListingByEmail;
    }

    @Override
    public boolean supportsListingByLastName() {
        return this.supportsListingByLastName;
    }

    @Override
    public boolean supportsListingByUserId() {
        return this.supportsListingByUserId;
    }

    @Override
    public void check() throws EnvironmentFailureException, ConfigurationFailureException {
        for (IAuthenticationService service : this.delegates) {
            service.check();
        }
    }

    @Override
    public boolean isRemote() {
        return this.remote;
    }
}

