/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.client.application;

import ch.systemsx.cisd.cifex.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.cifex.client.application.FileShareUserGridCellListener;
import ch.systemsx.cisd.cifex.client.application.UserUtils;
import ch.systemsx.cisd.cifex.client.application.ViewContext;
import ch.systemsx.cisd.cifex.client.application.grid.GridWidget;
import ch.systemsx.cisd.cifex.client.application.model.AbstractUserGridModel;
import ch.systemsx.cisd.cifex.client.application.model.FileShareUserGridModel;
import ch.systemsx.cisd.cifex.client.application.page.AbstractMainPageTabController;
import ch.systemsx.cisd.cifex.client.application.ui.DefaultLayoutDialog;
import ch.systemsx.cisd.cifex.client.application.utils.CifexValidator;
import ch.systemsx.cisd.cifex.client.application.utils.MessageDictionary;
import ch.systemsx.cisd.cifex.shared.basic.dto.UserInfoDTO;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;

abstract class AbstractFileShareUserDialog
extends DefaultLayoutDialog {
    private static final int USER_GRID_HEIGHT = 150;
    private static final int DIALOG_HEIGHT = 577;
    private static final int DIALOG_WIDTH = 980;
    private static final String EMAIL_FIELD_CONFIG = "EMAIL";
    protected final List<UserInfoDTO> existingUsers;
    protected final List<UserInfoDTO> newUsers;
    protected final ViewContext viewContext;
    protected final GridWidget<FileShareUserGridModel> existingUserGrid;
    protected final GridWidget<FileShareUserGridModel> newUserGrid;

    public AbstractFileShareUserDialog(ViewContext context, UserInfoDTO[] existingUsers, UserInfoDTO[] newUsers, String name) {
        this(context, AbstractFileShareUserDialog.getArrayList(existingUsers), AbstractFileShareUserDialog.getArrayList(newUsers), name);
    }

    public AbstractFileShareUserDialog(ViewContext context, List<UserInfoDTO> oldSharingUsers, List<UserInfoDTO> newUsers, String name) {
        super(MessageDictionary.msg(MessageDictionary.SHARE_FILE_DIALOG_TITLE, name), 980, 577);
        this.existingUsers = oldSharingUsers;
        this.newUsers = newUsers;
        this.viewContext = context;
        this.existingUserGrid = this.createUserGrid(this.existingUsers);
        this.newUserGrid = this.createUserGrid(this.newUsers);
        this.add(this.createContentWidget());
    }

    public AbstractFileShareUserDialog(ViewContext context, UserInfoDTO[] existingUsers, String name) {
        this(context, existingUsers, null, name);
    }

    public void refresh() {
        this.newUserGrid.setDataAndRefresh(FileShareUserGridModel.convert(this.viewContext.getModel().getUser(), this.newUsers, null));
        this.existingUserGrid.setDataAndRefresh(FileShareUserGridModel.convert(this.viewContext.getModel().getUser(), this.existingUsers, null));
    }

    static ArrayList<UserInfoDTO> getArrayList(UserInfoDTO[] users) {
        ArrayList<UserInfoDTO> list = new ArrayList<UserInfoDTO>();
        if (users != null) {
            int i = 0;
            while (i < users.length) {
                list.add(users[i]);
                ++i;
            }
        }
        return list;
    }

    abstract void checkboxChangeAction();

    abstract void addUserToFileShare(UserInfoDTO var1);

    protected final Widget createContentWidget() {
        ContentPanel panel = AbstractMainPageTabController.createContainer();
        this.insertExistingUserGrid((LayoutContainer)panel);
        this.insertNewUserGrid((LayoutContainer)panel);
        this.insertAddUserForm((LayoutContainer)panel);
        return panel;
    }

    private final void insertExistingUserGrid(LayoutContainer verticalPanel) {
        HTML html = new HTML(MessageDictionary.msg(MessageDictionary.LIST_USERS_FILESHARING_EXISTING_GRID_TITLE));
        html.setStyleName("cifex-heading");
        verticalPanel.add((Widget)html);
        verticalPanel.add((Widget)this.existingUserGrid.getWidget());
    }

    private final GridWidget<FileShareUserGridModel> createUserGrid(List<UserInfoDTO> users) {
        List<FileShareUserGridModel> data = FileShareUserGridModel.convert(this.viewContext.getModel().getUser(), users, null);
        List<ColumnConfig> columnConfigs = FileShareUserGridModel.getColumnConfigs();
        List filterItems = AbstractUserGridModel.createFilterItems(columnConfigs);
        GridWidget<FileShareUserGridModel> gridWidget = GridWidget.create(columnConfigs, data, filterItems);
        Grid<FileShareUserGridModel> grid = gridWidget.getGrid();
        grid.setHeight(150);
        grid.addListener(Events.CellClick, (Listener)new FileShareUserGridCellListener(this));
        return gridWidget;
    }

    private final void insertNewUserGrid(LayoutContainer verticalPanel) {
        HTML html = new HTML(MessageDictionary.msg(MessageDictionary.LIST_USERS_FILESHARING_NEW_GRID_TITLE));
        html.setStyleName("cifex-heading");
        verticalPanel.add((Widget)html);
        verticalPanel.add((Widget)this.newUserGrid.getWidget());
    }

    private final void insertAddUserForm(LayoutContainer verticalPanel) {
        FormPanel form = new FormPanel();
        form.setHeaderVisible(false);
        form.setBodyBorder(false);
        form.setBorders(false);
        form.setButtonAlign(Style.HorizontalAlignment.LEFT);
        HTML html = new HTML(MessageDictionary.msg(MessageDictionary.SHARE_FILE_ADDUSER_PANEL_TITEL));
        html.setStyleName("cifex-heading");
        TextField addUserField = new TextField();
        addUserField.setFieldLabel(MessageDictionary.msg(MessageDictionary.SHARE_FILE_ADDUSER_EMAIL_LABEL));
        addUserField.setValidateOnBlur(true);
        addUserField.setName(EMAIL_FIELD_CONFIG);
        addUserField.setValidateOnBlur(true);
        addUserField.setValidator(CifexValidator.getUserFieldValidator());
        form.add((Widget)addUserField);
        String buttonLabel = MessageDictionary.msg(MessageDictionary.SHARE_FILE_ADDUSER_BUTTON_LABEL);
        Button submitButton = new Button(buttonLabel);
        submitButton.addSelectionListener(this.getSubmitButtonListener((TextField<String>)addUserField));
        form.addButton(submitButton);
        verticalPanel.add((Widget)html);
        verticalPanel.add((Widget)form);
    }

    private SelectionListener<ButtonEvent> getSubmitButtonListener(final TextField<String> userTextField) {
        return new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                if (!userTextField.validate()) {
                    return;
                }
                Button button = ce.getButton();
                button.disable();
                final String emailOrCode = (String)userTextField.getValue();
                if (emailOrCode.substring(0, "id:".length()).equalsIgnoreCase("id:")) {
                    final String userCode = emailOrCode.substring("id:".length());
                    AbstractFileShareUserDialog.this.viewContext.getCifexService().tryFindUserByUserCodeOrCreate(userCode, (AsyncCallback<UserInfoDTO>)new AbstractAsyncCallback<UserInfoDTO>(AbstractFileShareUserDialog.this.viewContext){

                        public void onSuccess(UserInfoDTO result) {
                            UserInfoDTO user = result;
                            if (user != null) {
                                if (!(this).AbstractFileShareUserDialog.this.existingUsers.contains(user)) {
                                    (this).AbstractFileShareUserDialog.this.existingUsers.add(user);
                                    AbstractFileShareUserDialog.this.addUserToFileShare(user);
                                }
                                (this).AbstractFileShareUserDialog.this.existingUserGrid.setDataAndRefresh(FileShareUserGridModel.convert((this).AbstractFileShareUserDialog.this.viewContext.getModel().getUser(), (this).AbstractFileShareUserDialog.this.existingUsers, (ListStore<FileShareUserGridModel>)(this).AbstractFileShareUserDialog.this.existingUserGrid.getGrid().getStore()));
                                AbstractFileShareUserDialog.this.checkboxChangeAction();
                            } else {
                                MessageBox.alert((String)MessageDictionary.msg(MessageDictionary.MESSAGE_BOX_ERROR_TITLE), (String)MessageDictionary.msg(MessageDictionary.UNKNOWN_USER_MSG, userCode), null);
                            }
                        }
                    });
                } else {
                    AbstractFileShareUserDialog.this.viewContext.getCifexService().findUserByEmail(emailOrCode, (AsyncCallback<List<UserInfoDTO>>)new AbstractAsyncCallback<List<UserInfoDTO>>(AbstractFileShareUserDialog.this.viewContext){

                        public void onSuccess(List<UserInfoDTO> users) {
                            UserInfoDTO requestUser = (this).AbstractFileShareUserDialog.this.viewContext.getModel().getUser();
                            UserUtils.removeUnsuitableUsersForSharing(requestUser, users);
                            if (users.size() > 0) {
                                int i = 0;
                                while (i < users.size()) {
                                    UserInfoDTO user = users.get(i);
                                    if (!(this).AbstractFileShareUserDialog.this.existingUsers.contains(user)) {
                                        (this).AbstractFileShareUserDialog.this.existingUsers.add(user);
                                        AbstractFileShareUserDialog.this.addUserToFileShare(user);
                                    }
                                    ++i;
                                }
                                (this).AbstractFileShareUserDialog.this.existingUserGrid.setDataAndRefresh(FileShareUserGridModel.convert(requestUser, (this).AbstractFileShareUserDialog.this.existingUsers, (ListStore<FileShareUserGridModel>)(this).AbstractFileShareUserDialog.this.existingUserGrid.getGrid().getStore()));
                            } else {
                                UserInfoDTO user = new UserInfoDTO();
                                user.setEmail(emailOrCode);
                                user.setExpirationDate(UserUtils.getDefaultUserExpirationDate((this).AbstractFileShareUserDialog.this.viewContext));
                                user.setRegistrator((this).AbstractFileShareUserDialog.this.viewContext.getModel().getUser());
                                (this).AbstractFileShareUserDialog.this.newUsers.add(user);
                                AbstractFileShareUserDialog.this.addUserToFileShare(user);
                                (this).AbstractFileShareUserDialog.this.newUserGrid.setDataAndRefresh(FileShareUserGridModel.convert(requestUser, (this).AbstractFileShareUserDialog.this.newUsers, (ListStore<FileShareUserGridModel>)(this).AbstractFileShareUserDialog.this.newUserGrid.getGrid().getStore()));
                            }
                            AbstractFileShareUserDialog.this.checkboxChangeAction();
                        }
                    });
                }
                userTextField.setValue((Object)"");
                button.enable();
            }
        };
    }
}

