/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.client.application.ui;

import ch.systemsx.cisd.cifex.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.cifex.client.application.ViewContext;
import ch.systemsx.cisd.cifex.client.application.utils.DOMUtils;
import ch.systemsx.cisd.cifex.client.application.utils.DateTimeUtils;
import ch.systemsx.cisd.cifex.client.application.utils.FileUtils;
import ch.systemsx.cisd.cifex.client.application.utils.MessageDictionary;
import ch.systemsx.cisd.cifex.client.application.utils.WidgetUtils;
import ch.systemsx.cisd.cifex.shared.basic.dto.FileUploadFeedback;
import ch.systemsx.cisd.cifex.shared.basic.dto.Message;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.MessageBoxEvent;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.button.Button;

final class FileUploadFeedbackCallback
extends AbstractAsyncCallback<FileUploadFeedback> {
    private MessageBox messageBox;
    private Button submitButton;

    FileUploadFeedbackCallback(ViewContext context, Button submitButton) {
        this(context, null, submitButton);
    }

    private FileUploadFeedbackCallback(ViewContext context, MessageBox initialized, Button submitButton) {
        super(context);
        this.messageBox = initialized;
        this.submitButton = submitButton;
    }

    private final void refreshMainPage() {
        this.getViewContext().getPageController().refreshMainPage();
    }

    private final String createUpdateMessage(FileUploadFeedback feedback) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(MessageDictionary.msg(MessageDictionary.UPLOAD_FILE_FEEDBACK_FILE_LABEL, feedback.getFileName()));
        buffer.append(DOMUtils.BR);
        String byteRead = FileUtils.byteCountToDisplaySize(feedback.getBytesRead());
        long length = feedback.getContentLength();
        String contentLength = length == Long.MAX_VALUE ? MessageDictionary.msg(MessageDictionary.UNKNOWN_LABEL) : FileUtils.byteCountToDisplaySize(length);
        buffer.append(MessageDictionary.msg(MessageDictionary.UPLOAD_FILE_FEEDBACK_PROGRESS_LABEL, byteRead, contentLength));
        buffer.append(DOMUtils.BR);
        long timeLeft = feedback.getTimeLeft();
        if (timeLeft < Long.MAX_VALUE) {
            buffer.append(MessageDictionary.msg(MessageDictionary.UPLOAD_FILE_FEEDBACK_TIME_REMAINING_LABEL, DateTimeUtils.formatDuration(timeLeft)));
        }
        return buffer.toString();
    }

    @Override
    public final void onFailure(Throwable caught) {
        if (this.messageBox != null) {
            this.messageBox.close();
        }
        super.onFailure(caught);
        this.submitButton.enable();
    }

    public final void onSuccess(FileUploadFeedback result) {
        FileUploadFeedback feedback = result;
        final Message message = feedback.getMessage();
        if (message != null) {
            if (this.messageBox != null) {
                this.messageBox.close();
            }
            WidgetUtils.showMessage(message, new Listener<MessageBoxEvent>(){

                public void handleEvent(MessageBoxEvent be) {
                    FileUploadFeedbackCallback.this.finish(Message.Type.ERROR.equals((Object)message.getType()));
                }
            });
            return;
        }
        if (feedback.isFinished()) {
            this.finish(false);
            return;
        }
        if (this.messageBox == null) {
            this.messageBox = MessageBox.progress((String)MessageDictionary.msg(MessageDictionary.UPLOAD_FILE_FEEDBACK_MSGBOX_TITLE), (String)MessageDictionary.msg(MessageDictionary.UPLOAD_FILE_FEEDBACK_MSG), null);
        } else {
            this.messageBox.updateProgress((double)feedback.getPercentage() * 0.01, "");
            this.messageBox.updateText(this.createUpdateMessage(feedback));
        }
        this.getViewContext().getCifexService().getFileUploadFeedback(new FileUploadFeedbackCallback(this.getViewContext(), this.messageBox, this.submitButton));
    }

    private void finish(boolean isError) {
        if (!isError) {
            this.messageBox.close();
            this.refreshMainPage();
        }
        this.submitButton.enable();
    }
}

