/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.client.cli;

import ch.systemsx.cisd.args4j.Option;
import ch.systemsx.cisd.cifex.rpc.client.cli.AbstractCommand;
import ch.systemsx.cisd.cifex.rpc.client.cli.MinimalParameters;
import ch.systemsx.cisd.cifex.rpc.client.encryption.OpenPGPSymmetricKeyEncryption;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import java.io.File;
import org.apache.commons.lang.StringUtils;

public class DecryptCommand
extends AbstractCommand {
    private static final String NAME = "decrypt";
    private static DecryptCommand instance;

    public static final synchronized DecryptCommand getInstance() {
        if (instance == null) {
            instance = new DecryptCommand();
        }
        return instance;
    }

    private DecryptCommand() {
        super(NAME);
    }

    private String getPassphraseOrExit(Parameters parameters) {
        String passphrase = this.tryGetPassphrase("Passphrase: ", parameters.getPassphrase());
        if (StringUtils.isBlank((String)passphrase)) {
            System.err.println("No passphrase has been specified, exiting.");
            System.exit(1);
        }
        return passphrase;
    }

    @Override
    public int execute(String[] arguments) throws UserFailureException, EnvironmentFailureException {
        Parameters parameters = new Parameters(arguments);
        String passphrase = this.getPassphraseOrExit(parameters);
        File clearTextFile = OpenPGPSymmetricKeyEncryption.decrypt(parameters.getInFile(), parameters.getOutFilename(), passphrase, parameters.isOverwriteOutputFile());
        if (parameters.getOutFilename() == null) {
            System.out.println("\nDecrypted file is '" + clearTextFile + "'.");
        }
        return 0;
    }

    private static class Parameters
    extends MinimalParameters {
        private File inFile;
        @Option(name="o", longName="output-file", metaVar="STRING", usage="The name of the decrypted file.")
        private String outFilename;
        @Option(name="O", longName="overwrote-output-file", metaVar="FLAG", usage="Whether an already existing output file should be silently overwritten.")
        private boolean overwriteOutputFile;
        @Option(name="p", longName="passphrase", metaVar="STRING", usage="The pass phrase to use for decryption.")
        private String passphrase;

        public Parameters(String[] args) {
            super(args, DecryptCommand.NAME, "<file>");
            if (this.getArgs().size() != 1) {
                this.printHelp(true);
            }
            this.inFile = new File(this.getArgs().get(0));
        }

        public File getInFile() {
            return this.inFile;
        }

        public String getOutFilename() {
            return this.outFilename;
        }

        public boolean isOverwriteOutputFile() {
            return this.overwriteOutputFile;
        }

        public String getPassphrase() {
            return this.passphrase;
        }
    }
}

