/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.server.business.dataaccess.db;

import ch.systemsx.cisd.cifex.server.business.dataaccess.IFileDAO;
import ch.systemsx.cisd.cifex.server.business.dataaccess.db.AbstractDAO;
import ch.systemsx.cisd.cifex.server.business.dataaccess.db.UserDAO;
import ch.systemsx.cisd.cifex.server.business.dto.FileDTO;
import ch.systemsx.cisd.cifex.server.business.dto.UserDTO;
import ch.systemsx.cisd.common.db.ISequencerHandler;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public final class FileDAO
extends AbstractDAO
implements IFileDAO {
    private static final int MAX_COMMENT_LENGTH = 1000;
    private static final FileWithOwnerRowMapper FILE_WITH_OWNER_ROW_MAPPER = new FileWithOwnerRowMapper();
    private static final ParameterizedRowMapper<FileDTO> FILE_ROW_MAPPER = new FileRowMapper();
    private static final ParameterizedRowMapper<UserDTO> SHARING_USER_ROW_MAPPER = new SharingUserRowMapper();
    private static final String SELECT_FILES = "select f.ID as f_id, f.NAME as f_name, f.PATH as f_path, f.COMMENT as f_comment, f.USER_ID as f_user_id, f.REGISTRATOR_CODE as f_REGISTRATOR_CODE,  f.REGISTRATION_TIMESTAMP as f_registration_timestamp, f.EXPIRATION_TIMESTAMP as f_expiration_timestamp, f.CONTENT_TYPE as f_content_type, f.SIZE as f_size, f.CRC32_CHECKSUM as f_crc32_checkum, f.COMPLETE_SIZE as f_complete_size";
    private static final String FILES_JOIN_USERS = "select f.ID as f_id, f.NAME as f_name, f.PATH as f_path, f.COMMENT as f_comment, f.USER_ID as f_user_id, f.REGISTRATOR_CODE as f_REGISTRATOR_CODE,  f.REGISTRATION_TIMESTAMP as f_registration_timestamp, f.EXPIRATION_TIMESTAMP as f_expiration_timestamp, f.CONTENT_TYPE as f_content_type, f.SIZE as f_size, f.CRC32_CHECKSUM as f_crc32_checkum, f.COMPLETE_SIZE as f_complete_size, u.*  from files as f  left join users as u on f.user_id = u.id";
    private static final String FILES_JOIN_USERS_WHERE_ID = "select f.ID as f_id, f.NAME as f_name, f.PATH as f_path, f.COMMENT as f_comment, f.USER_ID as f_user_id, f.REGISTRATOR_CODE as f_REGISTRATOR_CODE,  f.REGISTRATION_TIMESTAMP as f_registration_timestamp, f.EXPIRATION_TIMESTAMP as f_expiration_timestamp, f.CONTENT_TYPE as f_content_type, f.SIZE as f_size, f.CRC32_CHECKSUM as f_crc32_checkum, f.COMPLETE_SIZE as f_complete_size, u.*  from files as f  left join users as u on f.user_id = u.id where f.id = ?";

    FileDAO(DataSource dataSource, ISequencerHandler sequencerHandler, boolean supportsAnyOperator) {
        super(dataSource, sequencerHandler, supportsAnyOperator);
    }

    private final long createID() {
        return this.getNextValueOf("FILE_ID_SEQ");
    }

    private final List<UserDTO> listSharingUsers(long fileId) throws DataAccessException {
        List list = this.getSimpleJdbcTemplate().query("select * from file_shares where file_id = ?", SHARING_USER_ROW_MAPPER, new Object[]{fileId});
        return list;
    }

    @Override
    public void createSharingLink(long fileID, long userID) throws DataAccessException {
        this.getSimpleJdbcTemplate().update("insert into file_shares (id, file_id, user_id) values (?,?,?)", new Object[]{this.getNextValueOf("FILE_SHARE_ID_SEQ"), fileID, userID});
    }

    @Override
    public boolean deleteSharingLink(long fileID, String userCode) throws DataAccessException {
        int affectedRows = this.getSimpleJdbcTemplate().update("delete from file_shares where file_id = ? and user_id in (select id from users where user_code = ?)", new Object[]{fileID, userCode});
        return affectedRows > 0;
    }

    @Override
    public final void createFile(FileDTO file) throws DataAccessException {
        assert (file != null) : "Given file cannot be null.";
        long id = this.createID();
        this.getSimpleJdbcTemplate().update("insert into files (ID, NAME, PATH, COMMENT, USER_ID, REGISTRATOR_CODE, CONTENT_TYPE, SIZE, CRC32_CHECKSUM, EXPIRATION_TIMESTAMP, COMPLETE_SIZE) values (?,?,?,?,?,(select user_code from users u where u.id = ?),?,?,?,?,?)", new Object[]{id, file.getName(), file.getPath(), StringUtils.abbreviate((String)file.getComment(), (int)1000), file.getOwnerId(), file.getOwnerId(), file.getContentType(), file.getSize(), file.getCrc32Value(), file.getExpirationDate(), file.getCompleteSize()});
        file.setID(id);
    }

    @Override
    public void updateFile(FileDTO file) throws DataAccessException {
        assert (file != null);
        assert (file.getID() != null) : "File needs an ID, otherwise it can't be updated";
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        template.update("update files set name = ?, path = ?, comment = ?, expiration_timestamp = ?, user_id = ?, content_type = ?, size = ?, crc32_checksum = ?, complete_size = ? where id = ?", new Object[]{file.getName(), file.getPath(), StringUtils.abbreviate((String)file.getComment(), (int)1000), file.getExpirationDate(), file.getOwnerId(), file.getContentType(), file.getSize(), file.getCrc32Value(), file.getCompleteSize(), file.getID()});
    }

    @Override
    public void updateFileUserEdit(long id, String name, String commentOrNull, Date expirationDate) throws DataAccessException {
        assert (name != null);
        assert (expirationDate != null);
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        template.update("update files set name = ?, comment = ?, expiration_timestamp = ? where id = ?", new Object[]{name, StringUtils.abbreviate((String)commentOrNull, (int)1000), expirationDate, id});
    }

    @Override
    public void updateFileUploadProgress(long id, long size, int crc32, Date expirationDate) throws DataAccessException {
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        template.update("update files set size = ?, crc32_checksum = ?, expiration_timestamp = ? where id = ?", new Object[]{size, crc32, expirationDate, id});
    }

    @Override
    public boolean deleteFile(long id) throws DataAccessException {
        int affectedRows = this.getSimpleJdbcTemplate().update("delete from files where id = ?", new Object[]{id});
        return affectedRows > 0;
    }

    @Override
    public List<FileDTO> listFiles() throws DataAccessException {
        List list = this.getSimpleJdbcTemplate().query(FILES_JOIN_USERS, (ParameterizedRowMapper)FILE_WITH_OWNER_ROW_MAPPER, new Object[0]);
        for (FileDTO file : list) {
            List<UserDTO> sharingUsers = this.listSharingUsers(file.getID());
            if (sharingUsers.size() <= 0) continue;
            file.setSharingUsers(sharingUsers);
        }
        return list;
    }

    @Override
    public final FileDTO tryGetFile(long id) throws DataAccessException {
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        try {
            FileDTO file = (FileDTO)template.queryForObject(FILES_JOIN_USERS_WHERE_ID, (ParameterizedRowMapper)FILE_WITH_OWNER_ROW_MAPPER, new Object[]{id});
            List<UserDTO> sharingUsers = this.listSharingUsers(id);
            if (sharingUsers.size() > 0) {
                file.setSharingUsers(sharingUsers);
            }
            return file;
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            return null;
        }
    }

    @Override
    public Date getFileRegistrationDate(long fileId) throws DataAccessException {
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        return (Date)template.queryForObject("select registration_timestamp from files where id = ?", Date.class, new Object[]{fileId});
    }

    @Override
    public final List<FileDTO> getExpiredFiles() {
        List list = this.getSimpleJdbcTemplate().query("select f.ID as f_id, f.NAME as f_name, f.PATH as f_path, f.COMMENT as f_comment, f.USER_ID as f_user_id, f.REGISTRATOR_CODE as f_REGISTRATOR_CODE,  f.REGISTRATION_TIMESTAMP as f_registration_timestamp, f.EXPIRATION_TIMESTAMP as f_expiration_timestamp, f.CONTENT_TYPE as f_content_type, f.SIZE as f_size, f.CRC32_CHECKSUM as f_crc32_checkum, f.COMPLETE_SIZE as f_complete_size from files as f where f.expiration_timestamp < now() ", FILE_ROW_MAPPER, new Object[0]);
        return list;
    }

    @Override
    public final List<FileDTO> listDownloadFiles(long userId) throws DataAccessException {
        List list = this.getSimpleJdbcTemplate().query("select f.ID as f_id, f.NAME as f_name, f.PATH as f_path, f.COMMENT as f_comment, f.USER_ID as f_user_id, f.REGISTRATOR_CODE as f_REGISTRATOR_CODE,  f.REGISTRATION_TIMESTAMP as f_registration_timestamp, f.EXPIRATION_TIMESTAMP as f_expiration_timestamp, f.CONTENT_TYPE as f_content_type, f.SIZE as f_size, f.CRC32_CHECKSUM as f_crc32_checkum, f.COMPLETE_SIZE as f_complete_size, u.* from files f left join users u on f.user_id = u.id left join file_shares s on s.file_id = f.id where f.complete_size = f.size and s.user_id = ?", (ParameterizedRowMapper)FILE_WITH_OWNER_ROW_MAPPER, new Object[]{userId});
        return list;
    }

    @Override
    public final List<FileDTO> listDirectlyAndIndirectlyOwnedFiles(long userId) throws DataAccessException {
        List list = this.getSimpleJdbcTemplate().query("select f.ID as f_id, f.NAME as f_name, f.PATH as f_path, f.COMMENT as f_comment, f.USER_ID as f_user_id, f.REGISTRATOR_CODE as f_REGISTRATOR_CODE,  f.REGISTRATION_TIMESTAMP as f_registration_timestamp, f.EXPIRATION_TIMESTAMP as f_expiration_timestamp, f.CONTENT_TYPE as f_content_type, f.SIZE as f_size, f.CRC32_CHECKSUM as f_crc32_checkum, f.COMPLETE_SIZE as f_complete_size, u1.* from files f left join users u1 on f.user_id = u1.id left join users u2 on u1.user_id_registrator = u2.id where u1.id = ? or u2.id = ?", (ParameterizedRowMapper)FILE_WITH_OWNER_ROW_MAPPER, new Object[]{userId, userId});
        for (FileDTO file : list) {
            List<UserDTO> sharingUsers = this.listSharingUsers(file.getID());
            if (sharingUsers.size() <= 0) continue;
            file.setSharingUsers(sharingUsers);
        }
        return list;
    }

    @Override
    public FileDTO tryGetResumeCandidate(long userId, String fileName, long completeSize) {
        List list = this.getSimpleJdbcTemplate().query("select f.ID as f_id, f.NAME as f_name, f.PATH as f_path, f.COMMENT as f_comment, f.USER_ID as f_user_id, f.REGISTRATOR_CODE as f_REGISTRATOR_CODE,  f.REGISTRATION_TIMESTAMP as f_registration_timestamp, f.EXPIRATION_TIMESTAMP as f_expiration_timestamp, f.CONTENT_TYPE as f_content_type, f.SIZE as f_size, f.CRC32_CHECKSUM as f_crc32_checkum, f.COMPLETE_SIZE as f_complete_size from files f where f.user_id = ? and f.name = ? and f.complete_size = ? and f.size < f.complete_size order by f.size desc limit 1", FILE_ROW_MAPPER, new Object[]{userId, fileName, completeSize});
        if (list.isEmpty()) {
            return null;
        }
        return (FileDTO)list.get(0);
    }

    private static final class FileRowMapper
    implements ParameterizedRowMapper<FileDTO> {
        private FileRowMapper() {
        }

        private static final FileDTO fillSimpleFileFromResultSet(ResultSet rs) throws SQLException {
            long registererId = rs.getLong("f_USER_ID");
            FileDTO file = new FileDTO(registererId);
            Date expDate = new Date(rs.getTimestamp("f_EXPIRATION_TIMESTAMP").getTime());
            file.setExpirationDate(expDate);
            file.setID(rs.getLong("f_ID"));
            file.setName(rs.getString("f_NAME"));
            file.setPath(rs.getString("f_PATH"));
            file.setComment(rs.getString("f_COMMENT"));
            file.setContentType(rs.getString("f_CONTENT_TYPE"));
            file.setCompleteSize(rs.getLong("f_COMPLETE_SIZE"));
            long size = rs.getLong("f_SIZE");
            if (!rs.wasNull()) {
                file.setSize(size);
            }
            int crc32Value = rs.getInt("f_crc32_checkum");
            if (!rs.wasNull()) {
                file.setCrc32Value(crc32Value);
            }
            Date regDate = new Date(rs.getTimestamp("f_REGISTRATION_TIMESTAMP").getTime());
            file.setRegistrationDate(regDate);
            file.setRegistratorCode(rs.getString("f_REGISTRATOR_CODE"));
            return file;
        }

        public final FileDTO mapRow(ResultSet rs, int rowNum) throws SQLException {
            return FileRowMapper.fillSimpleFileFromResultSet(rs);
        }
    }

    private static final class FileWithOwnerRowMapper
    implements ParameterizedRowMapper<FileDTO> {
        private static final UserDAO.UserRowMapper userRowMapper = new UserDAO.UserRowMapper();

        private FileWithOwnerRowMapper() {
        }

        private static final FileDTO fillFileWithOwnerFromResultSet(ResultSet rs) throws SQLException {
            FileDTO file = FileRowMapper.fillSimpleFileFromResultSet(rs);
            UserDTO owner = userRowMapper.mapRow(rs, 1);
            file.setOwner(owner);
            return file;
        }

        public final FileDTO mapRow(ResultSet rs, int rowNum) throws SQLException {
            return FileWithOwnerRowMapper.fillFileWithOwnerFromResultSet(rs);
        }
    }

    private static final class SharingUserRowMapper
    implements ParameterizedRowMapper<UserDTO> {
        private SharingUserRowMapper() {
        }

        public final UserDTO mapRow(ResultSet rs, int rowNum) throws SQLException {
            UserDTO sharingUser = new UserDTO();
            sharingUser.setID(rs.getLong("USER_ID"));
            return sharingUser;
        }
    }
}

