/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractCrossOriginFilter
implements Filter {
    protected static final String ORIGIN_HEADER = "Origin";
    protected static final String ACCESS_CONTROL_ALLOW_ORIGIN_HEADER = "Access-Control-Allow-Origin";
    protected static final String ALLOWED_ORIGINS_KEY = "TODO";
    private static final String ALLOW_ALL_ORIGINS = "*";
    private FilterConfig filterConfig;

    protected abstract List<String> getOwnDomains();

    protected abstract List<String> getConfiguredTrustedDomains();

    protected List<String> getAllTrustedDomains() {
        ArrayList<String> allowedOrigins = new ArrayList<String>();
        allowedOrigins.addAll(this.getOwnDomains());
        allowedOrigins.addAll(this.getConfiguredTrustedDomains());
        return allowedOrigins;
    }

    private boolean isAllowedOrigin(String origin) {
        for (String allowedOrigin : this.getAllTrustedDomains()) {
            if (!this.isMatching(allowedOrigin, origin)) continue;
            return true;
        }
        return false;
    }

    private boolean isMatching(String allowedOrigin, String origin) {
        if (allowedOrigin.equalsIgnoreCase(origin)) {
            return true;
        }
        return ALLOW_ALL_ORIGINS.equals(allowedOrigin);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String originHeader = httpRequest.getHeader(ORIGIN_HEADER);
        if (originHeader != null && this.isAllowedOrigin(originHeader)) {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.setHeader(ACCESS_CONTROL_ALLOW_ORIGIN_HEADER, originHeader);
        }
        filterChain.doFilter(request, response);
    }

    public void destroy() {
    }

    public void init(FilterConfig fc) throws ServletException {
        this.filterConfig = fc;
    }

    protected ServletContext getServletContext() {
        return this.filterConfig.getServletContext();
    }
}

