/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;

public class StackMaker
implements PlugIn {
    private static int w = 2;
    private static int h = 2;

    public void run(String arg) {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.noImage();
            return;
        }
        if (imp.getStackSize() > 1) {
            IJ.error("This command requires a montage");
            return;
        }
        GenericDialog gd = new GenericDialog("Stack Maker");
        gd.addNumericField("Images_Per_Row: ", w, 0);
        gd.addNumericField("Images_Per_Column: ", h, 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        w = (int)gd.getNextNumber();
        h = (int)gd.getNextNumber();
        ImageStack stack = this.makeStack(imp.getProcessor(), w, h);
        new ImagePlus("Stack", stack).show();
    }

    public ImageStack makeStack(ImageProcessor ip, int w, int h) {
        int stackSize = w * h;
        int width = ip.getWidth() / w;
        int height = ip.getHeight() / h;
        ImageStack stack = new ImageStack(width, height);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                ip.setRoi(x * width, y * height, width, height);
                stack.addSlice(null, ip.crop());
            }
        }
        return stack;
    }
}

