/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto;

import java.io.Serializable;
import java.util.Arrays;

public enum AggregateFunction implements Serializable
{
    MEAN("mean"){

        @Override
        public double aggregate(double[] values) {
            return SUM.aggregate(values) / (double)values.length;
        }
    }
    ,
    MEDIAN("median"){

        @Override
        public double aggregate(double[] values) {
            Arrays.sort(values);
            int i = values.length / 2;
            return values.length % 2 == 0 ? (values[i - 1] + values[i]) / 2.0 : values[i];
        }
    }
    ,
    SUM("sum"){

        @Override
        public double aggregate(double[] values) {
            double sum = 0.0;
            double[] dArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                double value = dArray[n2];
                sum += value;
                ++n2;
            }
            return sum;
        }
    }
    ,
    MIN("minimum"){

        @Override
        public double aggregate(double[] values) {
            double min = Double.MAX_VALUE;
            double[] dArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                double value = dArray[n2];
                min = Math.min(min, value);
                ++n2;
            }
            return min;
        }
    }
    ,
    MAX("maximum"){

        @Override
        public double aggregate(double[] values) {
            double max = -1.7976931348623157E308;
            double[] dArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                double value = dArray[n2];
                max = Math.max(max, value);
                ++n2;
            }
            return max;
        }
    }
    ,
    COUNT("count"){

        @Override
        public double aggregate(double[] values) {
            return values.length;
        }
    };

    private final String label;

    private AggregateFunction(String label) {
        this.label = label;
    }

    public final String getLabel() {
        return this.label;
    }

    public abstract double aggregate(double[] var1);

    /* synthetic */ AggregateFunction(String string, int n, String string2, AggregateFunction aggregateFunction) {
        this(string2);
    }
}

