/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.cisd.hotdeploy;

import ch.ethz.cisd.hotdeploy.PluginDeploymentDesc;
import ch.ethz.cisd.hotdeploy.PluginInfo;
import ch.ethz.cisd.hotdeploy.ReflectionUtils;
import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class PluginTester
implements Closeable {
    private final PluginDeploymentDesc descriptor;
    private final Writer logWriter;

    public PluginTester(File pluginArchive, boolean requirePluginInfo) {
        this(pluginArchive, new StringWriter(), requirePluginInfo);
    }

    public PluginTester(File pluginArchive, Writer logWriter, boolean requirePluginInfo) {
        this.descriptor = new PluginDeploymentDesc(pluginArchive, requirePluginInfo);
        this.logWriter = logWriter;
        if (!this.descriptor.isLoaded()) {
            throw new IllegalArgumentException("File " + pluginArchive + " does not contain a valid plugin.");
        }
    }

    private void checkOpen() throws IllegalStateException {
        if (!this.descriptor.isLoaded()) {
            throw new IllegalStateException("Plugin has been closed.");
        }
    }

    public String getErrorMessages() {
        return this.logWriter.toString();
    }

    public Class<?> getPluginClass() {
        this.checkOpen();
        return this.descriptor.getPluginClass();
    }

    public <T> T tryCreatePlugin(Class<T> workerInterface, Object ... constructorArguments) {
        this.checkOpen();
        Class<?> pluginClass = this.getPluginClass();
        try {
            return ReflectionUtils.create(workerInterface, pluginClass, constructorArguments);
        }
        catch (IllegalArgumentException ex) {
            this.appendToLog(ex.getMessage());
        }
        catch (ClassCastException ex) {
            this.appendToLog(ex.getMessage());
        }
        return null;
    }

    private void appendToLog(String msg) {
        try {
            if (!this.logWriter.toString().isEmpty()) {
                this.logWriter.append('\n');
            }
            this.logWriter.append(msg);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }

    public boolean hasConstructor(Class<?> ... constructorArgumentTypes) {
        this.checkOpen();
        Class<?> pluginClass = this.getPluginClass();
        if (pluginClass == null) {
            return false;
        }
        return ReflectionUtils.tryGetConstructor(pluginClass, constructorArgumentTypes) != null;
    }

    public String getPluginClassname() {
        this.checkOpen();
        return this.descriptor.getPluginDesc().getPluginClassname();
    }

    public String getPluginName() {
        this.checkOpen();
        return this.descriptor.getPluginDesc().getPluginName();
    }

    public PluginInfo tryGetPluginInfo() {
        this.checkOpen();
        return this.descriptor.getPluginDesc().getPluginInfo();
    }

    public File getPluginArchive() {
        this.checkOpen();
        return this.descriptor.getPluginArchive();
    }

    @Override
    public void close() {
        this.descriptor.unload();
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

