/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.io.PrintWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.sql.DataSource;
import org.apache.commons.dbcp.DelegatingCallableStatement;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.DelegatingPreparedStatement;
import org.apache.commons.dbcp.DelegatingStatement;
import org.apache.commons.dbcp.SQLNestedException;
import org.apache.commons.pool.ObjectPool;

public class PoolingDataSource
implements DataSource {
    private boolean accessToUnderlyingConnectionAllowed = false;
    protected PrintWriter _logWriter = null;
    protected ObjectPool _pool = null;

    public PoolingDataSource() {
        this(null);
    }

    public PoolingDataSource(ObjectPool objectPool) {
        this._pool = objectPool;
    }

    public void setPool(ObjectPool objectPool) throws IllegalStateException, NullPointerException {
        if (null != this._pool) {
            throw new IllegalStateException("Pool already set");
        }
        if (null == objectPool) {
            throw new NullPointerException("Pool must not be null.");
        }
        this._pool = objectPool;
    }

    public boolean isAccessToUnderlyingConnectionAllowed() {
        return this.accessToUnderlyingConnectionAllowed;
    }

    public void setAccessToUnderlyingConnectionAllowed(boolean bl) {
        this.accessToUnderlyingConnectionAllowed = bl;
    }

    public Connection getConnection() throws SQLException {
        try {
            Connection connection = (Connection)this._pool.borrowObject();
            if (connection != null) {
                connection = new PoolGuardConnectionWrapper(connection);
            }
            return connection;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new SQLNestedException("Cannot get a connection, pool error " + noSuchElementException.getMessage(), noSuchElementException);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLNestedException("Cannot get a connection, general error", exception);
        }
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public PrintWriter getLogWriter() {
        return this._logWriter;
    }

    public int getLoginTimeout() {
        throw new UnsupportedOperationException("Login timeout is not supported.");
    }

    public void setLoginTimeout(int n) {
        throw new UnsupportedOperationException("Login timeout is not supported.");
    }

    public void setLogWriter(PrintWriter printWriter) {
        this._logWriter = printWriter;
    }

    private class PoolGuardConnectionWrapper
    extends DelegatingConnection {
        private Connection delegate;

        PoolGuardConnectionWrapper(Connection connection) {
            super(connection);
            this.delegate = connection;
        }

        protected void checkOpen() throws SQLException {
            if (this.delegate == null) {
                throw new SQLException("Connection is closed.");
            }
        }

        public void close() throws SQLException {
            if (this.delegate != null) {
                this.delegate.close();
                this.delegate = null;
                super.setDelegate(null);
            }
        }

        public boolean isClosed() throws SQLException {
            if (this.delegate == null) {
                return true;
            }
            return this.delegate.isClosed();
        }

        public void clearWarnings() throws SQLException {
            this.checkOpen();
            this.delegate.clearWarnings();
        }

        public void commit() throws SQLException {
            this.checkOpen();
            this.delegate.commit();
        }

        public Statement createStatement() throws SQLException {
            this.checkOpen();
            return new DelegatingStatement(this, this.delegate.createStatement());
        }

        public Statement createStatement(int n, int n2) throws SQLException {
            this.checkOpen();
            return new DelegatingStatement(this, this.delegate.createStatement(n, n2));
        }

        public boolean innermostDelegateEquals(Connection connection) {
            Connection connection2 = super.getInnermostDelegate();
            if (connection2 == null) {
                return connection == null;
            }
            return connection2.equals(connection);
        }

        public boolean getAutoCommit() throws SQLException {
            this.checkOpen();
            return this.delegate.getAutoCommit();
        }

        public String getCatalog() throws SQLException {
            this.checkOpen();
            return this.delegate.getCatalog();
        }

        public DatabaseMetaData getMetaData() throws SQLException {
            this.checkOpen();
            return this.delegate.getMetaData();
        }

        public int getTransactionIsolation() throws SQLException {
            this.checkOpen();
            return this.delegate.getTransactionIsolation();
        }

        public Map getTypeMap() throws SQLException {
            this.checkOpen();
            return this.delegate.getTypeMap();
        }

        public SQLWarning getWarnings() throws SQLException {
            this.checkOpen();
            return this.delegate.getWarnings();
        }

        public int hashCode() {
            if (this.delegate == null) {
                return 0;
            }
            return this.delegate.hashCode();
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            Connection connection = super.getInnermostDelegate();
            if (connection == null) {
                return false;
            }
            if (object instanceof DelegatingConnection) {
                DelegatingConnection delegatingConnection = (DelegatingConnection)object;
                return delegatingConnection.innermostDelegateEquals(connection);
            }
            return connection.equals(object);
        }

        public boolean isReadOnly() throws SQLException {
            this.checkOpen();
            return this.delegate.isReadOnly();
        }

        public String nativeSQL(String string) throws SQLException {
            this.checkOpen();
            return this.delegate.nativeSQL(string);
        }

        public CallableStatement prepareCall(String string) throws SQLException {
            this.checkOpen();
            return new DelegatingCallableStatement((DelegatingConnection)this, this.delegate.prepareCall(string));
        }

        public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
            this.checkOpen();
            return new DelegatingCallableStatement((DelegatingConnection)this, this.delegate.prepareCall(string, n, n2));
        }

        public PreparedStatement prepareStatement(String string) throws SQLException {
            this.checkOpen();
            return new DelegatingPreparedStatement((DelegatingConnection)this, this.delegate.prepareStatement(string));
        }

        public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
            this.checkOpen();
            return new DelegatingPreparedStatement((DelegatingConnection)this, this.delegate.prepareStatement(string, n, n2));
        }

        public void rollback() throws SQLException {
            this.checkOpen();
            this.delegate.rollback();
        }

        public void setAutoCommit(boolean bl) throws SQLException {
            this.checkOpen();
            this.delegate.setAutoCommit(bl);
        }

        public void setCatalog(String string) throws SQLException {
            this.checkOpen();
            this.delegate.setCatalog(string);
        }

        public void setReadOnly(boolean bl) throws SQLException {
            this.checkOpen();
            this.delegate.setReadOnly(bl);
        }

        public void setTransactionIsolation(int n) throws SQLException {
            this.checkOpen();
            this.delegate.setTransactionIsolation(n);
        }

        public void setTypeMap(Map map) throws SQLException {
            this.checkOpen();
            this.delegate.setTypeMap(map);
        }

        public String toString() {
            if (this.delegate == null) {
                return "NULL";
            }
            return this.delegate.toString();
        }

        public int getHoldability() throws SQLException {
            this.checkOpen();
            return this.delegate.getHoldability();
        }

        public void setHoldability(int n) throws SQLException {
            this.checkOpen();
            this.delegate.setHoldability(n);
        }

        public Savepoint setSavepoint() throws SQLException {
            this.checkOpen();
            return this.delegate.setSavepoint();
        }

        public Savepoint setSavepoint(String string) throws SQLException {
            this.checkOpen();
            return this.delegate.setSavepoint(string);
        }

        public void releaseSavepoint(Savepoint savepoint) throws SQLException {
            this.checkOpen();
            this.delegate.releaseSavepoint(savepoint);
        }

        public void rollback(Savepoint savepoint) throws SQLException {
            this.checkOpen();
            this.delegate.rollback(savepoint);
        }

        public Statement createStatement(int n, int n2, int n3) throws SQLException {
            this.checkOpen();
            return new DelegatingStatement(this, this.delegate.createStatement(n, n2, n3));
        }

        public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
            this.checkOpen();
            return new DelegatingCallableStatement((DelegatingConnection)this, this.delegate.prepareCall(string, n, n2, n3));
        }

        public PreparedStatement prepareStatement(String string, int n) throws SQLException {
            this.checkOpen();
            return new DelegatingPreparedStatement((DelegatingConnection)this, this.delegate.prepareStatement(string, n));
        }

        public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
            this.checkOpen();
            return new DelegatingPreparedStatement((DelegatingConnection)this, this.delegate.prepareStatement(string, n, n2, n3));
        }

        public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
            this.checkOpen();
            return new DelegatingPreparedStatement((DelegatingConnection)this, this.delegate.prepareStatement(string, nArray));
        }

        public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
            this.checkOpen();
            return new DelegatingPreparedStatement((DelegatingConnection)this, this.delegate.prepareStatement(string, stringArray));
        }

        public Connection getDelegate() {
            if (PoolingDataSource.this.isAccessToUnderlyingConnectionAllowed()) {
                return super.getDelegate();
            }
            return null;
        }

        public Connection getInnermostDelegate() {
            if (PoolingDataSource.this.isAccessToUnderlyingConnectionAllowed()) {
                return super.getInnermostDelegate();
            }
            return null;
        }
    }
}

