/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.sybit.imageviewer.gui;

import ch.systemsx.sybit.imageviewer.data.SettingsUtil;
import ch.systemsx.sybit.imageviewer.gui.ErrorStackDialog;
import ch.systemsx.sybit.imageviewer.gui.ImageViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ErrorDialog
extends JFrame
implements ActionListener,
WindowListener {
    private static final long serialVersionUID = 1L;
    private List<Throwable> throwns = new ArrayList<Throwable>();
    private boolean closeApplication;
    private JTextArea messageArea;

    public ErrorDialog(String title, Throwable t, boolean closeApplication) {
        super(title);
        this.closeApplication = closeApplication;
        this.setDefaultCloseOperation(2);
        this.addWindowListener(this);
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 24;
        constraints.insets = new Insets(10, 10, 10, 10);
        JLabel imageViewerlabel = new JLabel("Viewer", 11);
        constraints.gridx = 0;
        constraints.gridy = 0;
        panel.add((Component)imageViewerlabel, constraints);
        JTextField imageViewerVersion = new JTextField(100);
        imageViewerVersion.setText(SettingsUtil.version);
        imageViewerVersion.setEditable(false);
        imageViewerVersion.setMinimumSize(new Dimension(400, 20));
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.fill = 3;
        panel.add((Component)imageViewerVersion, constraints);
        JLabel javaVersionlabel = new JLabel("Java", 11);
        constraints.gridx = 0;
        constraints.gridy = 1;
        panel.add((Component)javaVersionlabel, constraints);
        JTextField javaVersion = new JTextField(100);
        javaVersion.setText(System.getProperty("java.version"));
        javaVersion.setEditable(false);
        javaVersion.setMinimumSize(new Dimension(400, 20));
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.fill = 3;
        panel.add((Component)javaVersion, constraints);
        JLabel messagelabel = new JLabel("Error", 11);
        constraints.gridx = 0;
        constraints.gridy = 2;
        panel.add((Component)messagelabel, constraints);
        this.messageArea = new JTextArea();
        this.messageArea.setWrapStyleWord(true);
        this.messageArea.setLineWrap(true);
        JScrollPane messageScrollPane = new JScrollPane();
        messageScrollPane.setViewportView(this.messageArea);
        messageScrollPane.setHorizontalScrollBarPolicy(30);
        messageScrollPane.setVerticalScrollBarPolicy(20);
        messageScrollPane.setMinimumSize(new Dimension(400, 300));
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.fill = 3;
        panel.add((Component)messageScrollPane, constraints);
        if (t.getMessage() != null) {
            this.messageArea.setText(t.getMessage());
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)panel, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setAlignmentX(0.5f);
        JButton detailsButton = new JButton("Details");
        detailsButton.setActionCommand("details");
        detailsButton.addActionListener(this);
        JButton closeButton = new JButton("Close");
        closeButton.setActionCommand("close");
        closeButton.addActionListener(this);
        closeButton.setPreferredSize(detailsButton.getPreferredSize());
        buttonPanel.add(closeButton);
        buttonPanel.add(detailsButton);
        this.getContentPane().add((Component)buttonPanel, "South");
        this.setSize(500, 500);
        this.setResizable(false);
        this.throwns.add(t);
    }

    public void actionPerformed(ActionEvent e) {
        if (e != null) {
            if (e.getActionCommand().equals("close")) {
                this.updateStateOfFrames();
                this.dispose();
            } else if (e.getActionCommand().equals("details")) {
                new ErrorStackDialog(this.throwns).setVisible(true);
            }
        }
    }

    public void windowActivated(WindowEvent arg0) {
    }

    public void windowClosed(WindowEvent arg0) {
    }

    public void windowClosing(WindowEvent arg0) {
        this.updateStateOfFrames();
    }

    public void windowDeactivated(WindowEvent arg0) {
    }

    public void windowDeiconified(WindowEvent arg0) {
    }

    public void windowIconified(WindowEvent arg0) {
    }

    public void windowOpened(WindowEvent arg0) {
    }

    private void updateStateOfFrames() {
        if (this.closeApplication) {
            Frame[] activeFrames;
            for (Frame frame : activeFrames = JFrame.getFrames()) {
                if (frame.equals(this)) continue;
                if (frame instanceof ImageViewer) {
                    ((ImageViewer)frame).finish();
                }
                if (!frame.isDisplayable()) continue;
                frame.dispose();
            }
        }
    }

    public void addErrorMessage(Throwable t) {
        this.messageArea.append("\n");
        this.messageArea.append(t.getLocalizedMessage());
        this.throwns.add(t);
    }

    public void setCloseApplication(boolean closeApplication) {
        if (closeApplication && !this.closeApplication) {
            this.closeApplication = closeApplication;
        }
    }
}

