/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.sybit.imageviewer.service;

import ch.systemsx.sybit.imageviewer.data.SettingsUtil;
import ch.systemsx.sybit.imageviewer.gui.ImageViewer;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.URLDecoder;

public class ImageViewerClientHandler
implements Runnable {
    private Socket socket;
    private String topPath;
    private ImageViewer imageViewer;

    public ImageViewerClientHandler(Socket socket, String topPath) {
        this.socket = socket;
        this.topPath = topPath;
    }

    public void run() {
        try {
            BufferedOutputStream outputWriter = new BufferedOutputStream(this.socket.getOutputStream());
            BufferedReader inputReader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            String input = inputReader.readLine();
            if (input != null) {
                try {
                    this.handleRequest(input);
                    this.sendMessage(outputWriter, 100, "");
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    this.sendMessage(outputWriter, 404, t.getMessage());
                }
            } else {
                this.sendMessage(outputWriter, 404, "No input stream available");
            }
            outputWriter.flush();
            outputWriter.close();
            inputReader.close();
            this.socket.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void handleRequest(String input) throws Throwable {
        int mode;
        String[] args;
        String defaultImageSize;
        String filter;
        if (input == null) {
            throw new Exception("Incorrect format of the request");
        }
        if (!input.startsWith("GET ")) {
            throw new Exception("Only GET method is supported");
        }
        if (!input.endsWith(" HTTP/1.0") && !input.endsWith("HTTP/1.1")) {
            throw new Exception("Incorrect format of the request");
        }
        String url = input.substring(4, input.length() - 9);
        if ((url = url.trim()).contains("?") && url.indexOf("?") != url.length() - 1) {
            url = url.substring(url.indexOf("?") + 1);
            String[] parameters = url.split("&");
            String path = null;
            filter = null;
            defaultImageSize = "75";
            for (int i = 0; i < parameters.length && (path == null || filter == null || defaultImageSize == null); ++i) {
                if (parameters[i].startsWith("path=") && parameters[i].length() > 5) {
                    path = parameters[i].substring(5);
                }
                if (parameters[i].startsWith("filter=") && parameters[i].length() > 7) {
                    filter = parameters[i].substring(7);
                }
                if (!parameters[i].startsWith("size=") || parameters[i].length() <= 5) continue;
                defaultImageSize = parameters[i].substring(5);
                try {
                    Integer.parseInt(defaultImageSize);
                    continue;
                }
                catch (Throwable t) {
                    throw new Exception("Default size of the image specified but is not positive integer");
                }
            }
            if (path == null) {
                throw new Exception("Directory or file not specified");
            }
            File file = new File(URLDecoder.decode(path, "UTF-8")).getCanonicalFile();
            if (this.topPath != null && !file.toString().startsWith(this.topPath.toString())) {
                throw new Exception("Permission denied");
            }
            if (!file.exists()) {
                throw new Exception("File Not Found");
            }
            args = new String[]{"-i", path};
            mode = SettingsUtil.LocalSystem;
            if (this.imageViewer != null) {
                this.imageViewer.setVisible(false);
            }
        } else {
            throw new Exception("No parameters specified in the request");
        }
        this.imageViewer = new ImageViewer(args, mode, defaultImageSize);
        this.imageViewer.setVisible(true);
        this.imageViewer.showLoading();
        this.imageViewer.loadImages(filter);
    }

    private void sendMessage(BufferedOutputStream outputStream, int code, String message) throws IOException {
        outputStream.write(("HTTP/1.0 " + code + " OK\r\n" + "\r\n").getBytes());
        outputStream.write(message.getBytes());
    }
}

