/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.bsse.cisd.dsu.dss;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.etlserver.DefaultDataSetInfoExtractor;
import ch.systemsx.cisd.etlserver.IDataSetInfoExtractor;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewProperty;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class DataSetInfoExtractor
implements IDataSetInfoExtractor {
    static final String VERSION_KEY = "ILLUMINA_PIPELINE_VERSION";
    static final String PATH_TO_CONFIG_FILE_KEY = "path-to-config-file";
    static final String DEFAULT_PATH_TO_CONFIG_FILE = "Data/Intensities/config.xml";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DataSetInfoExtractor.class);
    private final IDataSetInfoExtractor dataSetInfoExtractor;
    private final String pathToConfigFile;
    private final Pattern pattern;

    public DataSetInfoExtractor(Properties properties) {
        this.dataSetInfoExtractor = new DefaultDataSetInfoExtractor(properties);
        this.pathToConfigFile = properties.getProperty(PATH_TO_CONFIG_FILE_KEY, DEFAULT_PATH_TO_CONFIG_FILE);
        this.pattern = Pattern.compile(".*<Software.*Version=('|\")(.*)('|\").*");
    }

    @Override
    public DataSetInformation getDataSetInformation(File incomingDataSetPath, IEncapsulatedOpenBISService openbisService) throws UserFailureException, EnvironmentFailureException {
        DataSetInformation info = this.dataSetInfoExtractor.getDataSetInformation(incomingDataSetPath, openbisService);
        File configFile = new File(incomingDataSetPath, this.pathToConfigFile);
        if (configFile.isFile()) {
            String version = this.tryToExtractVersion(configFile);
            if (version != null) {
                NewProperty property = new NewProperty();
                property.setPropertyCode(VERSION_KEY);
                property.setValue(version);
                info.setDataSetProperties(Arrays.asList(property));
            } else {
                operationLog.warn((Object)("No version found in config file '" + this.pathToConfigFile + "'."));
            }
        } else {
            operationLog.warn((Object)("Config file '" + this.pathToConfigFile + "' does not exists or is a directory."));
        }
        return info;
    }

    private String tryToExtractVersion(File configFile) {
        List<String> configFileContent = FileUtilities.loadToStringList(configFile);
        for (String line : configFileContent) {
            Matcher matcher = this.pattern.matcher(line);
            if (!matcher.matches()) continue;
            return matcher.group(2);
        }
        return null;
    }
}

