/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.dbmigration;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.db.ISequencerHandler;
import ch.systemsx.cisd.common.db.PostgreSQLSequencerHandler;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.dbmigration.DatabaseConfigurationContext;
import ch.systemsx.cisd.dbmigration.IDAOFactory;
import ch.systemsx.cisd.dbmigration.h2.H2DAOFactory;
import ch.systemsx.cisd.dbmigration.postgresql.PostgreSQLDAOFactory;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.jdbc.support.lob.LobHandler;

public final class DatabaseEngine
extends Enum<DatabaseEngine> {
    public static final /* enum */ DatabaseEngine POSTGRESQL = new DatabaseEngine("postgresql", "org.postgresql.Driver", PostgreSQLDAOFactory.class, (LobHandler)new DefaultLobHandler(), new PostgreSQLSequencerHandler(), "jdbc:postgresql://{0}/", "jdbc:postgresql://{0}/{1}", "localhost", "postgres", "SELECT 1");
    public static final /* enum */ DatabaseEngine H2 = new DatabaseEngine("h2", "org.h2.Driver", H2DAOFactory.class, (LobHandler)new DefaultLobHandler(), new PostgreSQLSequencerHandler(), "jdbc:h2:{0}{1};DB_CLOSE_DELAY=-1", "jdbc:h2:{0}{1};DB_CLOSE_DELAY=-1", "file:db/", "sa", null);
    private static Map<String, DatabaseEngine> engines;
    private static Map<String, DatabaseEngine> enginesByDriverClass;
    private final String code;
    private final String driverClass;
    private final Class<IDAOFactory> daoFactoryClass;
    private final Constructor<IDAOFactory> daoFactoryConstructor;
    private final LobHandler lobHandler;
    private final ISequencerHandler sequenceHandler;
    private final String adminUrlTemplate;
    private final String urlTemplate;
    private final String defaultURLHostPart;
    private final String defaultAdminUser;
    private final String validationQuery;
    private static final /* synthetic */ DatabaseEngine[] ENUM$VALUES;

    static {
        ENUM$VALUES = new DatabaseEngine[]{POSTGRESQL, H2};
        engines = DatabaseEngine.initEngineMap();
        enginesByDriverClass = DatabaseEngine.initEnginesByDriverClassMap();
    }

    private DatabaseEngine(String code, String driver, Class<?> daoFactoryClass, LobHandler lobHandler, ISequencerHandler sequenceHandler, String adminUrlTemplate, String urlTemplate, String defaultURLHostPart, String defaultAdminUser, String validationQuery) {
        assert (code != null);
        assert (driver != null);
        assert (daoFactoryClass != null);
        assert (lobHandler != null);
        assert (sequenceHandler != null);
        assert (adminUrlTemplate != null);
        assert (urlTemplate != null);
        assert (defaultURLHostPart != null);
        assert (defaultAdminUser != null);
        this.code = code.toLowerCase();
        this.adminUrlTemplate = adminUrlTemplate;
        this.urlTemplate = urlTemplate;
        this.defaultURLHostPart = defaultURLHostPart;
        this.defaultAdminUser = defaultAdminUser;
        this.driverClass = driver;
        this.lobHandler = lobHandler;
        this.sequenceHandler = sequenceHandler;
        this.validationQuery = validationQuery;
        this.daoFactoryClass = daoFactoryClass;
        try {
            this.daoFactoryConstructor = this.daoFactoryClass.getConstructor(DatabaseConfigurationContext.class);
        }
        catch (NoSuchMethodException ex) {
            throw new Error("No constructor", ex);
        }
    }

    public final String getCode() {
        return this.code;
    }

    public IDAOFactory createDAOFactory(DatabaseConfigurationContext context) {
        try {
            return this.daoFactoryConstructor.newInstance(context);
        }
        catch (Exception ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }

    public final String getDriverClass() {
        return this.driverClass;
    }

    public final LobHandler getLobHandler() {
        return this.lobHandler;
    }

    public final ISequencerHandler getSequenceHandler() {
        return this.sequenceHandler;
    }

    public final String getAdminURL(String urlHostPartOrNull, String databaseName) {
        String hostPartUrl = urlHostPartOrNull == null ? this.defaultURLHostPart : urlHostPartOrNull;
        String url = MessageFormat.format(this.adminUrlTemplate, hostPartUrl, databaseName);
        return url;
    }

    public final String getDefaultAdminUser() {
        return this.defaultAdminUser;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public final String getURL(String urlHostPartOrNull, String databaseName) {
        String hostPartUrl = urlHostPartOrNull == null ? this.defaultURLHostPart : urlHostPartOrNull;
        String url = MessageFormat.format(this.urlTemplate, hostPartUrl, databaseName);
        return url;
    }

    public static DatabaseEngine getEngineForCode(String code) throws ConfigurationFailureException {
        DatabaseEngine engine = engines.get(code.toLowerCase());
        if (engine == null) {
            throw new ConfigurationFailureException("No database engine '" + code + "' found.");
        }
        return engine;
    }

    public static DatabaseEngine getEngineForDriverClass(String driverClassName) {
        DatabaseEngine engine = enginesByDriverClass.get(driverClassName);
        if (engine == null) {
            throw new IllegalArgumentException("No database engine with driver class " + driverClassName + " found.");
        }
        return engine;
    }

    public static boolean hasEngineForDriverClass(String driverClassName) {
        return enginesByDriverClass.get(driverClassName) != null;
    }

    private static Map<String, DatabaseEngine> initEngineMap() {
        HashMap<String, DatabaseEngine> map = new HashMap<String, DatabaseEngine>();
        DatabaseEngine[] databaseEngineArray = DatabaseEngine.values();
        int n = databaseEngineArray.length;
        int n2 = 0;
        while (n2 < n) {
            DatabaseEngine engine = databaseEngineArray[n2];
            map.put(engine.code, engine);
            ++n2;
        }
        return map;
    }

    private static Map<String, DatabaseEngine> initEnginesByDriverClassMap() {
        HashMap<String, DatabaseEngine> map = new HashMap<String, DatabaseEngine>();
        DatabaseEngine[] databaseEngineArray = DatabaseEngine.values();
        int n = databaseEngineArray.length;
        int n2 = 0;
        while (n2 < n) {
            DatabaseEngine engine = databaseEngineArray[n2];
            map.put(engine.driverClass, engine);
            ++n2;
        }
        return map;
    }

    public static DatabaseEngine[] values() {
        DatabaseEngine[] databaseEngineArray = ENUM$VALUES;
        int n = databaseEngineArray.length;
        DatabaseEngine[] databaseEngineArray2 = new DatabaseEngine[n];
        System.arraycopy(ENUM$VALUES, 0, databaseEngineArray2, 0, n);
        return databaseEngineArray2;
    }

    public static DatabaseEngine valueOf(String string) {
        return Enum.valueOf(DatabaseEngine.class, string);
    }
}

