/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.plugins;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.properties.ExtendedProperties;
import ch.systemsx.cisd.etlserver.plugins.IHierarchicalStorageLinkNamingStrategy;
import ch.systemsx.cisd.openbis.generic.shared.dto.SimpleDataSetInformationDTO;
import java.io.File;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class TemplateBasedLinkNamingStrategy
implements IHierarchicalStorageLinkNamingStrategy {
    public static final String DEFAULT_LINK_TEMPLATE = "${space}/${project}/${experiment}/${dataSetType}+${sample}+${dataSet}";
    private static final String LINKS_TEMPLATE_PROP_NAME = "template";
    private static final String NOT_DIRECTLY_CONNECTED = "NOT_DIRECTLY_CONNECTED";
    private final String linkTemplate;

    public TemplateBasedLinkNamingStrategy(String template) {
        this.linkTemplate = template == null ? DEFAULT_LINK_TEMPLATE : template;
    }

    public TemplateBasedLinkNamingStrategy(Properties configurationProperties) {
        this(configurationProperties.getProperty(LINKS_TEMPLATE_PROP_NAME));
    }

    @Override
    public String createHierarchicalPath(SimpleDataSetInformationDTO data) {
        ExtendedProperties props = new ExtendedProperties();
        PathVariable[] pathVariableArray = PathVariable.values();
        int n = pathVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            PathVariable pathElement = pathVariableArray[n2];
            String pathElementName = pathElement.name();
            String pathElementValue = pathElement.extractValueFromData(data);
            if (pathElementValue == null) {
                pathElementValue = "";
            }
            props.put(pathElementName, pathElementValue);
            ++n2;
        }
        return this.evaluateTemplate(props);
    }

    @Override
    public Set<String> extractPaths(File root) {
        HashSet<String> set = new HashSet<String>();
        TemplateBasedLinkNamingStrategy.accumulateSymLinkPaths(set, root);
        return set;
    }

    private String evaluateTemplate(ExtendedProperties props) {
        props.put(LINKS_TEMPLATE_PROP_NAME, this.linkTemplate);
        return props.getProperty(LINKS_TEMPLATE_PROP_NAME);
    }

    @Private
    static void accumulateSymLinkPaths(HashSet<String> paths, File dir) {
        File[] children = dir.listFiles();
        if (children != null) {
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (FileUtilities.isSymbolicLink(child)) {
                    String absolutePath = child.getAbsolutePath();
                    paths.add(absolutePath);
                } else if (child.isDirectory()) {
                    TemplateBasedLinkNamingStrategy.accumulateSymLinkPaths(paths, child);
                }
                ++n2;
            }
        }
    }

    static enum PathVariable {
        dataSet{

            @Override
            String extractValueFromData(SimpleDataSetInformationDTO data) {
                return data.getDataSetCode();
            }
        }
        ,
        dataSetType{

            @Override
            String extractValueFromData(SimpleDataSetInformationDTO data) {
                return data.getDataSetType();
            }
        }
        ,
        sample{

            @Override
            String extractValueFromData(SimpleDataSetInformationDTO data) {
                String samplePathElement = data.getSampleCode();
                if (samplePathElement == null) {
                    samplePathElement = TemplateBasedLinkNamingStrategy.NOT_DIRECTLY_CONNECTED;
                }
                return samplePathElement;
            }
        }
        ,
        experiment{

            @Override
            String extractValueFromData(SimpleDataSetInformationDTO data) {
                return data.getExperimentCode();
            }
        }
        ,
        project{

            @Override
            String extractValueFromData(SimpleDataSetInformationDTO data) {
                return data.getProjectCode();
            }
        }
        ,
        space{

            @Override
            String extractValueFromData(SimpleDataSetInformationDTO data) {
                return data.getSpaceCode();
            }
        }
        ,
        instance{

            @Override
            String extractValueFromData(SimpleDataSetInformationDTO data) {
                return data.getDatabaseInstanceCode();
            }
        };


        abstract String extractValueFromData(SimpleDataSetInformationDTO var1);
    }
}

