/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl;

import ch.systemsx.cisd.base.image.IImageTransformer;
import ch.systemsx.cisd.base.utilities.OSUtilities;
import ch.systemsx.cisd.common.concurrent.FailureRecord;
import ch.systemsx.cisd.common.concurrent.ITaskExecutor;
import ch.systemsx.cisd.common.concurrent.ParallelizedExecutor;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.process.ProcessExecutionHelper;
import ch.systemsx.cisd.common.process.ProcessIOStrategy;
import ch.systemsx.cisd.common.process.ProcessResult;
import ch.systemsx.cisd.openbis.common.hdf5.HDF5Container;
import ch.systemsx.cisd.openbis.common.hdf5.IHDF5ContainerWriter;
import ch.systemsx.cisd.openbis.common.io.ByteArrayBasedContentNode;
import ch.systemsx.cisd.openbis.common.io.FileBasedContentNode;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.dss.etl.Utils;
import ch.systemsx.cisd.openbis.dss.etl.dto.ImageLibraryInfo;
import ch.systemsx.cisd.openbis.dss.etl.dto.RelativeImageFile;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.Channel;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ChannelColorComponent;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ImageFileInfo;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ImageStorageConfiguraton;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ThumbnailsStorageFormat;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.impl.ImageDataSetStructure;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.impl.ThumbnailsInfo;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.transformations.ImageTransformation;
import ch.systemsx.cisd.openbis.dss.generic.server.images.ImageChannelsUtils;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.Size;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.ImageUtil;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ColorComponent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class Hdf5ThumbnailGenerator
implements HDF5Container.IHDF5WriterClient {
    private static final File convertUtilityOrNull = OSUtilities.findExecutable((String)"convert");
    private static final Logger machineLog = LogFactory.getLogger(LogCategory.MACHINE, Hdf5ThumbnailGenerator.class);
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, Hdf5ThumbnailGenerator.class);
    private static final int MAX_RETRY_OF_FAILED_GENERATION = 3;
    private final ImageDataSetStructure imageDataSetStructure;
    private final Map<String, Map<String, ImageTransformation>> transformationsForChannels = new HashMap<String, Map<String, ImageTransformation>>();
    private final File imagesParentDirectory;
    private String thumbnailPhysicalDatasetPermId;
    private final ThumbnailsStorageFormat thumbnailsStorageFormat;
    private final ImageLibraryInfo imageLibraryOrNull;
    private final ThumbnailsInfo thumbnailPathCollector;
    private final Logger logger;
    private final Map<String, ColorComponent> channelColors = new HashMap<String, ColorComponent>();
    private final boolean registerOriginalImageAsThumbnail;
    private IHierarchicalContent contentOrNull;

    public static void tryGenerateThumbnails(ImageDataSetStructure imageDataSetStructure, File imagesParentDirectory, String thumbnailFilePath, ImageStorageConfiguraton imageStorageConfiguraton, String thumbnailPhysicalDatasetPermId, ThumbnailsStorageFormat thumbnailsStorageFormatOrNull, ThumbnailsInfo thumbnailPaths, boolean registerOriginalImageAsThumbnail, IHierarchicalContent content) {
        if (thumbnailsStorageFormatOrNull != null) {
            thumbnailPaths.putDataSet(thumbnailPhysicalDatasetPermId, thumbnailsStorageFormatOrNull.getThumbnailsFileName(), thumbnailsStorageFormatOrNull.getFileFormat(), thumbnailsStorageFormatOrNull.getTransformations());
            File thumbnailsFile = new File(thumbnailFilePath);
            HDF5Container container = new HDF5Container(thumbnailsFile);
            ImageLibraryInfo imageLibrary = imageStorageConfiguraton.tryGetImageLibrary();
            Hdf5ThumbnailGenerator thumbnailsGenerator = new Hdf5ThumbnailGenerator(imageDataSetStructure, imagesParentDirectory, thumbnailPhysicalDatasetPermId, thumbnailsStorageFormatOrNull, imageLibrary, thumbnailPaths, registerOriginalImageAsThumbnail, content, operationLog);
            container.runWriterClient(thumbnailsStorageFormatOrNull.isStoreCompressed(), thumbnailsGenerator);
        }
    }

    private Hdf5ThumbnailGenerator(ImageDataSetStructure imageDataSetStructure, File imagesParentDirectory, String thumbnailPhysicalDatasetPermId, ThumbnailsStorageFormat thumbnailsStorageFormat, ImageLibraryInfo imageLibraryOrNull, ThumbnailsInfo thumbnailPathCollector, boolean registerOriginalImageAsThumbnail, IHierarchicalContent contentOrNull, Logger operationLog) {
        this.imageDataSetStructure = imageDataSetStructure;
        this.imagesParentDirectory = imagesParentDirectory;
        this.thumbnailPhysicalDatasetPermId = thumbnailPhysicalDatasetPermId;
        this.thumbnailsStorageFormat = thumbnailsStorageFormat;
        this.imageLibraryOrNull = imageLibraryOrNull;
        this.thumbnailPathCollector = thumbnailPathCollector;
        this.registerOriginalImageAsThumbnail = registerOriginalImageAsThumbnail;
        this.contentOrNull = contentOrNull;
        this.logger = operationLog;
        for (Channel ch : imageDataSetStructure.getChannels()) {
            HashMap<String, ImageTransformation> transformations = new HashMap<String, ImageTransformation>();
            this.transformationsForChannels.put(ch.getCode(), transformations);
            if (ch.getAvailableTransformations() == null) continue;
            ImageTransformation[] imageTransformationArray = ch.getAvailableTransformations();
            int n = imageTransformationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ImageTransformation it = imageTransformationArray[n2];
                transformations.put(it.getCode().toUpperCase(), it);
                ++n2;
            }
        }
        if (imageDataSetStructure.getChannelColorComponents() != null && imageDataSetStructure.getChannelColorComponents().size() > 0) {
            int i = 0;
            while (i < imageDataSetStructure.getChannelColorComponents().size()) {
                this.channelColors.put(imageDataSetStructure.getChannels().get(i).getCode(), ChannelColorComponent.getColorComponent(imageDataSetStructure.getChannelColorComponents().get(i)));
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Status generateThumbnail(IHDF5ContainerWriter writer, ImageFileInfo image, ByteArrayOutputStream bufferOutputStream) {
        ArrayList<String> thumbnailPaths = new ArrayList<String>();
        for (String channelCode : this.getChannelsToProcess(image.getChannelCode())) {
            thumbnailPaths.add(this.createThumbnailPath(image, channelCode));
        }
        try {
            long start = System.currentTimeMillis();
            String imageIdOrNull = image.tryGetUniqueStringIdentifier();
            List<ThumbnailData> thumbnailData = this.generateThumbnail(bufferOutputStream, image, imageIdOrNull);
            int i = 0;
            while (i < thumbnailData.size()) {
                this.thumbnailPathCollector.saveThumbnailPath(this.thumbnailPhysicalDatasetPermId, RelativeImageFile.create(image), this.channelColors.get(thumbnailData.get(i).channelCode), (String)thumbnailPaths.get(i), thumbnailData.get(i).width, thumbnailData.get(i).height, thumbnailData.get(i).colorDepth);
                ++i;
            }
            if (this.logger.isDebugEnabled()) {
                int size = 0;
                for (ThumbnailData td : thumbnailData) {
                    size += td.data.length;
                }
                long now = System.currentTimeMillis();
                this.logger.debug((Object)(String.valueOf(Thread.currentThread().getName()) + " thumbnail " + ((Object)thumbnailPaths).toString() + " (" + size + " bytes) generated in " + (now - start) + " msec"));
            }
            IHDF5ContainerWriter iHDF5ContainerWriter = writer;
            synchronized (iHDF5ContainerWriter) {
                int i2 = 0;
                while (i2 < thumbnailData.size()) {
                    writer.writeToHDF5Container(String.valueOf((String)thumbnailPaths.get(i2)) + "." + this.thumbnailsStorageFormat.getFileFormat().getFileExtension(), new ByteArrayInputStream(thumbnailData.get(i2).data), thumbnailData.get(i2).data.length);
                    ++i2;
                }
            }
        }
        catch (IOException ex) {
            return this.createStatus(((Object)thumbnailPaths).toString(), ex);
        }
        return Status.OK;
    }

    private String createThumbnailPath(ImageFileInfo plateImage, String channelCode) {
        StringBuilder newImagePath = new StringBuilder();
        if (plateImage.hasWellLocation()) {
            newImagePath.append("w").append(plateImage.tryGetWellLocation().toWellIdString());
        }
        newImagePath.append(Hdf5ThumbnailGenerator.underscoreIfNeeded(newImagePath)).append("d").append(plateImage.getTileColumn()).append("-").append(plateImage.getTileRow());
        if (plateImage.tryGetTimepoint() != null) {
            newImagePath.append("_t").append(plateImage.tryGetTimepoint());
        }
        if (plateImage.tryGetSeriesNumber() != null) {
            newImagePath.append("_s").append(plateImage.tryGetSeriesNumber());
        }
        if (plateImage.tryGetDepth() != null) {
            newImagePath.append("_h").append(plateImage.tryGetDepth());
        }
        newImagePath.append("_c").append(channelCode);
        String imageIdOrNull = plateImage.tryGetUniqueStringIdentifier();
        if (imageIdOrNull != null) {
            newImagePath.append(imageIdOrNull);
        }
        return newImagePath.toString();
    }

    private static String underscoreIfNeeded(StringBuilder sb) {
        return sb.length() > 0 ? "_" : "";
    }

    private List<ThumbnailData> generateThumbnail(ByteArrayOutputStream bufferOutputStream, ImageFileInfo img, String imageIdOrNull) throws IOException {
        List<ThumbnailData> thumbnailData = this.registerOriginalImageAsThumbnail ? this.registerOriginalImageAsThumbnail(img) : (this.thumbnailsStorageFormat.isGenerateWithImageMagic() ? this.generateThumbnailWithImageMagic(img) : this.generateThumbnailInternally(img, imageIdOrNull, bufferOutputStream));
        return thumbnailData;
    }

    private List<ThumbnailData> registerOriginalImageAsThumbnail(ImageFileInfo imageFileInfo) {
        File imageFile = new File(this.imagesParentDirectory, imageFileInfo.getImageRelativePath());
        Size originalSize = this.loadUnchangedImageDimension(imageFileInfo.getImageRelativePath(), null);
        int colorDepth = this.loadUnchangedImageColorDepth(imageFileInfo.getImageRelativePath(), null);
        return Collections.singletonList(new ThumbnailData(FileUtilities.loadToByteArray(imageFile), originalSize.getWidth(), originalSize.getHeight(), colorDepth, imageFileInfo.getChannelCode()));
    }

    private List<ThumbnailData> generateThumbnailWithImageMagic(ImageFileInfo imageFileInfo) throws IOException {
        int width = this.thumbnailsStorageFormat.getMaxWidth();
        int height = this.thumbnailsStorageFormat.getMaxHeight();
        if (this.thumbnailsStorageFormat.getZoomLevel() != null) {
            Size originalSize = this.loadUnchangedImageDimension(imageFileInfo.getImageRelativePath(), null);
            double zoomLevel = this.thumbnailsStorageFormat.getZoomLevel();
            width = (int)Math.round(zoomLevel * (double)originalSize.getWidth());
            height = (int)Math.round(zoomLevel * (double)originalSize.getHeight());
        }
        String size = String.valueOf(width) + "x" + height;
        int colorDepth = this.loadUnchangedImageColorDepth(imageFileInfo.getImageRelativePath(), null);
        String imageFilePath = null;
        imageFilePath = this.contentOrNull == null ? new File(this.imagesParentDirectory, imageFileInfo.getImageRelativePath()).getPath() : this.contentOrNull.getNode(imageFileInfo.getImageRelativePath()).getFile().getPath();
        ArrayList<String> params = new ArrayList<String>();
        params.addAll(Arrays.asList(convertUtilityOrNull.getPath(), imageFilePath, "-scale", size));
        List<String> additionalParams = this.thumbnailsStorageFormat.getImageMagicParams();
        if (additionalParams != null) {
            params.addAll(additionalParams);
        }
        params.add(String.valueOf(this.thumbnailsStorageFormat.getFileFormat().getImageMagickParam()) + ":-");
        ProcessResult result = ProcessExecutionHelper.run(params, this.logger, machineLog, -1L, ProcessIOStrategy.BINARY_DISCARD_STDERR_IO_STRATEGY, false);
        if (!result.isOK()) {
            throw new IOException(String.format("Error calling 'convert' for image '%s'. Exit value: %d, I/O status: %s", new Object[]{imageFilePath, result.getExitValue(), result.getProcessIOResult().getStatus()}));
        }
        if (this.imageDataSetStructure.getChannelColorComponents() != null && this.imageDataSetStructure.getChannelColorComponents().size() > 0 || this.isTransformationAvailable(imageFileInfo.getChannelCode())) {
            ArrayList<ThumbnailData> thumbnails = new ArrayList<ThumbnailData>();
            for (String channelCode : this.getChannelsToProcess(imageFileInfo.getChannelCode())) {
                BufferedImage thumbnail = Utils.loadUnchangedImage(new ByteArrayBasedContentNode(result.getBinaryOutput(), null), null, this.imageLibraryOrNull);
                thumbnail = this.applyTransformationsChain(thumbnail, channelCode, this.channelColors.get(channelCode));
                ByteArrayOutputStream bufferOutputStream = new ByteArrayOutputStream();
                this.thumbnailsStorageFormat.getFileFormat().writeImage(thumbnail, bufferOutputStream);
                thumbnails.add(new ThumbnailData(bufferOutputStream.toByteArray(), width, height, colorDepth, channelCode));
            }
            return thumbnails;
        }
        return Collections.singletonList(new ThumbnailData(result.getBinaryOutput(), width, height, colorDepth, imageFileInfo.getChannelCode()));
    }

    private boolean isTransformationAvailable(String channelCode) {
        Map<String, ImageTransformation> transformationsForChannel = this.transformationsForChannels.get(channelCode);
        return transformationsForChannel != null && transformationsForChannel.containsKey(this.thumbnailsStorageFormat.getTransformationCode(channelCode));
    }

    private List<ThumbnailData> generateThumbnailInternally(ImageFileInfo imageFileInfo, String imageIdOrNull, ByteArrayOutputStream bufferOutputStream) throws IOException {
        BufferedImage image = this.loadUnchangedImage(imageFileInfo.getImageRelativePath(), imageIdOrNull);
        int widht = this.thumbnailsStorageFormat.getMaxWidth();
        int height = this.thumbnailsStorageFormat.getMaxHeight();
        if (this.thumbnailsStorageFormat.getZoomLevel() != null) {
            widht = (int)Math.round(this.thumbnailsStorageFormat.getZoomLevel() * (double)image.getWidth());
            height = (int)Math.round(this.thumbnailsStorageFormat.getZoomLevel() * (double)image.getHeight());
        }
        BufferedImage thumbnail = ImageUtil.rescale(image, widht, height, false, this.thumbnailsStorageFormat.isHighQuality());
        ArrayList<ThumbnailData> thumbnails = new ArrayList<ThumbnailData>();
        for (String channelCode : this.getChannelsToProcess(imageFileInfo.getChannelCode())) {
            thumbnail = this.applyTransformationsChain(thumbnail, channelCode, this.channelColors.get(channelCode));
            this.thumbnailsStorageFormat.getFileFormat().writeImage(thumbnail, bufferOutputStream);
            thumbnails.add(new ThumbnailData(bufferOutputStream.toByteArray(), thumbnail.getWidth(), thumbnail.getHeight(), thumbnail.getColorModel().getPixelSize(), channelCode));
        }
        return thumbnails;
    }

    private Collection<String> getChannelsToProcess(String channelCode) {
        if (this.imageDataSetStructure.getChannelColorComponents() != null && this.imageDataSetStructure.getChannelColorComponents().size() > 0) {
            return this.channelColors.keySet();
        }
        return Collections.singleton(channelCode);
    }

    private BufferedImage applyTransformationsChain(BufferedImage image, ColorComponent colorComponent, IImageTransformer transformer) {
        return Hdf5ThumbnailGenerator.applyTransformationIfNeeded(Hdf5ThumbnailGenerator.extractSingleChannelIfNeeded(image, colorComponent), transformer);
    }

    private BufferedImage applyTransformationsChain(BufferedImage image, String channelCode, ColorComponent colorComponent) {
        return this.applyTransformationsChain(image, colorComponent, this.tryCreateImageTransformer(channelCode));
    }

    private static BufferedImage extractSingleChannelIfNeeded(BufferedImage image, ColorComponent colorComponent) {
        if (colorComponent != null) {
            return ImageChannelsUtils.transformToChannel(image, colorComponent);
        }
        return image;
    }

    private static BufferedImage applyTransformationIfNeeded(BufferedImage image, IImageTransformer transformer) {
        if (transformer != null) {
            return transformer.transform(image);
        }
        return image;
    }

    private IImageTransformer tryCreateImageTransformer(String channelCode) {
        String transformationCodeOrNull = this.thumbnailsStorageFormat.getTransformationCode(channelCode);
        if (transformationCodeOrNull != null) {
            ImageTransformation it;
            Map<String, ImageTransformation> transformationsForChannel = this.transformationsForChannels.get(channelCode);
            ImageTransformation imageTransformation = it = transformationsForChannel == null ? null : transformationsForChannel.get(transformationCodeOrNull.toUpperCase());
            if (it != null) {
                return it.getImageTransformerFactory().createTransformer();
            }
        }
        return null;
    }

    private BufferedImage loadUnchangedImage(String imageRelativePath, String imageIdOrNull) {
        if (this.contentOrNull == null) {
            return Utils.loadUnchangedImage(new FileBasedContentNode(new File(this.imagesParentDirectory, imageRelativePath)), imageIdOrNull, this.imageLibraryOrNull);
        }
        return Utils.loadUnchangedImage(this.contentOrNull.getNode(imageRelativePath), imageIdOrNull, this.imageLibraryOrNull);
    }

    private Size loadUnchangedImageDimension(String imageRelativePath, String imageIdOrNull) {
        if (this.contentOrNull == null) {
            return Utils.loadUnchangedImageSize(new FileBasedContentNode(new File(this.imagesParentDirectory, imageRelativePath)), imageIdOrNull, this.imageLibraryOrNull);
        }
        return Utils.loadUnchangedImageSize(this.contentOrNull.getNode(imageRelativePath), imageIdOrNull, this.imageLibraryOrNull);
    }

    private int loadUnchangedImageColorDepth(String imageRelativePath, String imageIdOrNull) {
        if (this.contentOrNull == null) {
            return Utils.loadUnchangedImageColorDepth(new FileBasedContentNode(new File(this.imagesParentDirectory, imageRelativePath)), imageIdOrNull, this.imageLibraryOrNull);
        }
        return Utils.loadUnchangedImageColorDepth(this.contentOrNull.getNode(imageRelativePath), imageIdOrNull, this.imageLibraryOrNull);
    }

    private Status createStatus(String thumbnailPath, IOException ex) {
        this.logger.warn((Object)("Retriable error when creating thumbnail '" + thumbnailPath + "'"), (Throwable)ex);
        return Status.createRetriableError(String.format("Could not generate a thumbnail '%s': %s", thumbnailPath, ex.getMessage()));
    }

    private ITaskExecutor<ImageFileInfo> createThumbnailGenerator(final IHDF5ContainerWriter writer) {
        return new ITaskExecutor<ImageFileInfo>(){
            private ThreadLocal<ByteArrayOutputStream> outputStreamBuffers = new ThreadLocal<ByteArrayOutputStream>(){

                @Override
                protected ByteArrayOutputStream initialValue() {
                    return new ByteArrayOutputStream();
                }
            };

            @Override
            public Status execute(ImageFileInfo image) {
                ByteArrayOutputStream outputStreamBuffer = this.outputStreamBuffers.get();
                outputStreamBuffer.reset();
                return Hdf5ThumbnailGenerator.this.generateThumbnail(writer, image, outputStreamBuffer);
            }
        };
    }

    @Override
    public void runWithSimpleWriter(IHDF5ContainerWriter writer) {
        String thumbnailsName = " (" + this.thumbnailsStorageFormat.getThumbnailsFileName() + ")";
        Collection<FailureRecord<ImageFileInfo>> errors = ParallelizedExecutor.process(this.imageDataSetStructure.getImages(), this.createThumbnailGenerator(writer), this.thumbnailsStorageFormat.getAllowedMachineLoadDuringGeneration(), 100, "Thumbnails generation" + thumbnailsName, 3, true);
        if (errors.size() > 0) {
            throw new IllegalStateException(String.format("There were errors when generating %d thumbnails" + thumbnailsName + ", the whole thumbnails generation process fails.", errors.size()));
        }
    }

    private static class ThumbnailData {
        private final byte[] data;
        private final int width;
        private final int height;
        private final int colorDepth;
        private final String channelCode;

        private ThumbnailData(byte[] data, int width, int height, int colorDepth, String channelCode) {
            this.data = data;
            this.width = width;
            this.height = height;
            this.colorDepth = colorDepth;
            this.channelCode = channelCode;
        }
    }
}

