/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl;

import ch.systemsx.cisd.base.image.IImageTransformerFactory;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ColorComponent;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgImageDTO;

public class PrefixedImage {
    private final String pathPrefix;
    private final String pathSuffix;
    private final String singleChannelTransformationCodeOrNull;
    private final ImgImageDTO image;

    public PrefixedImage(String pathPrefix, String pathSuffix, String singleChannelTransformationCodeOrNull, ImgImageDTO image) {
        this.pathPrefix = pathPrefix;
        this.pathSuffix = pathSuffix;
        this.singleChannelTransformationCodeOrNull = singleChannelTransformationCodeOrNull;
        this.image = image;
    }

    public String getFilePath() {
        if (StringUtils.isBlank(this.pathPrefix)) {
            return this.image.getFilePath();
        }
        return String.valueOf(this.pathPrefix) + "/" + this.image.getFilePath() + (StringUtils.isBlank(this.pathSuffix) ? "" : "." + this.pathSuffix);
    }

    public ColorComponent getColorComponent() {
        return this.image.getColorComponent();
    }

    public String getImageID() {
        return this.image.getImageID();
    }

    public IImageTransformerFactory tryGetImageTransformerFactory() {
        return this.image.tryGetImageTransformerFactory();
    }

    public String tryGetSingleChannelTransformationCode() {
        return this.singleChannelTransformationCodeOrNull;
    }
}

