/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.custom.geexplorer;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.common.geometry.ConversionUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GEExplorerImageAnalysisResultParser
extends DefaultHandler {
    private static final String MEASURE_TAG = "Measure";
    private static final String WELL_TAG = "Well";
    private static final String DATA_TAG = "Data";
    private static final String ANALYSIS_TAG = "AutoLeadAnalysisProtocol";
    private static final String ASSAY_TAG = "AutoLeadAssay";
    private State state = State.INIT;
    private String analysisProtocolWithVersion = "";
    private String assayWithVersion = "";
    private String currentWellId;
    private HashSet<String> wells = new HashSet();
    private LinkedHashSet<String> featureNames = new LinkedHashSet();
    private HashMap<String, HashMap<String, Number>> features = new HashMap();

    public GEExplorerImageAnalysisResultParser(String fileName) throws ParserConfigurationException, SAXException, IOException {
        assert (fileName != null);
        this.parseDocument(fileName);
    }

    private void parseDocument(String fileName) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        SAXParser sp = spf.newSAXParser();
        sp.parse(fileName, (DefaultHandler)this);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        switch (this.state) {
            case INIT: {
                if (!DATA_TAG.equals(qName)) break;
                this.state = State.DATA;
                break;
            }
            case DATA: {
                if (!ANALYSIS_TAG.equals(qName)) break;
                this.analysisProtocolWithVersion = this.parseNameAndVersion(attributes);
                this.state = State.ANALYSIS;
                break;
            }
            case ANALYSIS: {
                if (!ASSAY_TAG.equals(qName)) break;
                this.assayWithVersion = this.parseNameAndVersion(attributes);
                this.state = State.TABLE;
                break;
            }
            case TABLE: {
                if (!WELL_TAG.equals(qName)) break;
                int row = Integer.parseInt(attributes.getValue("row"));
                int col = Integer.parseInt(attributes.getValue("col"));
                this.currentWellId = String.format("%s%02d", ConversionUtils.translateRowNumberIntoLetterCode(row), col);
                this.wells.add(this.currentWellId);
                this.features.put(this.currentWellId, new HashMap());
                this.state = State.WELL;
                break;
            }
            case WELL: {
                if (!MEASURE_TAG.equals(qName)) break;
                String name = attributes.getValue("name");
                this.featureNames.add(name);
                String valStr = attributes.getValue("value");
                try {
                    if (valStr.indexOf(46) >= 0 || valStr.indexOf(69) >= 0 || valStr.indexOf(101) >= 0) {
                        double value = Double.parseDouble(valStr);
                        this.features.get(this.currentWellId).put(name, value);
                        break;
                    }
                    long value = Long.parseLong(valStr);
                    this.features.get(this.currentWellId).put(name, value);
                }
                catch (NumberFormatException numberFormatException) {
                    this.features.get(this.currentWellId).put(name, Double.NaN);
                }
                break;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.state != State.WELL && this.state != State.TABLE) {
            return;
        }
        if (WELL_TAG.equals(qName)) {
            this.state = State.TABLE;
        }
        if (DATA_TAG.equals(qName)) {
            this.state = State.FINISHED;
        }
    }

    public List<String> getFeatureNames() {
        return new ArrayList<String>(this.featureNames);
    }

    public List<String> getWellIds() {
        ArrayList<String> list = new ArrayList<String>(this.wells);
        Collections.sort(list);
        return list;
    }

    public HashMap<String, Number> getFeaturesForWell(String wellId) {
        return this.features.get(wellId);
    }

    public void writeCSV(File resultFile) throws IOExceptionUnchecked {
        PrintStream out;
        try {
            out = new PrintStream(resultFile);
        }
        catch (FileNotFoundException ex) {
            throw new IOExceptionUnchecked((IOException)ex);
        }
        out.print(WELL_TAG);
        List<String> fNames = this.getFeatureNames();
        for (String feature : fNames) {
            out.print("," + feature);
        }
        out.println();
        for (String wellId : this.getWellIds()) {
            out.print(wellId);
            HashMap<String, Number> fValues = this.getFeaturesForWell(wellId);
            for (String name : fNames) {
                out.print("," + fValues.get(name));
            }
            out.println();
        }
        out.close();
    }

    public String getAnalysisProcedureName() {
        if (StringUtils.isEmpty((String)this.analysisProtocolWithVersion)) {
            return this.assayWithVersion;
        }
        return String.valueOf(this.assayWithVersion) + "_" + this.analysisProtocolWithVersion;
    }

    private String parseNameAndVersion(Attributes attributes) {
        String name = this.parseAttribute("name", attributes);
        String version = this.parseAttribute("version", attributes);
        if (StringUtils.isEmpty((String)version)) {
            return name;
        }
        return String.valueOf(name) + "_v" + version;
    }

    private String parseAttribute(String attrName, Attributes attributes) {
        String attrValue = attributes.getValue(attrName);
        return StringUtils.trimToEmpty((String)attrValue);
    }

    private static enum State {
        INIT,
        ANALYSIS,
        DATA,
        TABLE,
        WELL,
        FINISHED;

    }
}

